# Przykadowy kod z ksiki Ruby. Programowanie
require 'win32ole'

$urls = []

def navigate(url)
  $urls << url
end

def stop_msg_loop
  puts "IE zakoczya dziaanie..."
  throw :done
end

def default_handler(event, *args)
  case event
  when "BeforeNavigate"
    puts "Przejcie do strony #{args[0]}..."
  end
end

ie = WIN32OLE.new('InternetExplorer.Application')
ie.visible = TRUE
ie.gohome
ev = WIN32OLE_EVENT.new(ie, 'DWebBrowserEvents')

ev.on_event {|*args| default_handler(*args)}
ev.on_event("NavigateComplete") {|url| navigate(url)}
ev.on_event("Quit") {|*args| stop_msg_loop}

catch(:done) do
  loop do
    WIN32OLE_EVENT.message_loop
  end
end

puts "Odwiedzie strony o nastpujcych adresach URL: "
$urls.each_with_index do |url, i|
  puts "(#{i+1}) #{url}"
end

