# Przykadowy kod z ksiki Ruby. Programowanie
require 'tk'

class GifViewer

  def initialize(filelist)
    setup_viewer(filelist)
  end

  def run
    Tk.mainloop
  end

  def setup_viewer(filelist)
    @root = TkRoot.new {title 'Lista przewijana'}
    frame = TkFrame.new(@root)

    image_w = TkPhotoImage.new
    TkLabel.new(frame) do
      image image_w
      pack 'side'=>'right'
    end

    list_w = TkListbox.new(frame) do
      selectmode 'single'
      pack 'side' => 'left'
    end

    list_w.bind("ButtonRelease-1") do
      busy do
        filename = list_w.get(*list_w.curselection)
        tmp_img = TkPhotoImage.new { file filename }
        scale = tmp_img.height / 100
        scale = 1 if scale < 1
        image_w.copy(tmp_img, 'subsample' => [scale, scale])
        image_w.pack
      end
    end

    filelist.each do |name|
      list_w.insert('end', name) # Umieszcza na licie nazwy wszystkich plikw 
    end

    scroll_bar = TkScrollbar.new(frame) do
      command {|*args| list_w.yview *args }
      pack 'side' => 'left', 'fill' => 'y'
    end

    list_w.yscrollcommand {|first,last| scroll_bar.set(first,last) }
    frame.pack
  end

  # Uruchamia blok z kursorem oczekiwania
  def busy
    @root.cursor "watch" # Ustawia kursor klepsydry
    yield
  ensure
    @root.cursor "" # Przywraca oryginalny stan kursora
end

end

viewer = GifViewer.new(Dir["screenshots/gifs/*.gif"])
viewer.run

