# Przykadowy kod z ksiki Ruby. Programowanie
list_w = TkListbox.new(frame) do
  selectmode 'single'
  pack 'side' => 'left'
end

list_w.bind("ButtonRelease-1") do
  busy do
    filename = list_w.get(*list_w.curselection)
    tmp_img = TkPhotoImage.new { file filename }
    scale = tmp_img.height / 100
    scale = 1 if scale < 1
    image_w.copy(tmp_img, 'subsample' => [scale, scale])
    image_w.pack
  end
end

scroll_bar = TkScrollbar.new(frame) do
  command {|*args| list_w.yview *args }
  pack 'side' => 'left', 'fill' => 'y'
end

list_w.yscrollcommand {|first,last| scroll_bar.set(first,last) }
