# Przykładowy kod z książki Ruby. Programowanie
require 'monitor'

class Counter
  # jak wcześniej...
  attr_reader :count
  def initialize
    @count = 0
    super
  end
  def tick
    @count += 1
  end
end

c = Counter.new
c.extend(MonitorMixin)

t1 = Thread.new { 10000.times {  c.synchronize { c.tick } } }
t2 = Thread.new { 10000.times {  c.synchronize { c.tick } } }

t1.join; t2.join
c.count
