# Przykładowy kod z książki Ruby. Programowanie
  class RetryException < RuntimeError
    attr :ok_to_retry
    def initialize(ok_to_retry)
      @ok_to_retry = ok_to_retry
    end
  end
  def read_data(socket)
    data = socket.read(512)
    if data.nil?
      raise RetryException.new(true), "transient read error"
    end
    # .. normalne przetwarzanie
  end
    socket = STDIN
  begin
    stuff = read_data(socket)
    # .. przetwarzaj
  rescue RetryException => detail
    retry if detail.ok_to_retry
    raise
  end
