# Przykadowy kod z ksiki Ruby. Programowanie
require 'zlib'

# Ponisze metody mog przyjmowa nazw pliku
Zlib::GzipWriter.open("passwd.gz") do |gz|
  gz.write(File.read("/etc/passwd"))
end

system("ls -l /etc/passwd passwd.gz")

# lub strumie
File.open("passwd.gz") do |f|
  gzip = Zlib::GzipReader.new(f)
  data = gzip.read.split(/\n/)
  puts data[15,3]
end


rd, wr = IO.pipe

if fork
  rd.close
  zipper = Zlib::Deflate.new
  zipper << "To acuch znakw "
  data = zipper.deflate("do spakowania", Zlib::FINISH)
  wr.write(data)
  wr.close
  Process.wait
else
  wr.close
  unzipper = Zlib::Inflate.new
  unzipper << rd.read
  puts "Otrzymano: #{unzipper.inflate(nil)}"
end
