# Przykadowy kod z ksiki Ruby. Programowanie
#!/usr/bin/ruby

require 'webrick'
include WEBrick

hello_proc = lambda do |req, resp|
  resp['Content-Type'] = "text/html"
  resp.body = %{
    <html><body>
      Witaj. Wywoanie pochodzi z #{req['UserAgent']}
    <p>
      Dostpne parametry: #{req.query.keys.join(', ')}
    </body></html>
  }
end

bye_proc = lambda do |req, resp|
  resp['Content-Type'] = "text/html"
  resp.body = %{
    <html><body>
      <h3>Do zobaczenia!</h3>
    </body></html>
  }
end

hello = HTTPServlet::ProcHandler.new(hello_proc)
bye = HTTPServlet::ProcHandler.new(bye_proc)

s = HTTPServer.new(:Port => 2000)
s.mount("/hello", hello)
s.mount("/bye", bye)

trap("INT"){ s.shutdown }
s.start

