# Przykadowy kod z ksiki Ruby. Programowanie
require 'stringio'
require 'csv'
require 'test/unit'

sio = StringIO.new("time flies like an arrow")

sio.read(5)
sio.read(5)
sio.pos = 18
sio.read(5)
sio.rewind
sio.write("fruit")
sio.pos = 16
sio.write("a banana")
sio.rewind
sio.read              

class TestCSV < Test::Unit::TestCase

  def test_simple
    StringIO.open do |op|
      CSV::Writer.generate(op) do |csv|
        csv << [ 1, "line 1", 27 ]
        csv << [ 2, nil, 123 ]
      end
      assert_equal("1,line 1,27\n2,,123\n", op.string)
    end
  end

end

