# Przykadowy kod z ksiki Ruby. Programowanie
require 'etc'
require 'set'

set1 = Set.new([:wilk, :kot, :dzik])

set1.include?(:osa)
set1.add(:lis)

partition = set1.classify {|element| element.to_s.length }

partition

set2 = [ :kot, :pies, :krowa ].to_set
set1 | set2
set1 & set2
set1 - set2
set1 ^ set2 

users = []
  Etc.passwd {|u| users << u }

related_users = users.to_set.divide do |u1, u2|
  (u1.uid - u2.uid).abs <= 1
end

related_users.each do |relatives|
  relatives.each {|u| print "#{u.uid}/#{u.name} " }
  puts
end
