# Przykadowy kod z ksiki Ruby. Programowanie
require 'ftools'

def install_if_different(source, dest)
  if File.exist?(dest) && File.compare(source, dest)
    puts "#{dest} jest aktualny"
  else
    File.copy(source, dest)
    puts "#{source} skopiowano do #{dest}"
  end
end

install_if_different('testfile', '/tmp/testfile')
puts "Drugi raz..."
install_if_different('testfile', '/tmp/testfile')
puts "Gotowe"

File.install('testfile', '/tmp', 0644, true)
puts "Drugi raz..."
File.install('testfile', '/tmp', 0644, true)
puts "Gotowe"

