# Przykadowy kod z ksiki Ruby. Programowanie
require 'forwardable'

class SymbolTable
  extend Forwardable
  def_delegator(:@hash, :[], :lookup)
  def_delegator(:@hash, :[]=, :add)
  def_delegators(:@hash, :size, :has_key?)
  def initialize
    @hash = Hash.new
  end
end

st = SymbolTable.new
st.add('kot', 'zwierz kotowate')
st.add('pies', 'zwierz psowate')
st.add('krowa', 'zwierz nalece do bovini')

st.has_key?('krowa')
st.lookup('pies')

TRICKS = [ "turlanie", "udawanie martwego" ]
dog = "rover"
dog.extend SingleForwardable
dog.def_delegator(:TRICKS, :each, :can)
dog.can do |trick|
  puts trick
end

