# Przykadowy kod z ksiki Ruby. Programowanie
require 'cgi'
require 'cgi/session'

cgi = CGI.new("html3")
sess = CGI::Session.new(cgi,
                        "session_key" => "rubyweb",
                        "prefix" => "websession."
                        )

if sess['lastaccess']
  msg = "Ostatnio odwiedzie stron #{sess['lastaccess']}."
else
  msg = "Wyglda na to, e dawno nas nie odwiedzae"
end

count = (sess["accesscount"] || 0).to_i
count += 1

msg << "<p>Liczba odwiedzin: #{count}"

sess["accesscount"] = count
sess["lastaccess"] = Time.now.to_s
sess.close

cgi.out {
  cgi.html {
    cgi.body {
       msg
    }
  }
}
