# Przykładowy kod z książki Ruby. Programowanie
require 'cgi'
require 'cgi/session'

cgi = CGI.new("html3")
sess = CGI::Session.new(cgi,
                       "session_key" => "rubyweb",
                       "prefix" => "websession."
                       )

if sess['lastaccess']
  msg = "Ostanio byłeś tu #{sess['lastaccess']}."
else
  msg = "Wygląda na to, że dawno tu nie byłeś"
end

count = (sess["accesscount"] || 0).to_i
count += 1

msg << "<p>Licznik wizyt: #{count}"

sess["accesscount"] = count
sess["lastaccess"] = Time.now.to_s
sess.close

cgi.out {
  cgi.html {
    cgi.body {
      msg
    }
  }
}

