# Przykładowy kod z książki Ruby. Programowanie
#!/usr/bin/ruby

require 'webrick'
include WEBrick

s = HTTPServer.new( :Port => 2000 )

class HelloServlet < HTTPServlet::AbstractServlet
  def do_GET(req, res)
    res['Content-Type'] = "text/html"
    res.body = %{
      <html><body>
        Witaj. Używasz przeglądarki #{req['User-Agent']}
       <p>
        Rozpoznane parametry: #{req.query.keys.join(', ')}
      </body></html>
    }
  end
end

s.mount("/hello", HelloServlet)

trap("INT"){ s.shutdown }

s.start  

