# Przykładowy kod z książki Ruby. Programowanie
# == Synopsis
#
# Wyświetl bieżącą datę i czas, opcjonalnie uwzględniaj
# łańcuch formatujący.
#
# == Usage
#
#    ruby showtime.rb  [ -h | --help ] [ -f | --fmt fmtstring ]
#
# fmtstring::
#    Formatujący łańcuch znaków +strftime+ kontroluje
#    sposób wyświetlania daty i czasu. Jeśli jest pominięty, 
#    używany jest łańcuch <em>"%Y-%M-%d %H:%m"</em>
#
# == Author
# Dave Thomas, The Pragmatic Programmers, LLC
#
# == Copyright
# Copyright (c) 2004 The Pragmatic Programmers.
# Licensed under the same terms as Ruby.

require 'optparse'
require 'rdoc/usage'

fmt = "%Y-%M-%d %H:%m"
opts = OptionParser.new
opts.on("-h", "--help") { RDoc::usage }
opts.on("-f", "--fmt FMTSTRING") {|str| fmt = str }
opts.parse(ARGV) rescue RDoc::usage('usage')

puts Time.now.strftime(fmt)
