# Przykładowy kod z książki Ruby. Programowanie
require 'monitor'

SONGS = [
  'Blue Suede Shoes',
  'Take Five',
  'Bye Bye Love',
  'Rock Around The Clock',
  'Ruby Tuesday'
]

START_TIME = Time.now

def timestamp
  (Time.now - START_TIME).to_i
end

# oczekuj do dwóch minut pomiędzy żądaniami odegrania utworu
def get_customer_request
  sleep(120 * rand)
  song = SONGS.shift
  puts "#{timestamp}: Wybrano #{song}" if song
  song
end

# piosenki trwają od dwóch do trzech minut
def play(song)
  puts "#{timestamp}: Odgrywam #{song}"
  sleep(120 + 60*rand)
end

ok_to_shutdown = false

# a oto nasz oryginalny kod
playlist = []
playlist.extend(MonitorMixin)
plays_pending = playlist.new_cond

# wątek wyboru utworów
customer = Thread.new do
  loop do
    req = get_customer_request
    break unless req
    playlist.synchronize do
      playlist << req
      plays_pending.signal
    end
  end
end

# wątek urządzenia odtwarzającego
player = Thread.new do
  loop do
    song = nil
    playlist.synchronize do
      break if ok_to_shutdown && playlist.empty?
      plays_pending.wait_while { playlist.empty? }
      song = playlist.shift
    end
    break unless song
    play(song)
  end
end

customer.join
ok_to_shutdown = true
player.join
