# Przykładowy kod z książki Ruby. Programowanie
  class VU
    include Comparable

    attr :volume

    def initialize(volume)  # 0..9
      @volume = volume
    end

    def inspect
      '#' * @volume
    end

    # metody niezbędne dla obiektów przedziałów
    def <=>(other)
      self.volume <=> other.volume
    end

    def succ
      raise(IndexError, "Zbyt duże natężenie głośności") if @volume >= 9
      VU.new(@volume.succ)
    end
  end
