# Przykładowy kod z książki Ruby. Programowanie
class Song
  include Comparable
  @@plays = 0
  attr_reader :name, :artist, :duration
  attr_writer :duration
  def initialize(name, artist, duration)
    @name     = name
    @artist   = artist
    @duration = duration
    @plays    = 0
  end
  def to_s
    "Utwór: #@name--#@artist (#@duration)"
  end
  def name
    @name
  end
  def artist
    @artist
  end
  def duration
    @duration
  end
  def duration=(new_duration)
    @duration = new_duration
  end
  def duration_in_minutes
    @duration/60.0 # wymuszamy konwersję zmiennoprzecinkową
  end
  def duration_in_minutes=(new_duration)
    @duration = (new_duration*60).to_i
  end
  def play
    @plays += 1 # równoważne @plays = @plays + 1
    @@plays += 1
   "Aktualny utwór: #@plays odegrań. Całkowita liczba: #@@plays odegrań."
  end
  def record
    "Nagrywanie..."
  end
  def inspect
    self.to_s
  end
  def <=>(other)
    self.duration <=> other.duration
  end
end
class KaraokeSong < Song
  def initialize(name, artist, duration, lyrics)
    super(name, artist, duration)
    @lyrics = lyrics
  end
  # Przekształćmy się w łańcuch znakowy dopisując
  # nasz tekst piosenki do wartości #to_s rodzica.
  def to_s
    super + " [#@lyrics]" 
  end
end
class KaraokeSong
  # ...
  def to_s
    "KS: #@name--#@artist (#@duration) [#@lyrics]" 
  end
end
song = KaraokeSong.new("My Way", "Sinatra", 225, "And now, the...")
song.to_s
