/*  Rozdzia 15. ServerNP_secure - opracowany na podstawie programu serverNP.c z rozdziau 11.
 *	Wielowtkowy serwer do przetwarzania wiersza polece. Wersja z potokami nazwanymi.
 *	Stosowanie:	Server [nazwaUzytkownika nazwaGrupy]
 *	JEDEN WTEK I EGZEMPLARZ POTOKU DLA KADEGO KLIENTA. */

#include "Everything.h"
#include "ClientServer.h" /* Definicje komunikatw z daniem i odpowiedzi. */

typedef struct {				/* Argument wtku serwera. */
	HANDLE hNamedPipe;			/* Egzemplarz potoku nazwanego. */
	DWORD ThreadNo;
	TCHAR TmpFileName [MAX_PATH]; /* Nazwa pliku tymczasowego. */
} THREAD_ARG;
typedef THREAD_ARG *LPTHREAD_ARG;

volatile static BOOL ShutDown = FALSE;
static DWORD WINAPI Server (LPTHREAD_ARG);
static DWORD WINAPI Connect (LPTHREAD_ARG);
static DWORD WINAPI ServerBroadcast (LPLONG);
static BOOL  WINAPI Handler (DWORD);
static TCHAR ShutRqst [] = _T ("$ShutDownServer");

_tmain (int argc, LPTSTR argv [])
{
	/* Warto MAX_CLIENTS jest zdefiniowana w pliku ClientServer.h. */
    /* W wtku gwnym do oczekiwania na wtki serwera uyto funkcji */
    /* WaitForMultipleObjects z ograniczeniem do MAXIMUM_WAIT_OBJECTS obiektw. */

	HANDLE hNp, hMonitor, hSrvrThread [MAX_CLIENTS], hSecHeap = NULL;
	DWORD iNp, MonitorId, ThreadId;
	DWORD AceMasks [] =	/* Uprawnienia dostpu do potoku nazwanego - tylko klienty
		* uruchomione przez waciciela mog nawiza poczenie. */
		{FILE_GENERIC_READ | FILE_GENERIC_WRITE, 0, 0 };
	LPSECURITY_ATTRIBUTES pNPSA = NULL;
	THREAD_ARG ThArgs [MAX_CLIENTS];

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	/* Procedura sterujca konsoli umoliwiajca zamknicie serwera. */
	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T("Nie mozna utworzyc procedury sterujacej."), 1, TRUE);

	
	if (argc == 4)		/* Opcjonalne zabezpieczenia potoku. */
		pNPSA = InitializeAccessOnlySA (0440, argv [1], argv [2], AceMasks, &hSecHeap);
			
	/* Tworzenie wtku do okresowego rozpowszechniania nazwy potoku. */
	hMonitor = (HANDLE) _beginthreadex (NULL, 0, ServerBroadcast, NULL, 0, &MonitorId);

	/*	Tworzenie egzemplarza potoku dla kadego wtku serwera.
     * Tworzenie nazwy pliku tymczasowego dla kadego wtku.
     * Tworzenie wtku do obsugi danego potoku. */

	for (iNp = 0; iNp < MAX_CLIENTS; iNp++) {
		hNp = CreateNamedPipe ( SERVER_PIPE, PIPE_ACCESS_DUPLEX,
				PIPE_READMODE_MESSAGE | PIPE_TYPE_MESSAGE | PIPE_WAIT,
				MAX_CLIENTS, 0, 0, INFINITE, pNPSA);

		if (hNp == INVALID_HANDLE_VALUE)
			ReportError (_T ("Nieudane otwieranie potoku nazwanego."), 1, TRUE);
		ThArgs [iNp].hNamedPipe = hNp;
		ThArgs [iNp].ThreadNo = iNp;
		GetTempFileName (_T ("."), _T ("CLP"), 0, ThArgs [iNp].TmpFileName);
		hSrvrThread [iNp] = (HANDLE)_beginthreadex (NULL, 0, Server,
				&ThArgs [iNp], 0, &ThreadId);
		if (hSrvrThread [iNp] == NULL)
			ReportError (_T ("Nieudane tworzenie watku serwera."), 2, TRUE);
	}
	
	/* Oczekiwanie na zakoczenie dziaania przez wszystkie wtki. */

	WaitForMultipleObjects (MAX_CLIENTS, hSrvrThread, TRUE, INFINITE);
	_tprintf (_T("Wszystkie watki serwera zakonczyly prace.\n"));

	WaitForSingleObject (hMonitor, INFINITE);
	_tprintf (_T("Watek monitorujacy zakonczyl prace.\n"));

	CloseHandle (hMonitor);
	for (iNp = 0; iNp < MAX_CLIENTS; iNp++) { 
		/* Zamykanie uchwytw potoku i usuwanie plikw tymczasowych. */
        /* Zamykanie plikw tymczasowych jest zbdne  robi to wtki robocze. */
		CloseHandle (hSrvrThread [iNp]);
		DeleteFile (ThArgs [iNp].TmpFileName);
	}
	if (hSecHeap != NULL) HeapDestroy (hSecHeap);
	_tprintf (_T("Proces serwera konczy prace.\n"));
	/*	Funkcja ExitProcess gwarantuje uporzdkowane zakoczenie pracy. Wszystkie punkty
        wejcia biblioteki DLL zostan wywoane, co oznacza odczenie procesu. 
		Jest to wane midzy innymi dlatego, e wtki poczenia nadal mog
		by zablokowane w wywoaniach funkcji ConnectNamedPipe. */
	ExitProcess (0);

	return 0;
}


static DWORD WINAPI Server (LPTHREAD_ARG pThArg)

/* Funkcja wtku serwera. Dla kadego potencjalnego klienta powstaje jeden wtek. */
{
	/* Kady wtek przechowuje na stosie struktury danych 
     * na danie, odpowied i operacje pomocnicze.
     * Ponadto kady wtek tworzy dodatkowy wtek poczenia,
     * aby gwny wtek roboczy mg okresowo sprawdza flag zamknicia
     * w czasie oczekiwania na poczenie z klientem. */

	HANDLE hNamedPipe, hTmpFile = INVALID_HANDLE_VALUE, hConTh = NULL, hClient;
	DWORD nXfer, ConThId, ConThStatus;
	STARTUPINFO StartInfoCh;
	SECURITY_ATTRIBUTES TempSA = {sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
	PROCESS_INFORMATION ProcInfo;
	FILE *fp;
	REQUEST request;
	RESPONSE response;

	GetStartupInfo (&StartInfoCh);
	hNamedPipe = pThArg->hNamedPipe;

	while (!ShutDown) { 	/* Ptla poczenia. */

		/* Tworzenie wtku poczenia i oczekiwanie na zakoczenie jego dziaania. */
		/* Naley uy limitu czasu, aby mona byo przetestowa flag zamykania. */
		hConTh = (HANDLE)_beginthreadex (NULL, 0, Connect, pThArg, 0, &ConThId);
		if (hConTh == NULL) {
			ReportError (_T("Nie mozna utworzyc watku polaczenia."), 0, TRUE);
			_endthreadex(2);
		}

		/* Oczekiwanie na poczenie z klientem. */
		
		while (!ShutDown && WaitForSingleObject (hConTh, CS_TIMEOUT) == WAIT_TIMEOUT) 
			{ /* Puste ciao ptli. */};
		if (ShutDown) _tprintf(_T("Watek %d otrzymal polecenie zamkniecia.\n"), pThArg->ThreadNo);
		if (ShutDown) continue;	/* Flag mona ustawi take w innych wtkach. */

		CloseHandle (hConTh); hConTh = NULL;
		/* Poczenie jest ju nawizane. */
		/* Otwieranie tymczasowego pliku na wyniki dla tego poczenia. */
		hTmpFile = CreateFile (pThArg->TmpFileName, GENERIC_READ | GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE, &TempSA,
				CREATE_ALWAYS, FILE_ATTRIBUTE_TEMPORARY, NULL);
		if (hTmpFile == INVALID_HANDLE_VALUE) { /* W zasadzie mona tylko zamkn wtek. */
			ReportError (_T("Nie mozna utworzyc pliku tymczasowego."), 0, TRUE);
			_endthreadex(1);
		}

		while (!ShutDown && ReadFile (hNamedPipe, &request, RQ_SIZE, &nXfer, NULL)) {
			/* Odbieranie nowych polece do czasu zerwania poczenia przez klienta. */

			ShutDown = ShutDown || (_tcscmp (request.record, ShutRqst) == 0);
			if (ShutDown)  continue;

			/* Gwna ptla polecenia. */
			/* Tworzenie procesu do wykonania polecenia. */
			StartInfoCh.hStdOutput = hTmpFile;
			StartInfoCh.hStdError = hTmpFile;
			StartInfoCh.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
			StartInfoCh.dwFlags = STARTF_USESTDHANDLES;

			if (!CreateProcess (NULL, request.record, NULL,
				NULL, TRUE, /* Dziedziczenie uchwytw. */
				0, NULL, NULL, &StartInfoCh, &ProcInfo)) {
					PrintMsg (hTmpFile, _T("Blad - nie mozna utworzyc procesu."));
					ProcInfo.hProcess = NULL;
			}

			if (ProcInfo.hProcess != NULL ) { /* Proces serwera dziaa. */
				CloseHandle (ProcInfo.hThread);
				WaitForSingleObject (ProcInfo.hProcess, INFINITE);
				CloseHandle (ProcInfo.hProcess);
			}
			
			/* Odpowiadanie po jednym wierszu. Wygodnie jest zastosowa w tym
               miejscu dziaajce na wierszach procedury z biblioteki jzyka C. */

			fp = _tfopen (pThArg->TmpFileName, _T ("r"));
			if (fp == NULL)
				perror ("Nieudane otwieranie pliku wyjsciowego.");
			while (_fgetts (response.record, MAX_RQRS_LEN, fp) != NULL) 
				WriteFile (hNamedPipe, &response, RS_SIZE, &nXfer, NULL); 
			fclose (fp);

			/* Usuwanie zawartoci pliku tymczasowego. */
			SetFilePointer (hTmpFile, 0, NULL, FILE_BEGIN);
			SetEndOfFile (hTmpFile);

			/* Wysyanie informacji o kocu odpowiedzi. */
			strcpy (response.record, "");
			WriteFile (hNamedPipe, &response, RS_SIZE, &nXfer, NULL);
		}   /* Koniec gwnej ptli do obsugi polecenia. Pobieranie nastpnej instrukcji. */

		/* Klient zerwa poczenie lub wystpio danie zamknicia. */
        /* Zamknicie poczenia z danym klientem i oczekiwanie na nastpnego. */
		FlushFileBuffers (hNamedPipe);
		DisconnectNamedPipe (hNamedPipe);
		CloseHandle (hTmpFile); hTmpFile = INVALID_HANDLE_VALUE;
		DeleteFile (pThArg->TmpFileName);
	}

	/*  Wymuszanie zamknicia wtku poczenia, jeli wci jest aktywny  
	 *  (zobacz dalsze komentarze). */
	GetExitCodeThread (hConTh, &ConThStatus);
	if (ConThStatus == STILL_ACTIVE) {
		hClient = CreateFile (SERVER_PIPE, GENERIC_READ | GENERIC_WRITE, 0, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hClient != INVALID_HANDLE_VALUE) CloseHandle (hClient);
		WaitForSingleObject (hConTh, INFINITE);
	}


/*	Wystpuje tu problem zwizany z tym, e wtek poczenia moe wci dziaa
	Warto go zamkn, ale nie ma wtedy uporzdkowanego zamykania wtku 
	i nie s wywoywane na przykad punkty wejcia do biblioteki DLL, co moe 
	prowadzi do wyciekania zasobw.
	Wtek poczenia mona wznawia przez wykorzystanie serwera jak klienta
	i wywoywanie funkcji CreateFile do nawizywania (bardzo) krtkiego
	poczenia, co umoliwia zamknicie wtku poczenia.

	Istnieje te jednak kilka innych rozwiza, jednak maj one usterki.

    POMYS 1. Zamykanie uchwytu potoku nazwanego. Moe to spowodowa niepowodzenie wywoania ConnectNamedPipe,
	a wtek poczenia moe zakoczy prac. Niestety, funkcja CloseHandle 
	blokuje program, jeli istnieje aktywne wywoanie ConnectNamedPipe.
		CloseHandle (hNamedPipe);  // Nie naley tego robi! Moe to zablokowa program.
	
	POMYS 2. Zamykanie wtku. Problem polega na tym, e punkty wejcia bibliotek DLL
	nie zostan wywoane, co moe prowadzi do wspomnianego wyciakania zasobw.
	
	UWAGA: punkty wejcia bibliotek DLL opisano w rozdziale 5.
	Odpowiedni przykad znajduje si w rozdziale 12.

	POMYS 3. mona anulowa wtki za pomoc wywoa APC (rozdzia 10.).
	Niestety, klient moe nie znajdowa si w stanie oczekiwania z obsug alertw.
	
	UWAGA: wtki Pthraeds dostpne w wikszoci systemw UNIX umoliwiaj jednemu wtkowi anulowanie
	innego w taki sposb, e anulowany wtek moe uruchomi "procedur obsugi anulowania"
	przed zakoczeniem pracy. Moliwo anulowania wtkw byaby przydatna w systemie Windows.

*/
	_tprintf (_T("Watek %d konczy prace.\n"), pThArg->ThreadNo);
	/* Koniec ptli do przetwarzania polece. Zwalnianie zasobw i wychodzenie z wtku. */
	if (hTmpFile != INVALID_HANDLE_VALUE) CloseHandle (hTmpFile);
	DeleteFile (pThArg->TmpFileName);
	_tprintf (_T("Wychodzenie z watku serwera numer %d\n"), pThArg->ThreadNo);
	_endthreadex (0);
	return 0;	/* Blokowanie ostrzeenia od kompilatora. */
}


static DWORD WINAPI Connect (LPTHREAD_ARG pThArg)
{
	BOOL f;
	/*	Wtek potoku umoliwiajcy serwerowi sprawdzanie flagi zamknicia. */
	f = ConnectNamedPipe (pThArg->hNamedPipe, NULL);
	_tprintf (_T("Funkcja ConnectNamedPipe zakonczyla prace: %d\n"), f);
	_endthreadex (0);
	return 0; 
}


static DWORD WINAPI ServerBroadcast (LPLONG pNull)
{
	MS_MESSAGE MsNotify;
	DWORD nXfer;
	HANDLE hMsFile;

	/* Otwieranie szczeliny pocztowej dla jej klienta. */
	while (!ShutDown) { /* Dziaa dopty, dopki istniej wtki serwera. */
		/* Oczekiwanie na otwarcie szczeliny przez nastpnego klienta. */
		Sleep (CS_TIMEOUT);
		/* UWAGA (12 padziernika 2001). Funkcja CreateFile dla szczeliny ustawia uprawnienia GENERIC_WRITE,
		   ale nie GENERIC_READ. GENERIC_READ zadziaa dla Windows NT/2000/XP,
		   ale nie dla Windows 9x/Me. Ten konkretny program nie jest przeznaczony dla
		   systemw 9x/Me, poniewa jest to serwer potoku nazwanego, ale czsto
		   klient szczeliny dziaa w systemie 9x/Me, dlatego nie naley uywa
		   GENERIC_READ przy tworzeniu klienta. */
		hMsFile = CreateFile (MS_CLTNAME, GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE,
				NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hMsFile == INVALID_HANDLE_VALUE) continue;

		/* Wysyanie komunikatu do szczeliny. */

		MsNotify.msStatus = 0;
		MsNotify.msUtilization = 0;
		_tcscpy (MsNotify.msName, SERVER_PIPE);
		if (!WriteFile (hMsFile, &MsNotify, MSM_SIZE, &nXfer, NULL))
			ReportError (_T ("Blad zapisu serwera szczeliny."), 13, TRUE);
		CloseHandle (hMsFile);
	}
	_tprintf (_T ("Zamykanie watku monitorujacego.\n"));

	_endthreadex (0);
	return 0;
}


BOOL WINAPI Handler (DWORD CtrlEvent)
{
	/* Zamykanie systemu. */
	_tprintf (_T("W procedurze sterujacej konsoli.\n"));
	ShutDown = TRUE;
	return TRUE;
}
