/* Rozdzia 15.1. Polecenie chmodW dla systemu Windows (nazwa jest specyficzna
 * dla systemu, aby odrni j od zainstalowanych pakietw emulujcych narzdzia UNIX-owe,
 * takich jak cygwin. */
 
/* chmodW [opcje] tryb plik [nazwaGrupy]
   Aktualizowanie uprawnie dostpu do nazwanego pliku.
	Opcje:
		-f  wymuszanie (program nie zgasza, e nie moe wprowadzi zmian).
		-c  tworzenie pliku, jeli nie istnieje.
			NIE S TO OPCJE STANDARDOWEGO POLECENIA UNIX-OWEGO. 
			Nazwa grupy znajduje si po nazwie pliku! 
			Jeli uytkownik nie poda nazwy grupy, program pobierze j
			z etony procesu.  */

/* Ten program ilustruje:
   1. Ustawianie atrybutw zabezpiecze pliku.
   2. Modyfikowanie deskryptora zabezpiecze. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hFile, heap = NULL;
	BOOL force, createNew, change, exists;
	DWORD mode, userCount = ACCT_NAME_SIZE;
	TCHAR userName [ACCT_NAME_SIZE];
	int fileIndex, groupIndex, modeIndex;
		/* Tablica uprawnie w "porzdku UNIX-owym". */
		/* Istniej odrbne tablice dla masek ACE dla odmowy i zezwalania,
		 * dla uprawnienia SYNCHRONIZE nigdy nie s odmawiane.
		 * Dzieje si tak, poniewa uprawnienia FILE_GENERIC_READ i FILE_GENERIC_WRITE
		 * obejmuj dostp na poziomie SYNCHRONIZE (zobacz plik WINNT.H).
		 */
	DWORD allowedAceMasks [] =
		{FILE_GENERIC_READ, FILE_GENERIC_WRITE, FILE_GENERIC_EXECUTE};
	DWORD deniedAceMasks [] =
		{FILE_GENERIC_READ & ~SYNCHRONIZE, FILE_GENERIC_WRITE & ~SYNCHRONIZE, 
		 FILE_GENERIC_EXECUTE & ~SYNCHRONIZE};
	LPSECURITY_ATTRIBUTES pSa = NULL;
	LPCTSTR groupName = NULL;

	if (argc < 3) ReportError (_T("Stosowanie: chmodW [opcje] tryb plik [nazwaGrupy]"), 1, FALSE);
	modeIndex = Options (argc, argv, _T ("fc"), &force, &createNew, NULL);
	groupIndex = modeIndex + 2;
	fileIndex = modeIndex + 1;
	/*	Tryb ma podstaw osiem  naley przeksztaci go na liczb dziesitn. */
	mode = _tcstoul(argv [modeIndex], NULL, 8);

	exists = (_taccess (argv [fileIndex], 0) == 0);

	if (!exists && createNew) {
				/* Plik nie istnieje - naley utworzy nowy. */
		if (argc < groupIndex) 
			ReportError (_T ("Usage: chmod -c Perm file [groupName]."), 1, FALSE);
		if (argc == groupIndex) { /* Znajdowanie nazwy podstawowej grupy. */
			groupName = NULL;
		} else
			groupName = argv[groupIndex];

		if (!GetUserName (userName, &userCount))
			ReportError (_T ("Nie mozna pobrac nazwy uzytkownika."), 2, TRUE);
		/* wiczenie: problem z funkcj GetUserName polega na tym, e zwrci nazw 
		 * oszusta. W zamian wykorzystaj identyfikator SID uytkownika z biecego etonu. */

		pSa = InitializeUnixSA (mode, userName, groupName, allowedAceMasks, deniedAceMasks, &heap);

		if (pSa == NULL)
			ReportError (_T ("Nieudane ustawianie atrybutow zabezpieczen."), 3, TRUE);
		hFile = CreateFile (argv [fileIndex], 0,
				0, pSa, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE) {
			ReportError (_T ("Nieudane tworzenie bezpiecznego pliku."), 4, TRUE);
			DestroyUnixSA (pSa, heap);
		}
		CloseHandle (hFile);
	}
	else if (exists) {
				/* Plik istnieje  naley zmieni uprawnienia. */
		change = ChangeFilePermissions (mode, argv [fileIndex], allowedAceMasks,
			deniedAceMasks);
		if (!change && !force) {
			ReportError (_T ("Blad przy zmianie uprawnien."), 5, TRUE);
			DestroyUnixSA (pSa, heap);
		}
	} else { /* Blad - plik nie istnieje i nie uzyto opcji -c. */
		ReportError (_T ("Modyfikowany plik nie istnieje."), 6, 0);
		DestroyUnixSA (pSa, heap);
	}
	DestroyUnixSA (pSa, heap);
	return 0;
}
