/* Rozdzia 7. Polecenie chmodBSD. */

/* chmodW [opcje] tryb plik [nazwaGrupy]
   Aktualizowanie uprawnie dostpu do nazwanego pliku.
	Opcje:
		-f  wymuszanie (program nie zgasza, e nie moe wprowadzi zmian).
		-c  tworzenie pliku, jeli nie istnieje.
			NIE S TO OPCJE STANDARDOWEGO POLECENIA UNIX-OWEGO. 
			Nazwa grupy znajduje si po nazwie pliku! 
			Jeli uytkownik nie poda nazwy grupy, program pobierze j
			z etony procesu.  */

/* Ten program ilustruje:
   1. Ustawianie atrybutw zabezpiecze pliku.
   2. Modyfikowanie deskryptora zabezpiecze.
   3. Uywanie funkcji BuildSecurityDescriptor dostpnej w VC++ 5.0. */

#include "Everything.h"

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hFile;
	BOOL Force, CreateNew, Change, Exists;
	DWORD Mode, DecMode, UsrCnt = ACCT_NAME_SIZE;
	TCHAR UsrNam [ACCT_NAME_SIZE];
	int FileIndex, GrpIndex, ModeIndex;
		/* Tablica uprawnie w "porzdku UNIX-owym". */
	DWORD AceMasks [] =
		{GENERIC_READ, GENERIC_WRITE, GENERIC_EXECUTE};
	SECURITY_ATTRIBUTES Sa = { sizeof (SECURITY_ATTRIBUTES), NULL, FALSE };
	LPCTSTR GroupName = NULL;

	ModeIndex = Options (argc, argv, _T ("fc"), &Force, &CreateNew, NULL);
	GrpIndex = ModeIndex + 2;
	FileIndex = ModeIndex + 1;
	DecMode = _ttoi (argv [ModeIndex]);

	

	Mode = ((DecMode / 100) % 10) * 64 
			 + ((DecMode / 10) % 10) * 8 + (DecMode % 10);
	Exists = (_taccess (argv [FileIndex], 0) == 0);

	if (!Exists && CreateNew) {
				/* Plik nie istnieje - naley utworzy nowy. */
		if (argc < GrpIndex) 
			ReportError (_T ("Stosowanie: Chmod -c uprawnienia plik [nazwaGrupy]."), 1, FALSE);
		if (argc == GrpIndex) { /* Znajdowanie nazwy podstawowej grupy. */
			GroupName = NULL;
		} else
			GroupName = argv[GrpIndex];

		if (!GetUserName (UsrNam, &UsrCnt))
			ReportError (_T ("Nie mozna pobrac nazwy uzytkownika."), 2, TRUE);
		Sa.lpSecurityDescriptor = InitializeSD (Mode, UsrNam, argv [GrpIndex], AceMasks);
		if (Sa.lpSecurityDescriptor == NULL)
			ReportError (_T ("Nieudane ustawianie atrybutow zabezpieczen."), 3, TRUE);
		hFile = CreateFile (argv [FileIndex], 0,
				0, &Sa, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			ReportError (_T ("Nieudane tworzenie bezpiecznego pliku."), 4, TRUE);
		CloseHandle (hFile);
	}
	else if (Exists) {
				/* Plik istnieje  naley zmieni uprawnienia. */
		Change = ChangeFilePermissions (Mode, argv [FileIndex], AceMasks);
		if (!Change && !Force)
			ReportError (_T ("Blad przy zmianie uprawnien."), 5, TRUE);
	}
	else /* Blad - plik nie istnieje i nie uzyto opcji -c. */
		ReportError (_T ("Modyfikowany plik nie istnieje."), 6, 0);
	
	return 0;
}


