/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Kod w tekcie zaczyna si od funkcji ProcessItem. */

/* Rozdzia 15. lsFP - wywietlanie plikw z uprawnieniami do nich interpretowanymi
	w stylu UNIX-a (ustawionymi wczeniej za pomoc programu chmod).
	Jest to rozbudowana wersja polecenia ls z jednego z wczeniejszych rozdziaw. 
	OSTRZEENIE: informacje o uprawnieniach i wacicielu prawdopodobnie bd nonsensowne
 *	dla plikw i katalogw, dla ktrych uprawnie nie ustawiono za pomoc programu "chmodW". */
/*	lsFP[opcje][pliki] */

/* Rozdzia 15. lsFP - wywietlanie plikw. */
/*	lsFP[opcje][pliki] */

/* List the attributes of one or more files.
	Opcje:
		-R	rekurencja
		-l	wywietlanie dugiej listy (uprawnienia, waciciel, rozmiar i czas)
			W zalenoci od funkcji ProcessItem program wywietla te
			waciciela i uprawnienia (zobacz rozdzia o zabezpieczeniach).	 */

/* Dzikuj Stewartowi N. Weissowi za wprowadzenie istotnych poprawek
 * w zakresie przetwarzania cieki (wystpoway problemy z przetwarzaniem czonw C:, C:\,
 * i C:\dirname).
 */

#include "Everything.h"

BOOL TraverseDirectory (LPTSTR, DWORD, LPBOOL);
DWORD FileType (LPWIN32_FIND_DATA);
BOOL ProcessItem (LPWIN32_FIND_DATA, DWORD, LPBOOL);

int _tmain (int argc, LPTSTR argv[])
{
	BOOL flags[MAX_OPTIONS], ok = TRUE;
	TCHAR pathName[MAX_PATH + 1], currPath[MAX_PATH + 1], tempPath[MAX_PATH+1];
	LPTSTR pSlash, pFileName;
	int i, fileIndex;

	fileIndex = Options (argc, argv, _T ("Rl"), &flags[0], &flags[1], NULL);

	/* "Przetwarzanie" wzorca wyszukiwania na dwie czci: katalog nadrzdny i
		nazw pliku lub wyraenie wieloznaczne. Nazwa pliku to najduszy
		przyrostek bez ukonika.
		Katalog nadrzdny to przedrostek z ukonikiem.
		Operacja  ta jest wykonywana dla wszystkich wzorcw wyszukiwania z wiersza polece.
		Jeli uytkownik nie poda pliku, program uywa symbolu * jako wzorca wyszukiwania. */

	GetCurrentDirectory (MAX_PATH, currPath);
	if (argc < fileIndex + 1) 
		ok = TraverseDirectory (_T("*"), MAX_OPTIONS, flags);
	else for (i = fileIndex; i < argc; i++) {
		_tcscpy (pathName, argv[i]);
		_tcscpy(tempPath, argv[i]);                

		/* Wyszukiwanie ukonika pierwszego od prawej (jeli taki istnieje).
			Ustawianie cieki i uywanie reszty jako nazwy pliku. */

		pSlash = _tstrrchr (tempPath, _T('\\'));       

		if (pSlash != NULL) {
			*pSlash = _T('\0');
			_tcscat(tempPath, _T("\\"));           
			SetCurrentDirectory (tempPath); 
			pSlash = _tstrrchr (pathName, _T('\\'));   
			pFileName = pSlash + 1;
		} else pFileName = pathName;
		ok = TraverseDirectory (pFileName, MAX_OPTIONS, flags) && ok;
		SetCurrentDirectory (currPath);
	}
	return ok ? 0 : 1;
}

static BOOL TraverseDirectory (LPTSTR pathName, DWORD numberFlags, LPBOOL flags) 

/* Przechodzenie po katalogu i wykonywanie specyficznych dla implementacji opercji dla kadej
	napotkanej nazwy. Operacja w tej wersji to "wywietlanie (opcjonalnie z atrybutami). */

/* pathName: wzgldna lub absolutna cieka do przejcia. */
{
	HANDLE searchHandle;
	WIN32_FIND_DATA findData;
	BOOL recursive = flags[0];
	DWORD fileType, iPass;
	/****  Umieszczanie duej tablicy (takiej jak currPath) na stosie to zy pomys
	 *  (lub - jeli wolisz - bardzo za praktyka programistyczna; przyznaj si do winy). ****/
	/* 1) Przechodzenie po katalogu moe powodowa zajmowanie duej iloci miejsca.
	 * 2) Wystpuje ryzyko przepenienia stosu, co jest zagroeniem z obszaru bezpieczestwa.
	 * 3) Nie mona stosowa dugich cieek (> MAX_PATH) za pomoc przedrostka \\?\.
	 *    SUGESTIA: zapoznaj si z lepsz implementacj z programu lsW (rozdzia 3.) i popraw t wersj.
	 */

	TCHAR currPath[MAX_PATH + 2];

	// Dodane przez Weissa:
	if ( _tcslen(pathName) == 0 ) 
	{
		_tprintf(_T("Stosowanie: lsFP[opcje][sciezka]\n"));
		_tprintf(_T("       gdzie [sciezka] nie moze konczyc sie czlonem '\\'\n"));
		return FALSE;
	}
    // Koniec fragmentu dodanego przez Weissa.

	GetCurrentDirectory (MAX_PATH, currPath);

	/* Otwieranie uchwytu przeszukiwania katalogu i pobieranie pierwszej nazwy
		pliku zgodnej ze ciek. Dwa przebiegi - pierwszy przetwarza pliki,
		a drugi - katalogi. */

	for (iPass = 1; iPass <= 2; iPass++) {
		// Jeli cieka ma posta "X:" lub "X:\", naley zmieni na "X:\*".
		if (_istalpha(pathName[0]) &&  (pathName[1] == _T(':')) && (_tcslen(pathName) <= 3))
		{
			TCHAR   tempPath[5] = {_T('\0'), _T('\0') };;
			tempPath[0] = pathName[0];
			_tcscat (tempPath, _T(":\\*"));
			searchHandle = FindFirstFile (tempPath, &findData);
		}
		else
			searchHandle = FindFirstFile (pathName, &findData);

		if (searchHandle == INVALID_HANDLE_VALUE) {
			ReportError (_T ("Blad otwierania uchwytu przeszukiwania."), 0, TRUE);
			return FALSE;
		}

		/* Przegldanie katalogu i jego podkatalogw pod ktem plikw zgodnych ze wzorcem. */

		do {

		/* Dla kadego znalezionego pliku naley pobra typ. W przebiegu pierwszym wywietlane 
		    s wszystkie dane. W przebiegu drugim program wywietla nazw katalogu i rekurencyjnie
			przetwarza zawarto podkatalogu (jeli uyto opcji rekurencji). */

			fileType = FileType (&findData);
			if (iPass == 1) /* ProcessItem wywietla atrybuty. */
				ProcessItem (&findData, MAX_OPTIONS, flags);

			/* Przechodzenie po podkatalogu w drugim przebiegu. */

			if (fileType == TYPE_DIR && iPass == 2 && recursive) {
				_tprintf (_T ("%s\\%s:\n"), currPath, findData.cFileName);
				SetCurrentDirectory (findData.cFileName);
				TraverseDirectory (_T("*"), numberFlags, flags);
				SetCurrentDirectory (_T (".."));
			}

			/* Pobieranie nazwy nastpnego pliku lub katalogu. */

		} while (FindNextFile (searchHandle, &findData));
		
		FindClose (searchHandle);
	}
	return TRUE;
}

static DWORD FileType (LPWIN32_FIND_DATA pFileData)

/* Zwracany jest typ pliku ze struktury do wyszukiwania danych.
	Obsugiwane typy:
		TYPE_FILE:	Plik
		TYPE_DIR:	Katalog inny ni . lub ..
		TYPE_DOT:	Katalog . lub .. */
{
	BOOL isDir;
	DWORD fileType;
	fileType = TYPE_FILE;
	isDir = (pFileData->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0;
	if (isDir)
		if (lstrcmp (pFileData->cFileName, _T(".")) == 0
				|| lstrcmp (pFileData->cFileName, _T("..")) == 0)
			fileType = TYPE_DOT;
		else fileType = TYPE_DIR;
	return fileType;
}


/* Funkcja do przetwarzania elementw wywoywana po wykryciu pliku lub katalogu. */

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* KONIEC STANDARDOWEGO KODU. */
/* Kod w tekcie zaczyna si od tego miejsca. */

static BOOL ProcessItem (LPWIN32_FIND_DATA pFileData, DWORD numberFlags, LPBOOL flags)

/* Wywietla atrybuty z uprawnieniami do pliku i wacicielem. */
{
	DWORD fileType = FileType(pFileData), Mode, i;
	BOOL dashL = flags[1];
	TCHAR groupName[ACCT_NAME_SIZE], userName[ACCT_NAME_SIZE];
	SYSTEMTIME timeLastWrite;
	TCHAR  permissionString[] = _T("---------");
	const TCHAR RWX[] = {_T('r'),_T('w'),_T('x')}, FileTypeChar[] = {_T(' '),_T('d')};

	if (fileType != TYPE_FILE && fileType != TYPE_DIR)
		return FALSE;
	_tprintf (_T ("\n"));

	if (dashL) {
		Mode = ReadFilePermissions (pFileData->cFileName, userName, groupName);
		if (Mode == 0xFFFFFFFF)
			Mode = 0;
		for (i = 0; i < 9; i++) {
			if ( (Mode / (1 << (8 - i)) & 0x1) )
				 permissionString[i] = RWX[i % 3];
		}
		_tprintf (_T ("%c%s %8.7s %8.7s%10d"),
			FileTypeChar[fileType-1], permissionString, userName, groupName,
			pFileData->nFileSizeLow);
		FileTimeToSystemTime (&(pFileData->ftLastWriteTime), &timeLastWrite);
		_tprintf (_T (" %02d/%02d/%04d %02d:%02d:%02d"),
				timeLastWrite.wMonth, timeLastWrite.wDay,
				timeLastWrite.wYear, timeLastWrite.wHour,
				timeLastWrite.wMinute, timeLastWrite.wSecond);
	}
	_tprintf (_T (" %s"), pFileData->cFileName);
	return TRUE;
}
