/*	Rozdzia 15. */
/* JobShell_secure.c. Rozwinicie programu z rozdziau 6. czy on trzy polecenia:
	Jobbg	- uruchamia zadanie w tle
	jobs	- wywietla wszystkie zadania dziaajce w tle
	kill	- koczy okrelone zadanie.
			  Dostpna jest opcja do generowania sygnaw sterujcych konsoli.
*/
/*  Ten program nie jest kompletny. */

#include "Everything.h"
#include "JobManagement.h"

static int Jobbg (int, LPTSTR *, LPTSTR);
static int Jobs  (int, LPTSTR *, LPTSTR);
static int Kill  (int, LPTSTR *, LPTSTR);

int _tmain (int argc, LPTSTR argv [])
{
	BOOL Exit = FALSE;
	TCHAR Command [MAX_COMMAND_LINE+10], *pc;
	DWORD i, LocArgc; /* Lokalny argument argc. */
	TCHAR argstr [MAX_ARG] [MAX_COMMAND_LINE];
	LPTSTR pArgs [MAX_ARG];

	_tprintf (_T("OSTRZEZENIE: implementacja nie jest kompletna.\n"));

	for (i = 0; i < MAX_ARG; i++)
		pArgs[i] = argstr[i];

	_tprintf (_T("Zarzadzanie zadaniami w systemach Win32.\n"));
	while (!Exit) {
		_tprintf (_T("%s"), _T("JM$"));
		_fgetts (Command, MAX_COMMAND_LINE, stdin);
		pc = _tcschr (Command, _T('\n'));
		*pc = _T('\0');

		GetArgs (Command, &LocArgc, pArgs);
		CharLower (argstr [0]);

		if (_tcscmp (argstr[0], _T("jobbg")) == 0) {
			Jobbg (LocArgc, pArgs, Command);
		}
		else if (_tcscmp (argstr[0], _T("jobs")) == 0) {
			Jobs (LocArgc, pArgs, Command);
		}
		else if (_tcscmp (argstr[0], _T("kill")) == 0) {
			Kill (LocArgc, pArgs, Command);
		}
		else if (_tcscmp (argstr[0], _T("quit")) == 0) {
			Exit = TRUE;
		}
		else _tprintf (_T("Nieprawidlowe polecenie. Sprobuj ponownie.\n"));
	}


	return 0;
}

/* Jobbg: wykonywanie wiersza polece w tle, umieszczanie danych
	identyfikacyjnych zadania w pliku zada i koczenie pracy.
	Do zarzdzania zadaniami mona uy powizanych polece (jobs, fg, kill i suspend). */

/* jobbg [opcje] wiersz_polece
		-c: udostpnia konsol nowemu procesowi.
		-d: nowy proces jest odczony od konsoli.
	Te dwie opcje wzajemnie si wykluczaj.
	Jeli uytkownik nie ustawi adnej z nich, proces dziaajcy w tle korzysta
	z tej samej konsoli, co program jobbg. */

/* Nowe mechanizmy programu ilustruj:
		1. Tworzenie odczonych procesw i procesw z odrbnymi konsolami.
		2. Przechowywanie listy zada i procesw we wsplnym pliku.
		3. Okrelanie stanu procesu na podstawie ID procesu.*/

/* Standardowe pliki doczane. */
/* - - - - - - - - - - - - - - - - - - - - - - - - - */

int Jobbg (int argc, LPTSTR argv [], LPTSTR Command)
{
	/*	Przetwarzanie wiersza polece podobnie jak w programie timep.c. */
	/*	- - - - - - - - - - - - - - - - - - - - - - */
	/*	Wykonywanie wiersza polece (targv) i zapisywanie ID zadania,
		ID procesu oraz uchwytu w pliku zada. */

	DWORD fCreate;
	LONG JobNo;
	BOOL Flags [2];

	STARTUPINFO StartUp;
	PROCESS_INFORMATION ProcessInfo;
	LPTSTR targv = SkipArg (Command);
	
	GetStartupInfo (&StartUp);


		/* Okrelanie opcji. */
	Options (argc, argv, _T ("cd"), &Flags [0], &Flags [1], NULL);

		/* Pomijanie take pola opcji (jeli je podano). */
	if (argv [1] [0] == _T('-'))
		targv = SkipArg (targv);

	fCreate = Flags [0] ? CREATE_NEW_CONSOLE :
			Flags [1] ? DETACHED_PROCESS : 0;

		/* Tworzenie zawieszonego zadania lub wtku.
			Wznawianie po prawidowym zapisaniu zadania. */
	if (!CreateProcess (NULL, targv, NULL, NULL, TRUE,
			fCreate | CREATE_SUSPENDED | CREATE_NEW_PROCESS_GROUP,
			NULL, NULL, &StartUp, &ProcessInfo))  {
		ReportError (_T("Blad uruchamiania procesu."), 0, TRUE);
		return 4;
	}

		/* Tworzenie numeru zadania i wprowadzanie ID procesu oraz uchwytu 
			do "bazy danych" zadania zarzdzanej przez funkcj
			GetJobNumber (jest ona czci biblioteki do zarzdzania zadaniami). */
	
	JobNo = GetJobNumber (&ProcessInfo, targv);
	if (JobNo >= 0)
		ResumeThread (ProcessInfo.hThread);
	else {
		TerminateProcess (ProcessInfo.hProcess, 3);
		CloseHandle (ProcessInfo.hProcess);
		ReportError (_T("Blad: brak miejsca na liscie zadan."), 0, FALSE);
		return 5;
	}

	CloseHandle (ProcessInfo.hThread);
	CloseHandle (ProcessInfo.hProcess);
	_tprintf (_T(" [%d] %d\n"), JobNo, ProcessInfo.dwProcessId);
	return 0;
}

/* Jobs: wywietla wszystkie dziaajce lub zatrzymane procesy utworzone
	przez uytkownika w ramach zarzdzania zadaniami
	(czyli za pomoc polecenia jobbg).
	Do zarzdzania zadaniami su powizane polecenia (jobbg i kill). */
/* Nowe mechanizmy programu ilustruj:
	1. Okrelanie stanu procesu.
	2. Przechowywanie listy zada i procesw we wsplnym pliku. */

int Jobs (int argc, LPTSTR argv [], LPTSTR Command)
{
	if (!DisplayJobs ()) return 1;
	return 0;
}

/* kill [opcje] numerZadania
	Koczy proces powizany z zadaniem o okrelonym numerze. */
/* Nowe mechanizmy w tym programie ilustruj:
	1. Korzystanie z funkcji TerminateProcess.
	2. Zdarzenia sterujce konsoli. */

/* Opcje:
	-b  generuje kombinacj Ctrl+Break 
	-c  generuje kombinacj Ctrl+C
		W przeciwnym razie koczy proces. */

/* Struktury danych, kody bdw,
	stae i tak dalej znajduj si w innym pliku. */


int Kill (int argc, LPTSTR argv [], LPTSTR Command)
{
	DWORD ProcessId, JobNumber, iJobNo;
	HANDLE hProcess;
	BOOL CntrlC, CntrlB, Killed;

	iJobNo = Options (argc, argv, _T("bc"), &CntrlB, &CntrlC, NULL);
	
	/* Wyszukiwanie ID procesu powizanego z danym zadaniem. */

	JobNumber = _ttoi (argv [iJobNo]);
	ProcessId = FindProcessId (JobNumber);
	if (ProcessId == 0)	{
		ReportError (_T("Nie znaleziono numeru zadania.\n"), 0, FALSE);
		return 1;
	}
	hProcess = OpenProcess (PROCESS_ALL_ACCESS, FALSE, ProcessId);
	if (hProcess == NULL) {
		ReportError (_T("Proces zakonczyl juz dzialanie.\n"), 0, FALSE);
		return 2;
	}

	if (CntrlB)
		Killed = GenerateConsoleCtrlEvent (CTRL_BREAK_EVENT, ProcessId);
	else if (CntrlC)
		Killed = GenerateConsoleCtrlEvent (CTRL_C_EVENT, ProcessId);
	else
		Killed = TerminateProcess (hProcess, JM_EXIT_CODE);

	if (!Killed) { 
		ReportError (_T("Nieudane zamykanie procesu."), 0, TRUE);
		return 3;
	}
	
	WaitForSingleObject (hProcess, 5000);
	CloseHandle (hProcess);

	_tprintf (_T("Zadanie [%d] zakonczylo dzialanie lub uplynal limit czasu.\n"), JobNumber);
	return 0;
}
