/* Funkcje narzdziowe do zarzdzania zadaniami rozwinite wzgldem rozdziau 6. */
/* Te funkcje ilustruj blokowanie plikw. */
/* UWAGA I SUGESTIA: porwnaj z programem JobMgt.c z rozdziau 6., aby zobaczy:
 *   1) zabezpieczanie potoku nazwanego,
 *   2) e tego programu nie zaktualizowano za pomoc nowszych 
 *      mechanizmw, na przykad funkcji GetFileSizeEx.
 *	Jeli chcesz uywa tego programu, powiniene zaktualizowa go, aby by zgodny 
 *  z programem JobMgt.c.
 */

#include "Everything.h"
#include "JobManagement.h"

LONG GetJobNumber (PROCESS_INFORMATION *pProcessInfo, LPCTSTR Command)

/* Tworzy numer zadania dla nowego procesu i umieszcza 
   informacje o nowym procesie w bazie danych zadania. */

/* Baza danych zadania jest przechowywana we wspuytkowanym pliku w katalogu C:\temp.
	Jego nazwa to poczenie nazwy uytkownika i czonu ".JobMgt".
	Plik jest tworzony wraz z pierwszym zadaniem i usuwany
	po usuniciu ostatniego zadania.
	Plik ten jest wsplny dla wszystkich funkcji do zarzdzania zadaniami. 
	Zakadamy, e plik jest "may" (< 4 GB). Dla bardzo duych plikw
	program zawiedzie w kilku miejscach. Wystpuje ograniczenie 
	liczby zada (arbitralne, ale sensowne) do 10000 (MAX_JOBS_ALLOWED).
	Zwraca -1 w przypadku bdu. */
{
	HANDLE hJobData, hProcess;
	JM_JOB JobRecord;
	DWORD JobNumber = 0, nXfer, ExitCode;
	DWORD FsLow, FsHigh;
	TCHAR JobMgtFileName [MAX_PATH];
	OVERLAPPED RegionStart;
	
	if (!GetJobMgtFileName (JobMgtFileName)) return -1;
	hJobData = CreateFile (JobMgtFileName, GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE) {
		ReportError (_T ("Niepowodzenie przy otwieraniu bazy danych zadania."), 0, TRUE);
		return -1;
	}

	/*  Blokowanie caego pliku i jednego potencjalnego 
        nowego rekordu do dostpu wycznego z uwagi na tworzenie
        nowego wpisu. Warto zauway, e konieczne (i moliwe!) jest
	    blokowanie obszaru poza kocem pliku. Zapobiega to jednoczesnym
		prbom dodania nowego rekordu na koniec pliku. */

	RegionStart.Offset = 0;
	RegionStart.OffsetHigh = 0;
	RegionStart.hEvent = (HANDLE)0;
	FsLow = GetFileSize (hJobData, &FsHigh);
	LockFileEx (hJobData, LOCKFILE_EXCLUSIVE_LOCK,
		0, FsLow + SJM_JOB, FsHigh, &RegionStart);

	__try { /* Gwarantowanie, e obszar nie jest zablokowany. */

	/* Wczytywanie rekordw w celu znalezienia pustego miejsca (odpowiadajcego numerowi zadania).
		Rozszerzanie pliku w celu utworzenia w razie potrzeby nowego numeru zadania. */

	while (JobNumber < MAX_JOBS_ALLOWED &&
		ReadFile (hJobData, &JobRecord, SJM_JOB, &nXfer, NULL) && (nXfer > 0)) {
		if (JobRecord.ProcessId == 0) break;

		/* Tego slotu mona uy take wtedy, jeli odpowiednie zadania si zakoczyo. */

		hProcess = OpenProcess (PROCESS_ALL_ACCESS, FALSE, JobRecord.ProcessId);
		if (hProcess == NULL) break;
		if (GetExitCodeProcess (hProcess, &ExitCode)
			&& CloseHandle (hProcess) && (ExitCode != STILL_ACTIVE))
			break;

		JobNumber++;
	}

	/* Albo znaleziono pusty slot, albo program doszed do koca pliku
		i musi utworzy nowy, albo przekroczy maksymaln liczb zada. */
	if (JobNumber >= MAX_JOBS_ALLOWED) return -1;

	if (nXfer != 0)		/* To nie koniec pliku. Zachowywanie rekordu. */
		SetFilePointer (hJobData, -(LONG) SJM_JOB, NULL, FILE_CURRENT);
					/* Wprowadzenie numeru nowego zadania. */
	JobRecord.ProcessId = pProcessInfo->dwProcessId;
	_tcsnccpy (JobRecord.CommandLine, Command, MAX_PATH);
	WriteFile (hJobData, &JobRecord, SJM_JOB, &nXfer, NULL);
	}

	__finally {		/* Zwalnianie blokady pliku. */
		UnlockFileEx (hJobData, 0, FsLow + SJM_JOB, FsHigh, &RegionStart);
		CloseHandle (hJobData);
	}
	return JobNumber + 1;
}

BOOL DisplayJobs (void)

/* Przegldanie pliku z baz danych i informowanie o stanie wszystkich zada.
	Usuwanie wszystkich zada, ktre ju nie istniej w systemie. */
{
	HANDLE hJobData, hProcess;
	JM_JOB JobRecord;
	DWORD JobNumber = 0, nXfer, ExitCode;
	TCHAR JobMgtFileName [MAX_PATH];
	OVERLAPPED RegionStart;
	DWORD FsLow, FsHigh;
	
	if (GetJobMgtFileName (JobMgtFileName) < 0)
		return FALSE;
	hJobData = CreateFile (JobMgtFileName, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE,
		NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE)
		return FALSE;

	/* Wczytywanie rekordw i informowanie o kadym zadaniu. */
	/*  Najpierw naley utworzy blokad na wyczno do caego pliku,
		poniewa program modyfikuje wpisy. */

	RegionStart.Offset = 0;
	RegionStart.OffsetHigh = 0;
	RegionStart.hEvent = (HANDLE)0;
	FsLow = GetFileSize (hJobData, &FsHigh);
	LockFileEx (hJobData, LOCKFILE_EXCLUSIVE_LOCK, 0, FsLow, FsHigh, &RegionStart);

	__try {
	while (ReadFile (hJobData, &JobRecord, SJM_JOB, &nXfer, NULL) && (nXfer > 0)) {
		JobNumber++; /* Zmienna jobNumber nie wykracza poza warto MAX_JOBS_ALLOWED, poniewa
					    program nie moe wyduy pliku do tego rozmiaru. */
		if (JobRecord.ProcessId == 0) continue;
					/* Pobieranie stanu procesu. */
		hProcess = OpenProcess (PROCESS_ALL_ACCESS, FALSE, JobRecord.ProcessId);
		if (hProcess != NULL) {
			GetExitCodeProcess (hProcess, &ExitCode);
			CloseHandle (hProcess);
		}
					/* Wywietlanie stanu zadania. */
		_tprintf (_T (" [%d] "), JobNumber);
		if (hProcess == NULL)
			_tprintf (_T (" Zakonczono"));
		else if (ExitCode != STILL_ACTIVE)
			_tprintf (_T ("+ Zakonczono"));
		else _tprintf (_T ("      "));
					/* Wywietlanie polecenia. */
		_tprintf (_T (" %s\n"), JobRecord.CommandLine);

		/* Usuwanie procesw, ktre ju nie znajduj si w systemie. */

		if (hProcess == NULL) { /* Zapisywanie jednego rekordu. */
			SetFilePointer (hJobData, -(LONG)nXfer, NULL, FILE_CURRENT);
					/* Ustawianie numeru zadania na 0. */
			JobRecord.ProcessId = 0;
			if (!WriteFile (hJobData, &JobRecord, SJM_JOB, &nXfer, NULL))
				ReportError (_T ("Blad zapisu."), 1, TRUE);
		}
	}  /* Koniec ptli while. */
	}  /* Koniec bloku try.   */
	
	__finally {		/* Zwalnianie blokady pliku. */
		UnlockFileEx (hJobData, 0, FsLow, FsHigh, &RegionStart);
		CloseHandle (hProcess);
	}

	CloseHandle (hJobData);
	return TRUE;
}

DWORD FindProcessId (DWORD JobNumber)

/* Pobieranie ID procesu dla zadania o okrelonym numerze. */
{
	HANDLE hJobData;
	JM_JOB JobRecord;
	DWORD nXfer, FileSizeLow, FileSizeHigh;
	TCHAR JobMgtFileName [MAX_PATH];
	OVERLAPPED RegionStart;

	GetJobMgtFileName (JobMgtFileName);
	hJobData = CreateFile (JobMgtFileName, GENERIC_READ,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hJobData == INVALID_HANDLE_VALUE) return 0;
	/* Ustawia pozycj na biecy rekord, ale nie poza kocem pliku. */
	FileSizeLow = GetFileSize (hJobData, &FileSizeHigh);
	if (FileSizeHigh != 0 || SJM_JOB * (JobNumber - 1) > FileSizeLow 
		|| FileSizeLow > SJM_JOB * MAX_JOBS_ALLOWED)
		return 0;

	SetFilePointer (hJobData, SJM_JOB * (JobNumber - 1), NULL, FILE_BEGIN);
	
	/* Zajmowanie blokady rekordu w trybie wspuytkowania. */
	
	RegionStart.Offset = SJM_JOB * (JobNumber - 1);
	RegionStart.OffsetHigh = 0; /* Zakadamy, e jest to "krtki" plik. */
	RegionStart.hEvent = (HANDLE)0;
	LockFileEx (hJobData, 0, 0, SJM_JOB, 0, &RegionStart);
	
	if (!ReadFile (hJobData, &JobRecord, SJM_JOB, &nXfer, NULL))
		ReportError (_T ("JobData file error"), 0, TRUE);

	UnlockFileEx (hJobData, 0, SJM_JOB, 0, &RegionStart);
	CloseHandle (hJobData);

	return JobRecord.ProcessId;
}

BOOL GetJobMgtFileName (LPTSTR JobMgtFileName)

/* Tworzenie nazwy pliku do zarzdzania zadaniami. */
{
	TCHAR UserName [MAX_PATH], TempPath [MAX_PATH];
	DWORD UNSize = MAX_PATH, TPSize = MAX_PATH;

 	if (!GetUserName (UserName, &UNSize))
		return FALSE;
	if (GetTempPath (TPSize, TempPath) > TPSize)
		return FALSE;
	_stprintf (JobMgtFileName, _T ("%s%s%s"), TempPath, UserName, _T (".JobMgt"));
	return TRUE;
}
