/* Listing 15.3. */

/* InitUnFp.c */

/* Te funkcje zarzdzaj UNIX-owymi uprawnieniami za pomoc struktury
		SECURITY_ATTRIBUTES systemw Win32 (dziaa tylko dla systemw Windows NT) .
	Znajduj si tu trzy elementy:
		InitializeUnixSA: alokuje i inicjuje struktur.
		ChangeFilePermissions: modyfikuje uprawnienia do pliku.
		ReadFilePermissions: sprawdza zabezpieczenia pliku.

	Wystpuje kilka zaoe i ogranicze:
		Mona modyfikowa i wczytywa tylko struktury utworzone wczeniej
			za pomoc funkcji InitializeUnixSA.
		Wszystkie uprawnienia s podobne do uprawnie UNIX-owych:
			[R,W,X] -[uytkownik, grupa, pozostali].
		Nazwa grupy pochodzi z identyfikatora SID procesu.
			Mona on okrela kilka grup.
		Uniwersalne uprawnienia mona przypisa do DOWOLNEGO z odpowiednich obiektw.
		Modyfikowanie i wczytywanie wpisw wymaga uchwytu HANDLE obiektu
			i jego atrybutu zabezpiecze. */

#include "Everything.h"

#define ACL_SIZE 1024
#define SID_SIZE SECURITY_MAX_SID_SIZE
#define DOM_SIZE LUSIZE

static VOID FindGroup (DWORD, LPTSTR, DWORD);

LPSECURITY_ATTRIBUTES InitializeUnixSA (DWORD unixPerms,
		LPTSTR usrName, LPTSTR grpName, LPDWORD allowedAceMasks, 
		LPDWORD deniedAceMasks, LPHANDLE pSaHeap)

/* Alokowanie struktury i ustawianie uprawnie w stylu UNIX-a
   na podstawie wartoci parametru unixPerms. Zawiera on dziewi bitw 
   (od najmniej znaczcego) okrelajcych dane ustawienia [r,w,x]
   dla [Uytkownik,Grupa,Pozostali]. Jest to format znany z systemu UNIX.
   Funkcja zwraca wskanik do struktury atrybutw zabezpiecze. */

{
	/*  W celu utworzenia atrybutw zabezpiecze trzeba kilkakrotnie zaalokowa pami.
		Oto potrzebne struktury:
			1.	atrybut zabezpiecze
			2.	deskryptor zabezpiecze
			3.	trzy identyfikator SID (uytkownika, grupy i pozostaych osb)
			4.  nazwa grupy (jeli nie jest podana jako paramter "grpName")
		Ta pami MUSI by dostpna dla programu wywoujcego - 
        nie mona alokowa jej na stosie tej funkcji. */

	LPSECURITY_ATTRIBUTES pSA = NULL;
	PSECURITY_DESCRIPTOR pSD = NULL;
	PACL pAcl = NULL;
	BOOL success, ok = TRUE;
	DWORD iBit, iSid;
	/* Rne tablice nazw, identyfikatorw SID i innych elementw dla uytkownika, grupy oraz pozostaych osb. 
       Tablice te s uywane w funkcji LookupAccountName i przy tworzeniu identyfikatorw SID. */
	LPTSTR groupNames[3] = {EMPTY, EMPTY, _T ("Everyone")};
	PSID pSidTable[3] = {NULL, NULL, NULL};
	SID_NAME_USE sNamUse[] = 
		{SidTypeUser, SidTypeGroup, SidTypeWellKnownGroup};
	TCHAR refDomain[3][DOM_SIZE];
	DWORD refDomainCount[3] = {DOM_SIZE, DOM_SIZE, DOM_SIZE};
	DWORD sidCount[3] = {SID_SIZE, SID_SIZE, SID_SIZE};

	*pSaHeap = HeapCreate (HEAP_GENERATE_EXCEPTIONS, 0, 0);
	__try {
	/* Ten blok try-except suy do zwalniania
           zasobw w przypadku pniejszego niepowodzenia. */
	/*  Struktury zabezpiecze trzeba zaalokowa ze stosu,
		poniewa s uywane poza t funkcj. */
	pSA = HeapAlloc (*pSaHeap, 0, sizeof(SECURITY_ATTRIBUTES));
	pSA->nLength = sizeof(SECURITY_ATTRIBUTES);
	pSA->bInheritHandle = FALSE; /* Programista moe pniej zmieni t warto. */
	
	pSD = HeapAlloc (*pSaHeap, 0, sizeof(SECURITY_DESCRIPTOR));
	pSA->lpSecurityDescriptor = pSD;
	if (!InitializeSecurityDescriptor (pSD, SECURITY_DESCRIPTOR_REVISION))
		ReportException (_T ("Blad funkcji InitializeSecurityDescriptor."), 21);

	/* Ustawianie nazw tablic uytkownika i grupy.
               Pobieranie identyfikatorw SID dla uytkownika, grupy i innych osb. */
	groupNames[0] = usrName;
	if (grpName == NULL || _tcslen(grpName) == 0) { 
		/*  Nie okrelono nazwy grupy. Naley zastosowa podstawow grup uytkownika. */
               /* Alokowanie bufora na nazw grupy. */
		groupNames[1] = HeapAlloc (*pSaHeap, 0, ACCT_NAME_SIZE);
		FindGroup (2, groupNames[1], ACCT_NAME_SIZE);
	} else groupNames[1] = grpName;

	/* Wyszukiwanie trzech nazw i tworzenie identyfikatorw SID. */
	for (iSid = 0; iSid < 3; iSid++) {
		pSidTable[iSid] = HeapAlloc (*pSaHeap, 0, SID_SIZE);
		ok = ok && LookupAccountName (NULL, groupNames[iSid],
				pSidTable[iSid], &sidCount[iSid],
				refDomain[iSid], &refDomainCount[iSid], &sNamUse[iSid]);
	}
	if (!ok)
		ReportException (_T("Blad funkcji LookupAccountName."), 22);

	/* Ustawianie identyfikatorw SID w deskryptorach zabezpiecze uytkownika i grupy. */

	if (!SetSecurityDescriptorOwner (pSD, pSidTable[0], FALSE))
		ReportException (_T ("Blad funkcji SetSecurityDescriptorOwner."), 23);
	if (!SetSecurityDescriptorGroup (pSD, pSidTable[1], FALSE))
		ReportException (_T ("Blad funkcji SetSecurityDescriptorGroup."), 24);

	/* Alokowanie struktury na list ACL. */
	pAcl = HeapAlloc (*pSaHeap, 0, ACL_SIZE);

	/* Inicjowanie listy ACL. */
	if (!InitializeAcl (pAcl, ACL_SIZE, ACL_REVISION))
		ReportException (_T ("Blad inicjowania listy ACL."), 25);

	/* Dodawanie wpisw ACE. Przegldanie bitw uprawnie. Jeli bit jest 
              ustawiony, funkcja dodaje wpis zezwalajcy, a przy 
              bicie wyzerowanym - odmawiajcy. */

	success = TRUE;
	for (iBit = 0; iBit < 9; iBit++) {
		if ((unixPerms >> (8 - iBit) & 0x1) != 0 && allowedAceMasks[iBit % 3] != 0)
			success = success && AddAccessAllowedAce (pAcl, ACL_REVISION,
					allowedAceMasks[iBit % 3], pSidTable[iBit / 3]);
		else if (deniedAceMasks[iBit % 3] != 0)
			success = success && AddAccessDeniedAce (pAcl, ACL_REVISION,
					deniedAceMasks[iBit % 3], pSidTable[iBit / 3]);
	}

	if (!success)
		ReportException (_T ("Blad funkcji AddAce."), 26);
	if (!IsValidAcl (pAcl))
		ReportException (_T ("Utworzono niepoprawna liste ACL."), 27);

	/* Lista ACL jest ju kompletna. Naley powiza j z deskryptorem zabezpiecze. */

	if (!SetSecurityDescriptorDacl (pSD, TRUE, pAcl, FALSE))
		ReportException (_T ("Blad funkcji SetSecurityDescriptorDacl."), 28);
	if (!IsValidSecurityDescriptor (pSD))
		ReportException (_T ("Utworzono niepoprawny deskryptor zabezpieczen."), 29);
}	/* Koniec bloku __try-except. */

__except ((GetExceptionCode() != STATUS_NO_MEMORY) ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
{
	/*  Wystpi wyjtek i program go zgosi. Caa pami zaalokowana przy
       tworzeniu deskryptora i atrybutw zabezpiecze jest zwalniana. */
	if (pSaHeap != NULL)
		HeapDestroy (pSaHeap);
	pSA = NULL;
}
	return pSA;
}

void DestroyUnixSA (LPSECURITY_ATTRIBUTES pSa, LPHANDLE pHeap)
{
	/* Dealokuje struktur atrybutw zabezpiecze zawierajc bezwzgldne deskryptory zabezpiecze. */
	if (pHeap != NULL) HeapDestroy (pHeap);
}

LPSECURITY_ATTRIBUTES InitializeAccessOnlySA (DWORD unixPerms,
		LPTSTR usrName, LPTSTR grpName, LPDWORD aceMasks, LPHANDLE pHeap)
/* Do zaimplementowania. */
{
	return NULL;
}

DWORD ReadFilePermissions (LPTSTR lpfileName, LPTSTR userName, LPTSTR groupName)

/* Zwraca uprawnienia do pliku w stylu UNIX-a. */
{
	PSECURITY_DESCRIPTOR pSD = NULL;
	DWORD lenNeeded, permissionBits, iAce;
	BOOL fileDacl, aclDefaulted, ownerDaclDefaulted, groupDaclDefaulted;
	DWORD dacl[ACL_SIZE/sizeof(DWORD)];	/* Listy ACL wymagaj wyrwnania do typu DWORD. */
	PACL pAcl = (PACL) &dacl;
	ACL_SIZE_INFORMATION aclSizeInfo;
	PACCESS_ALLOWED_ACE pAce;
	BYTE aclType;
	PSID pOwnerSid, pGroupSid;
	TCHAR refDomain[2][DOM_SIZE];
	DWORD refDomainCount[2] = {DOM_SIZE, DOM_SIZE};
	DWORD accountNameSize[2] = {ACCT_NAME_SIZE, ACCT_NAME_SIZE};
	SID_NAME_USE sNamUse[] = {SidTypeUser, SidTypeGroup};

	/* Okrelanie rozmiaru potrzebnego na deskryptor zabezpiecze. */
	GetFileSecurity (lpfileName, OWNER_SECURITY_INFORMATION |
			GROUP_SECURITY_INFORMATION | DACL_SECURITY_INFORMATION,
			NULL, 0, &lenNeeded);

	/* Tworzenie deskryptora zabezpiecze. */
	pSD = malloc (lenNeeded);
	if ((pSD != NULL) && !GetFileSecurity (lpfileName, OWNER_SECURITY_INFORMATION |
			GROUP_SECURITY_INFORMATION | DACL_SECURITY_INFORMATION,
			pSD, lenNeeded, &lenNeeded))
		ReportError (_T ("Blad funkcji GetFileSecurity."), 30, TRUE);
	
	if (!GetSecurityDescriptorDacl (pSD, &fileDacl, &pAcl, &aclDefaulted))
		ReportError (_T ("Blad funkcji GetSecurityDescriptorDacl."), 31, TRUE);

	/* Pobieranie liczby wpisw ACE na licie ACL. */

	if (!GetAclInformation (pAcl, &aclSizeInfo,
			sizeof (ACL_SIZE_INFORMATION), AclSizeInformation))
		ReportError (_T ("Blad funkcji GetAclInformation."), 32, TRUE);


	/* Pobieranie kadego wpisu ACE. Wiadomo, e list ACL utworzya funkcja
       InitializeUnixSA, dlatego wpisy ACE s dostpne w takiej samej 
       kolejnoci, jak bity uprawnie w systemie UNIX. */

	permissionBits = 0;
	for (iAce = 0; iAce < aclSizeInfo.AceCount; iAce++) {
		GetAce (pAcl, iAce, &pAce);
		aclType = pAce->Header.AceType;
		if (aclType == ACCESS_ALLOWED_ACE_TYPE)
			permissionBits |= (0x1 << (8-iAce));
	}

	/* Wyszukiwanie nazwy waciciela i grupy. */
    /* Najpierw program szuka identyfikatorw SID. */

	if (!GetSecurityDescriptorOwner (pSD, &pOwnerSid, &ownerDaclDefaulted))
		ReportError (_T ("Blad funkcji GetSecurityDescriptorOwner."), 33, TRUE);
	if (!GetSecurityDescriptorGroup (pSD, &pGroupSid, &groupDaclDefaulted))
		ReportError (_T ("Blad funkcji GetSecurityDescriptorGroup."), 34, TRUE);
	if (!LookupAccountSid (NULL, pOwnerSid, userName, &accountNameSize[0], refDomain[0],
			&refDomainCount[0], &sNamUse[0]))
		ReportError (_T ("Blad funkcji LookupAccountSid."), 35, TRUE);
	if (!LookupAccountSid (NULL, pGroupSid, groupName, &accountNameSize[1], refDomain[1],
			&refDomainCount[1], &sNamUse[1]))
		ReportError (_T ("Blad funkcji LookupAccountSid."), 36, TRUE);
	free (pSD);	
	return permissionBits;
}

BOOL ChangeFilePermissions (DWORD fPerm, LPTSTR fileName, 
							LPDWORD allowedAceMasks, LPDWORD deniedAceMasks)

/* Zmienianie uprawnie do istniejcego pliku. Grupa pozostaje taka sama. */

/* Strategia:
   1. Pobieranie istniejcego deskryptora zabezpiecze za pomoc 
     wewntrznej funkcji ReadFilePermissions.
   2. Tworzenie atrybutu zabezpiecze na nazw waciciela i bity uprawnie.
   3. Wyodrbnianie deskryptora zabezpiecze.
   4. Ustawianie zabezpiecze pliku za pomoc nowego deskryptora. */
{
	TCHAR userName[ACCT_NAME_SIZE], groupName[ACCT_NAME_SIZE];
	LPSECURITY_ATTRIBUTES pSA;
	PSECURITY_DESCRIPTOR pSD = NULL;
	HANDLE heap;

	/* Zakadamy, e plik istnieje.	*/
	if (_taccess (fileName, 0) != 0)	/* Plik nie istnieje. */
		return FALSE;
	ReadFilePermissions (fileName, userName, groupName); /* Zwracana warto nie jest potrzebna */
	pSA = InitializeUnixSA (fPerm, userName, groupName, allowedAceMasks, deniedAceMasks, &heap);
	pSD = pSA->lpSecurityDescriptor;

	if (!SetFileSecurity (fileName, DACL_SECURITY_INFORMATION, pSD))
		ReportError (_T ("Blad funkcji SetFileSecurity."), 37, TRUE);

	DestroyUnixSA (pSA, heap);
	return TRUE;
}

/* Ten kod to wskazwka do rozwizania jednego z wicze. */

static VOID FindGroup (DWORD GroupNumber, LPTSTR GroupName, DWORD cGroupName)
/*	Wyszukuje nazw grupy powizan z wacicielem biecego procesu. */

{
	TCHAR refDomain[DOM_SIZE];
	DWORD refDomainCount = DOM_SIZE;
	SID_NAME_USE GroupSidType  = SidTypeGroup;
	HANDLE tHandle;
	TOKEN_GROUPS TokenG[20]; /* Potrzebne jest miejsce na te dane. */
	DWORD TISize, accountNameSize = cGroupName;

	if (!OpenProcessToken (GetCurrentProcess(), TOKEN_ALL_ACCESS, &tHandle))
		ReportError (_T ("Blad funkcji OpenProcessToken."), 0, TRUE);
	if (!GetTokenInformation (tHandle, TokenGroups,
			&TokenG, sizeof (TokenG), &TISize)) {
		ReportError (_T ("Blad funkcji GetTokenInfo."), 0, TRUE);
	}

	/* Eksperymenty pokazuj, e istniej nastpujce grupy:
		0	 -	None
		1	 -	Everyone
		2	 -	pierwsza niestandardowa grupa
	 	3,.. -	naley zwraca uwag na zmienn count, ktra jest 
				czci struktury - zobacz dokumentacj! */

	if (!LookupAccountSid (NULL, TokenG[0].Groups[GroupNumber].Sid,
			GroupName, &accountNameSize, refDomain, &refDomainCount, &GroupSidType))
			ReportError (_T("Blad funkcji LookupAccountSid."), 0, TRUE);
	return;
}
