/* Rozdzia 14. ServerCP.
 * Wielowtkowy serwer obsugiwany z wiersza polece. Wersja z potokiem nazwanym. Przykad zastosowania mechanizmu IOCP.
 * Stosowanie: Server[nazwaUytkownika nazwaGrupy]
 * JEDEN EGZEMPLARZ POTOKU DLA KADEGO KLIENTA.
 * Przyjto, e MAX_SERVER_TH <= 64 (z uwagi na funkcj WaitForMultipleObject).
 */

#include "Everything.h"
#include "ClientServer.h" /* Definicje komunikatw z daniami i odpowiedziami. */

typedef struct {				/* Argument wtku serwera. */
	HANDLE hCompPort;			/* Uchwyt portu. */
	DWORD threadNum;
} SERVER_THREAD_ARG;
typedef SERVER_THREAD_ARG *LPSERVER_THREAD_ARG;

enum CP_CLIENT_PIPE_STATE { connected, requestRead, computed, responding, respondLast };
/*	Struktura argumentu kadego egzemplarza potoku nazwanego. */
typedef struct {	/* Klucze portu dotycz tych struktur. */
		HANDLE hCompPort;
		HANDLE	hNp;	/* Reprezentuje zaleg operacj ReadFile. */
		HANDLE hTempFile;	
		FILE *tFp;		/* Uywany przez proces serwera do przechowywania wynikw. */
		TCHAR tmpFileName[MAX_PATH]; /* Nazwa pliku tymczasowego na odpowied. */
		REQUEST request; /* Operacje ConnectNamedPipe. */
		DWORD nBytes;
		enum CP_CLIENT_PIPE_STATE npState;
		LPOVERLAPPED pOverLap;
} CP_KEY;

OVERLAPPED overLap;
volatile static int shutDown = 0;
static DWORD WINAPI Server (LPSERVER_THREAD_ARG);
static DWORD WINAPI ServerBroadcast (LPLONG);
static BOOL  WINAPI Handler (DWORD);
static DWORD WINAPI ComputeThread (PVOID);

static CP_KEY Key[MAX_CLIENTS_CP];

_tmain (int argc, LPTSTR argv[])
{
	HANDLE hCompPort, hMonitor, hSrvrThread[MAX_CLIENTS];
	DWORD iNp, iTh;
	DWORD AceMasks[] =	/* Prawa dostpu do potoku nazwanego. */
		{STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0X1FF, 0, 0 };
	SECURITY_ATTRIBUTES tempFileSA = {sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
	SERVER_THREAD_ARG ThArgs[MAX_SERVER_TH]; /* MAX_SERVER_TH <= 64 */
	OVERLAPPED ov = {0};

	if (!WindowsVersionOK (6, 0)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 6.0 lub nowszego."), 1, FALSE);

	/* Procedura sterujca konsoli umoliwiajca zamknicie serwera. */
	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T("Nie mozna utworzyc procedury sterujacej."), 1, TRUE);

	/* Dla uproszczenia zabezpieczenia potoku umieszczono w komentarzach. */
//	if (argc == 4)		/* Opcjonalne zabezpieczenia potoku. */
//		pNPSA = InitializeUnixSA (0440, argv[1], argv[2], AceMasks, &hSecHeap);
			
	/* Tworzenie wtku do okresowego rozpowszechniania nazwy potoku. */
	hMonitor = (HANDLE) _beginthreadex (NULL, 0, ServerBroadcast, NULL, 0, NULL);

	hCompPort = CreateIoCompletionPort (INVALID_HANDLE_VALUE, NULL, 0, MAX_SERVER_TH); 
	if (hCompPort == NULL) ReportError (_T("Nieudane tworzenie portu."), 2, TRUE);

	/*	Tworzenie potoku nazwanego ze struktur OVERLAPPED dla kadego potencjalnego klienta. */
    /* Potok ten jest dodawany do portu. */
    /* Zakadamy, e maksymalna liczba klientw znacznie przekracza */
    /* liczb wtkw serwera.	*/
	for (iNp = 0; iNp < MAX_CLIENTS_CP; iNp++) {
		memset (&Key[iNp], 0, sizeof(CP_KEY));
		Key[iNp].hCompPort = hCompPort;
		Key[iNp].hNp =  CreateNamedPipe ( SERVER_PIPE, 
			PIPE_ACCESS_DUPLEX | FILE_FLAG_OVERLAPPED,
			PIPE_READMODE_MESSAGE | PIPE_TYPE_MESSAGE,
			MAX_CLIENTS_CP, 0, 0, INFINITE, &tempFileSA);
		if (Key[iNp].hNp == INVALID_HANDLE_VALUE) 
			ReportError (_T("Blad tworzenia potoku nazwanego."), 3, TRUE);
		GetTempFileName (_T ("."), _T ("CLP"), 0, Key[iNp].tmpFileName);
		Key[iNp].pOverLap = &overLap;
		/*	Dodawanie egzemplarza potoku nazwanego do portu. */
		if (CreateIoCompletionPort (Key[iNp].hNp, hCompPort, (ULONG_PTR)&Key[iNp], 0) == NULL)
			ReportError (_T("Blad dodawania potoku do portu."), 4, TRUE);
		if (!ConnectNamedPipe (Key[iNp].hNp, &ov)
			&& GetLastError() != ERROR_IO_PENDING) 
			ReportError (_T("Blad funkcji ConnectNamedPipe w watku glownym."), 6, TRUE);
		Key[iNp].npState = connected;
	}

	/*	Tworzenie wtkw roboczych serwera i nazwy pliku tymczasowego dla kadego z nich. */
	for (iTh = 0; iTh < MAX_SERVER_TH; iTh++) {
		ThArgs[iTh].hCompPort = hCompPort;
		ThArgs[iTh].threadNum = iTh;
		hSrvrThread[iTh] = (HANDLE)_beginthreadex (NULL, 0, Server, &ThArgs[iTh], 0, NULL);
		if (hSrvrThread[iTh] == NULL)
			ReportError (_T ("Nieudane tworzenie watku serwera."), 2, TRUE);
	}
	_tprintf (_T("Wszystkie watki serwera dzialaja.\n"));

	/* Oczekiwanie na zakoczenie dziaania przez wszystkie wtki serwera (<= 64). */
	WaitForMultipleObjects (MAX_SERVER_TH, hSrvrThread, TRUE, INFINITE);
	_tprintf (_T ("Wszystkie watki serwera zakonczyly prace.\n"));
	WaitForSingleObject (hMonitor, INFINITE);
	_tprintf (_T ("Watek obserwujacy zakonczyl prace.\n"));

	CloseHandle (hMonitor);
	for (iTh = 0; iTh < MAX_SERVER_TH; iTh++) { 
		/* Zamykanie uchwytw potoku. */
		CloseHandle (hSrvrThread[iTh]);
	}
	CloseHandle (hCompPort);

	_tprintf (_T ("Proces serwera konczy prace.\n"));
	return 0;
}

static DWORD WINAPI Server (LPSERVER_THREAD_ARG pThArg)
/* Funkcja wtku serwera. */
{
	/* Kady wtek przechowuje struktury danych dania, odpowiedzi i
	operacji pomocniczych na stosie. */

	DWORD nXfer;
	BOOL disconnect = FALSE;
	CP_KEY *pKey;
	RESPONSE response;
	OVERLAPPED serverOv = {0}, * pOv = NULL;

	/*	Gwna ptla wtku serwera. Suy do przetwarzania zgosze zakoczenia. */
	while (!disconnect && !shutDown) {	/* Oczekiwanie na zakoczenie zalegych operacji. */
		
		if (!GetQueuedCompletionStatus (pThArg->hCompPort, &nXfer, (PULONG_PTR)&pKey, &pOv, INFINITE))
		{
			DWORD errCode = GetLastError();
			if (errCode == ERROR_OPERATION_ABORTED) continue;
			if (errCode != ERROR_MORE_DATA)
				ReportError (_T("Blad funkcji GetQueuedCompletionStatus."), 0, TRUE);
		}
		/* Wbrew dokumentacji funkcja moe zwrci false, co oznacza wicej danych. */
		if (shutDown) continue;

		/* Zmienna npState okrela, czy operacja na potoku zostaa ukoczona: connected, requestRead, ... */
		switch (pKey->npState) {
			case connected:
				{ /* Poczenie zostao nawizane  naley wczyta danie. */
                  /* Otwieranie pliku tymczasowego na wyniki dla danego poczenia. */
					// _tprintf (_T("case connected.\n")); /* Mona wczy instrukcje ledzce tego rodzaju. */
					
					_tcscpy (pKey->request.record, _T(""));
					pKey->request.rqLen = 0;
					pKey->npState = requestRead;
					disconnect = !ReadFile (pKey->hNp, &(pKey->request), RQ_SIZE, &(pKey->nBytes), &serverOv)
						&& GetLastError() != ERROR_IO_PENDING; 
					continue;
				} 
			case requestRead:
				{ /* Zakoczono odczyt  naley przetworzy danie. */
              /* Wtek przetwarza dania asynchronicznie. */
              /* Serwer moe przej do przetwarzania innych da. */
					HANDLE hComputeThread;
					DWORD computeExitCode;
					// _tprintf (_T("case requestRead.\n"));
					hComputeThread = (HANDLE)_beginthreadex (NULL, 0, ComputeThread, pKey, 0, NULL);
					if (NULL == hComputeThread) continue;
					WaitForSingleObject(hComputeThread, INFINITE);
					GetExitCodeThread (hComputeThread, &computeExitCode);
					CloseHandle (hComputeThread);

					pKey->npState = computed;
					if (computeExitCode != 0)
					{
						pKey->npState = respondLast;
					}

					if (!PostQueuedCompletionStatus (pKey->hCompPort, 0, (ULONG_PTR)pKey, pKey->pOverLap))
						ReportError (_T("Nieudane przesylanie stanu zakonczenia w watku obliczeniowym.\n"), 0, TRUE);

					continue;
				}
			case computed:
				{
					/* Wyniki znajduj si w pliku tymczasowym. */
                /* Przesyanie odpowiedzi po jednym wierszu. Wygodnie jest wykorzysta
                   w tym miejscu oparte na wierszach procedury z biblioteki jzyka C. */
					// _tprintf (_T("case computed.\n"));
					pKey->tFp = _tfopen (pKey->tmpFileName, _T ("r"));
					if (pKey->tFp == NULL) {
						_tperror (_T("Nieudane otwieranie pliku wyjsciowego."));
						disconnect = 1;
						continue;
					}
					pKey->npState = responding;
					if (_fgetts (response.record, MAX_RQRS_LEN, pKey->tFp) != NULL) {
						response.rsLen = strlen(response.record) + 1;
						disconnect = !WriteFile (pKey->hNp, &response, response.rsLen + sizeof(response.rsLen), &nXfer, &serverOv)
							&& GetLastError() != ERROR_IO_PENDING;
					} else {
						/* Bdny odczyt. Przesanie zgoszenie zakoczenia i przejcie do 
                       nastpnego etapu. */
						pKey->npState = respondLast;
						if (!PostQueuedCompletionStatus (pKey->hCompPort, 0, (ULONG_PTR)pKey, pKey->pOverLap))
							ReportError (_T("Nieudane przesylanie stanu zakonczenia przy przechodzeniu do stanu respondLast.\n"), 20, TRUE);
					}
					continue;
				}
			case responding:
				{
					// _tprintf (_T("case responding.\n"));
					/* Trwa wysyanie odpowiedzi po jednym rekordzie. */
                /* Stan ten si nie zmienia, dopki rekordy s dostpne. */
					if (_fgetts (response.record, MAX_RQRS_LEN, pKey->tFp) != NULL) {
						response.rsLen = strlen(response.record) + 1;
						disconnect = !WriteFile (pKey->hNp, &response, response.rsLen + sizeof(response.rsLen), &nXfer, &serverOv)
									&& GetLastError() != ERROR_IO_PENDING;
					} else {
						pKey->npState = respondLast;
						if (!PostQueuedCompletionStatus (pKey->hCompPort, 0, (ULONG_PTR)pKey, pKey->pOverLap))
							ReportError (_T("Nieudane przesylanie stanu zakonczenia przy przechodzeniu do stanu respondLast.\n"), 21, TRUE);
					}
					continue;
				} 
			case respondLast:
				{
					// _tprintf (_T("case respondLast.\n"));
					/* Zachowanie poczenia. */
					pKey->npState = connected;					
					_tcscpy (response.record, _T(""));
					response.rsLen = 0;
					disconnect = !WriteFile (pKey->hNp, &response, sizeof(response.rsLen), &nXfer, &serverOv) 
								&& GetLastError() != ERROR_IO_PENDING;
					continue;
				} 
			default:
				{
					// _tprintf (_T("case default.\n"));
					/* Krytyczne dla wtku. Brak prby przywrcenia dziaania programu - to dobre wiczenie! */
					ReportError (_T("Watek serwera znajduje sie w nieznanym stanie. Konczenie pracy."), 0, FALSE);
					return 1;
				}
		} 

		FlushFileBuffers (pKey->hNp);
		DisconnectNamedPipe (pKey->hNp);
		if (disconnect) {
			if (!ConnectNamedPipe (pKey->hNp, &serverOv)
					&& GetLastError() != ERROR_IO_PENDING) 
				ReportError (_T("Blad funkcji ConnectNamedPipe w funkcji responseComplete."), 6, TRUE);
			pKey->npState = connected;
		} else {
			_tprintf (_T("Watek %d konczy dzialanie.\n"), pThArg->threadNum);
			/* Koniec przetwarzania polecenia. Mona zwolni zasoby i wyj z wtku. */
			DeleteFile (pKey->tmpFileName);
			_tprintf (_T ("Wychodzenie z watku serwera numer %d\n"), pThArg->threadNum);
			return 0;
		}
	}
	return 0;
}

static DWORD WINAPI ComputeThread (PVOID pArg)
{
	PROCESS_INFORMATION procInfo;
	STARTUPINFO startInfo;
	CP_KEY *pKey = (CP_KEY *)pArg;
	SECURITY_ATTRIBUTES tempSA = {sizeof(SECURITY_ATTRIBUTES), NULL, TRUE};
	GetStartupInfo (&startInfo);

	/* Otwieranie pliku tymczasowego i usuwanie jego wczeniejszej zawartoci. */
	pKey->hTempFile = 
		CreateFile (pKey->tmpFileName, GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ | FILE_SHARE_WRITE, &tempSA,
		CREATE_ALWAYS, FILE_ATTRIBUTE_TEMPORARY, NULL);

	if (pKey->hTempFile != INVALID_HANDLE_VALUE) {
		startInfo.hStdOutput = pKey->hTempFile;
		startInfo.hStdError = pKey->hTempFile;
		startInfo.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
		startInfo.dwFlags = STARTF_USESTDHANDLES;
		if (!CreateProcess (NULL, pKey->request.record, NULL, NULL, TRUE, /* Dziedziczenie uchwytw. */
				0, NULL, NULL, &startInfo, &procInfo))
			ReportError (_T("Nie mozna utworzyc procesu dla serwera."), 0, TRUE);

		/* Proces serwera dziaa. */
		CloseHandle (procInfo.hThread);
		WaitForSingleObject (procInfo.hProcess, INFINITE);
		CloseHandle (procInfo.hProcess);
		CloseHandle(pKey->hTempFile);
	} else {
		ReportError (_T("Nieudane otwiera pliku tymczasowego."), 0, TRUE);
		return 1;
	}

	return 0;
}

static DWORD WINAPI ServerBroadcast (LPLONG pNull)
{
	MS_MESSAGE MsNotify;
	DWORD nXfer, iNp;
	HANDLE hMsFile;

	/* Otwieranie szczeliny pocztowej dla jej klienta (jednostki zapisujcej). */
	while (!shutDown) { /* Dziaa dopty, dopki istniej wtki serwera. */
        /* Oczekiwanie z otwarciem szczeliny pocztowej na nastpnego klienta. */
		Sleep (CS_TIMEOUT);
		hMsFile = CreateFile (MS_CLTNAME, GENERIC_WRITE | GENERIC_READ,
				FILE_SHARE_READ | FILE_SHARE_WRITE,
				NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hMsFile == INVALID_HANDLE_VALUE) continue;

		/* Wysyanie komunikatu do szczeliny pocztowej. */

		MsNotify.msStatus = 0;
		MsNotify.msUtilization = 0;
		_tcscpy (MsNotify.msName, SERVER_PIPE);
		if (!WriteFile (hMsFile, &MsNotify, MSM_SIZE, &nXfer, NULL))
			ReportError (_T ("Serwer  blad zapisu do szczeliny pocztowej."), 13, TRUE);
		CloseHandle (hMsFile);
	}

	_tprintf (_T("Ustawiona flaga zamkniecia. Anulowanie zaleglych operacji wejscia-wyjscia.\n"));
    /* Anulowanie wszystkich zaleglych operacji wejscia-wyjscia. Jest to zwizane z systemami NT6. Co si stanie bez tego kroku? */
	for (iNp = 0; iNp < MAX_CLIENTS_CP; iNp++) {
		CancelIoEx (Key[iNp].hNp, NULL);
	}
	_tprintf (_T ("Zamykanie watku obserwujacego.\n"));

	_endthreadex (0);
	return 0;
}


BOOL WINAPI Handler (DWORD CtrlEvent)
{
	/* Zamykanie systemu. */
	_tprintf (_T("W procedurze sterujacej konsoli.\n"));
	InterlockedIncrement(&shutDown);
	return TRUE;
}
