/* Rozdzia 14. cciOV.
	Przeksztacanie plikw za pomoc uproszczonego szyfru Cezara i struktur OVERLAPPED. */
/* cciOV przesuniecie plik1 plik2 */
/* Ten program ilustruje asynchroniczne operacje nakadanego wejcia-wyjcia. */

/* Strona http://support.microsoft.com/kb/156932 zawiera wane informacje o asynchronicznych operacjach wejcia-wyjcia. */
/* Moe to by przydatne przy badaniu wydajnoci programu cciOV (nie jest ona tak wysoka, jak innych implementacji). */

#include "Everything.h"

#define MAX_OVRLP 4		/* Warto musi by <= 32 z uwagi na funkcj WaitForMultipleObjects. 
                           Wedug eksperymentw najlepiej jest uy liczby procesorw. */
#define REC_SIZE 16384 /* 16K to minimalny rozmiar potrzebny do uzyskania dobrej wydajnoci 
                           (warto ta okazaa si optymalna take w kilku eksperymentach w systemie czteroprocesorowym.							
							Warto dostosowa t warto do docelowej maszyny.
							UWAGA: licznik ptli ma typ dword, co ogranicza rozmiar rekordu. */

int _tmain (int argc, LPTSTR argv[])
{
	HANDLE hInputFile, hOutputFile;
	DWORD shift, nIn[MAX_OVRLP], nOut[MAX_OVRLP], ic, i;
	/* Dla kadej zalegej operacji nakadanego wejcia-wyjcia */
    /* istnieje kopia kadej z poniszych struktur. */
	OVERLAPPED overLapIn[MAX_OVRLP], overLapOut[MAX_OVRLP];
	/* Indeksy pierwszego zdarzenia to 0 dla odczytu i 1 dla zapisu. */
    /* Funkcja WaitForMultipleObjects wymaga cigej tablicy. */
	HANDLE hEvents[2][MAX_OVRLP];
	/* Pierwszy indeks tych dwch buforw to operacja wejcia-wyjcia. */
	CHAR buffer[MAX_OVRLP][REC_SIZE];
	LARGE_INTEGER curPosIn, curPosOut, fileSize;
	LONGLONG nRecords, iWaits;

	if (argc != 4)
		ReportError  (_T ("Stosowanie: cciOV przesuniecie plik1 plik2"), 1, FALSE);
	
	shift = _ttoi(argv[1]);

	hInputFile = CreateFile (argv[2], GENERIC_READ,
			0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (hInputFile == INVALID_HANDLE_VALUE) 
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wejsciowego."), 2, TRUE);
	
	hOutputFile = CreateFile (argv[3], GENERIC_WRITE,
			0, NULL, CREATE_ALWAYS, FILE_FLAG_OVERLAPPED, NULL);
	if (hOutputFile == INVALID_HANDLE_VALUE) {
		CloseHandle(hInputFile);
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego."), 3, TRUE);
	}

	/* Okrelanie cznej liczby rekordw. Na kocu nie moe
       znajdowa si niepeny rekord. */
	if (!GetFileSizeEx (hInputFile, &fileSize)) {
		CloseHandle(hInputFile); CloseHandle(hOutputFile);
		ReportError (_T("Blad krytyczny przy pobieraniu rozmiaru pliku wejsciowego."), 4, TRUE);
	}
	nRecords = (fileSize.QuadPart + REC_SIZE - 1) / REC_SIZE;

	/*  Tworzenie niezgoszonego zdarzenia z rcznym zerowaniem dla
       struktur OVERLAPPED. Naley zainicjowa odczyt kadego
       bufora odpowiadajcego strukturze OVERLAPPED. */
	curPosIn.QuadPart = 0;
	for (ic = 0; ic < MAX_OVRLP; ic++) {
		/* Zdarzenie okrelajce zakoczenie odczytu. */
		hEvents[0][ic] = overLapIn[ic].hEvent = CreateEvent (NULL, TRUE, FALSE, NULL); 
		/* Zdarzenie okrelajce zakoczenie zapisu. */
		hEvents[1][ic] = overLapOut[ic].hEvent = CreateEvent (NULL, TRUE, FALSE, NULL); 
		if (NULL == hEvents[0][ic] || NULL == hEvents[1][ic]) {
			CloseHandle(hInputFile); CloseHandle(hOutputFile);
			ReportError (_T("Blad krytyczny przy tworzeniu zdarzen."), 5, TRUE);
		}
		/* Ustawianie pozycji w pliku. Inicjowanie pierwszego odczytu. */
		overLapIn[ic].Offset = curPosIn.LowPart;
		overLapIn[ic].OffsetHigh = curPosIn.HighPart;
		if (curPosIn.QuadPart < fileSize.QuadPart) {
			if (!ReadFile (hInputFile, buffer[ic], REC_SIZE, &nIn[ic], &overLapIn[ic])
				&& GetLastError() != ERROR_IO_PENDING) {
				CloseHandle(hInputFile); CloseHandle(hOutputFile);
				ReportError (_T("Blad krytyczny przy rozpoczynaniu odczytu."), 6, TRUE);
			}
		}
		/* Odczyt jest kolejkowany i zakoczy si w przyszoci, 
		   jeli jeszcze si nie zakoczy. */
		curPosIn.QuadPart += (LONGLONG)REC_SIZE;
	}

	/*  Wszystkie operacje odczytu dziaaj. Oczekiwanie na zdarzenia zwizane z odczytem i zapisem.
       Kontynuowanie pracy do czasu przetworzenia wszystkich rekordw. */

	iWaits = 0;
	while (iWaits < 2 * nRecords) {
		ic = WaitForMultipleObjects (2 * MAX_OVRLP,	hEvents[0], FALSE, INFINITE) - WAIT_OBJECT_0;
		iWaits++;

		if (ic < MAX_OVRLP) { /* Odczyt zosta zakoczony. */
			if (!GetOverlappedResult (hInputFile, &overLapIn[ic], &nIn[ic], FALSE)) {
				CloseHandle(hInputFile); CloseHandle(hOutputFile);
				ReportError (_T ("Nieudany odczyt."), 0, TRUE);
			}
			/* Zerowanie zdarzenia przed nastpnym wywoaniem funkcji WaitForMultipleObjects. 
             * W przeciwnym razie zdarzenie nie zostanie wyzerowane do czasu nastpnego odczytu dla danego indeksu ic. */
			ResetEvent (hEvents[0][ic]);
			/* Przetwarzanie rekordu i rozpoczcie zapisu od obecnej pozycji. */
			curPosIn.LowPart = overLapIn[ic].Offset;
			curPosIn.HighPart = overLapIn[ic].OffsetHigh;
			curPosOut.QuadPart = curPosIn.QuadPart;
			overLapOut[ic].Offset = curPosOut.LowPart;
			overLapOut[ic].OffsetHigh = curPosOut.HighPart;
			
			/* Szyfrowanie rekordu. */
			for (i = 0; i < nIn[ic]; i++)
				buffer[ic][i] = (BYTE)((buffer[ic][i] + shift) % 256);
			if (!WriteFile (hOutputFile, buffer[ic], nIn[ic], &nOut[ic], &overLapOut[ic])
				&& GetLastError() != ERROR_IO_PENDING) {
					CloseHandle(hInputFile); CloseHandle(hOutputFile);
					ReportError (_T("Blad krytyczny przy rozpoczynaniu zapisu."), 7, TRUE);
			}

			/* Przygotowanie wejciowej struktury OVERLAPPED na potrzeby nastpnego odczytu 
           (inicjowanego po zakoczeniu zapisu). */
			curPosIn.QuadPart += REC_SIZE * (LONGLONG) (MAX_OVRLP);
			overLapIn[ic].Offset = curPosIn.LowPart;
			overLapIn[ic].OffsetHigh = curPosIn.HighPart;

		} else if (ic < 2 * MAX_OVRLP) {	/* Zakoczono zapis. */

			/* Rozpoczcie odczytu. Najpierw naley przeprowadzi test, 
           aby nie wczytywa danych spoza koca pliku. */
			ic -= MAX_OVRLP;	/* Ustawianie indeksu bufora wyjciowego. */
			if (!GetOverlappedResult (hOutputFile, &overLapOut[ic], &nOut[ic], FALSE)) {
				CloseHandle(hInputFile); CloseHandle(hOutputFile);
				ReportError (_T ("Read failed."), 0, TRUE);
			}

			/* Zerowanie zdarzenia przed nastpnym wywoaniem funkcji WaitForMultipleObjects. 
             * W przeciwnym razie zdarzenie nie zostanie wyzerowane do czasu nastpnego odczytu dla danego indeksu ic. */
			ResetEvent (hEvents[1][ic]);
			curPosIn.LowPart = overLapIn[ic].Offset;
			curPosIn.HighPart = overLapIn[ic].OffsetHigh;
			/* Rozpoczcie nowego odczytu. */
			if (curPosIn.QuadPart < fileSize.QuadPart) {
				if (!ReadFile (hInputFile, buffer[ic], REC_SIZE, &nIn[ic], &overLapIn[ic])
					&& GetLastError() != ERROR_IO_PENDING) {
						CloseHandle(hInputFile); CloseHandle(hOutputFile);
						ReportError (_T("Blad krytyczny przy rozpoczynaniu odczytu."), 8, TRUE);
				}
			}
		}
		else {	/* Moliwe tylko po bdzie oczekiwania. */
			CloseHandle(hInputFile); CloseHandle(hOutputFile);
			ReportError (_T ("Blad oczekiwania."), 0, TRUE);
		}
	}

	/*  Zamykanie wszystkich uchwytw zdarze. */
	for (ic = 0; ic < MAX_OVRLP; ic++) {
		CloseHandle (hEvents[0][ic]);
		CloseHandle (hEvents[1][ic]);
	}
	CloseHandle (hInputFile);
	CloseHandle (hOutputFile);
	return 0;
}
