/* Rozdzia 14. cciMT_VTP. - Nie mona zbudowa w rodowisku VS 2005. Wymaga systemu NT6.
	Przeksztacanie plikw za pomoc uproszczonego szyfru Cezara z wykorzystaniem wielu wtkw.
	Stosowanie wtkw i puli wtkw zamiast operacji nakadanego wejcia-wyjcia. 
	Uzyskany kod jest DUO prostszy. */
/* cciMT_VTP plik1 plik2 */
#include "Everything.h"

#define MAX_OVRLP 4  /* Liczba wtkw roboczych (zwykle najlepiej jest uy liczby procesorw)
                         - wiczenie: dodaj opcj wiersza polece. */
#define RECORD_SIZE 16384  /* Blok ma rozmiar 16K - rozmiar pliku wejciowego to
                            * wielokrotno wartoci MAX_OVRLP * RECORD_SIZE.
                            * 16K to optymalna warto wedug prostych testw.
                            * Mona doda opcj wiersza polece. Zobacz komentarze w pliku cciMT. */
#define SFP_ERROR 0xFFFFFFFF  /* Bd pobierania rozmiaru pliku.  */

typedef struct TH_ARG_T {
	volatile HANDLE hIn;
	volatile HANDLE hOut;
	volatile LARGE_INTEGER FileSize;
} TH_ARG;
TH_ARG ThArg[MAX_OVRLP];  // Globalnie dostpna do uytku przez funkcj zwrotn puli wtkw.

VOID CALLBACK ReadWrite (PTP_CALLBACK_INSTANCE, PVOID, PTP_WORK);
int WorkerId = 0;	// Niepowtarzalny identyfikator okrelany dla kadego egzemplarza funkcji zwrotnej.
DWORD shift;

/**** ZADANIE: usprawnij zamykanie uchwytu pliku, jeli operacja w wtku zawiedzie.
      Pomocne moe by uycie funkcji ReportException zamiast ReportError. Zobacz te program cciMT. ****/
int _tmain (int argc, LPTSTR argv[])
{
	HANDLE hSize;
	DWORD i;
    LARGE_INTEGER inputFileSize, outputFileSize;
    PTP_WORK pWorker;

    if (!WindowsVersionOK (6, 0)) 
        ReportError (_T("Ten program wymaga systemu Windows NT 6.0 lub nowszego."), 1, TRUE);

	if (argc != 4)
		ReportError (_T("Stosowanie: cciMT_VTP przesuniecie plik1 plik2"), 1, FALSE);

	shift = _ttoi(argv[1]);
    /* Okrelanie rozmiaru pliku wejciowego. */
    hSize = CreateFile (argv[2], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
			        FILE_ATTRIBUTE_NORMAL, NULL);
 	if (hSize == INVALID_HANDLE_VALUE) 
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wejsciowego w celu okreslenia jego rozmiaru."), 2, TRUE);
	if (!GetFileSizeEx (hSize, &inputFileSize)) {
		CloseHandle (hSize);
        ReportError (_T ("Blad krytyczny przy okreslaniu rozmiaru pliku wejsciowego."), 2, TRUE);
	}
    CloseHandle (hSize);

    /* Tworzenie pliku wyjciowego o odpowiednim rozmiarze.
     * UWAGA: najatwiej jest tworzy plik wyjciowy przed uruchomieniem funkcji wtkw.
     * Jeli nie tworzysz pliku w tym miejscu, koniecznie uyj opcji OPEN_ALWAYS w funkcjach wtkw. */
    outputFileSize.QuadPart = inputFileSize.QuadPart;
    hSize = CreateFile (argv[3], GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, 
                            NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
 	if (hSize == INVALID_HANDLE_VALUE) 
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego w celu okreslenia jego rozmiaru."), 2, TRUE);
    /* Ustawianie rozmiaru pliku wyjciowego nie jest niezbdne, ale wygodne na przykad wtedy,
     * kiedy wolny obszar na dysku jest niewystarczajcy. Wtedy jedna z funkcji wtku moe
     * zawie. */
    if (!SetFilePointerEx (hSize, outputFileSize, NULL, FILE_BEGIN)) {
		CloseHandle (hSize);
		ReportError (_T ("Blad krytyczny przy ustawianiu wskaznika pliku wyjsciowego."), 2, TRUE);  
	}
	if (!SetEndOfFile (hSize)) {
		CloseHandle (hSize);
		ReportError (_T ("Blad krytyczny przy okreslaniu rozmiaru pliku wyjsciowego."), 2, TRUE);
	}
    CloseHandle (hSize);

    pWorker = CreateThreadpoolWork (ReadWrite, _T("Pula watkow roboczych"), NULL);
    if (NULL == pWorker)
        ReportError (_T("Niepowodzenie funkcji CreateThreadpoolWork."), 2, TRUE);

    /* Tworzenie wszystkich wtkw do przeksztacania plikw. */
	for (i = 0; i < MAX_OVRLP; i++) {

		/* Uwaga: utworzenie tylko dwch uchwytw (po jednym dla wejcia i wyjcia)
			oraz uycie funkcji DuplicateHandle do tworzenia uchwytw dla kadego wtku
			(np. uchwyt ThArg[i].hOut i inne s tworzone za pomoc tej funkcji DuplicateHandle)
			moe prowadzi do problemw. Wyglda na to, e funkcje ReadFile i WriteFile nie s
			bezpieczne ze wzgldu na wtki przy obsudze zduplikowanych uchwytw. Dzieje si tak nawet
			po zabezpieczeniu funkcji ReadFile i WriteFile obiektem CRITIAL_SECTION
			oraz uyciu flag NO_BUFFERING i WRITE_THROUGH. 
			W ramach wiczenia sprbuj uy zduplikowanych uchwytw. Pojawi si bdy po porwnaniu
			pliku wyjciowego z tym wygenerowanym za pomoc poprawnego programu
			cciXX. */
		ThArg[i].hIn = CreateFile (argv[2], GENERIC_READ,
			FILE_SHARE_READ, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL, NULL);
 		if (ThArg[i].hIn == INVALID_HANDLE_VALUE) 
			ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego."), 2, TRUE);
    	ThArg[i].FileSize.LowPart = inputFileSize.LowPart;
		ThArg[i].FileSize.HighPart = inputFileSize.HighPart;
		ThArg[i].hOut = CreateFile (argv[3], GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL /*| FILE_FLAG_NO_BUFFERING | FILE_FLAG_WRITE_THROUGH*/, NULL);
		/* Uwaga: NIE NALEY UYWA FLAG Z KOMENTARZA, PONIEWA WYMAGAJ ONE, ABY DUGO BUFORA 
			BYA WIELOKROTNOCI ROZMIARU SEKTORA. */
		if (ThArg[i].hOut == INVALID_HANDLE_VALUE) 
			ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego."), 3, TRUE);
	}

    /* Przekazywanie zada do puli wtkw.				*/
	for (i = 0; i < MAX_OVRLP; i++) {
        SubmitThreadpoolWork (pWorker);
    }

	/* Wszystkie wtki robocze dziaaj. Oczekiwanie na 	*/
	/* zakoczenie przez nie pracy i czenie wynikw.	*/
    /* Oczekiwanie na zakoczenie pracy przez pul wtkw.	*/
    WaitForThreadpoolWorkCallbacks (pWorker, FALSE);
   	CloseThreadpoolWork (pWorker);

	for (i = 0; i < MAX_OVRLP; i++) {
        FlushFileBuffers (ThArg[i].hOut); 
		CloseHandle (ThArg[i].hOut); 
		CloseHandle (ThArg[i].hIn);
	}
	return 0;
}

/* Funkcja zwrotna wtku roboczego do przetwarzania jednego pliku.	*/
VOID CALLBACK ReadWrite (PTP_CALLBACK_INSTANCE Instance, PVOID Context, PTP_WORK Work)
{
    /* Funkcja zwrotna dla puli wtkw do przeksztacania jednego "paska" w pliku.
     * pThArg->ThreadNum to "numer paska" (0, 1, ..., MAX_OVRLP)
     * "Pasek" i suy do przetwarzania rekordw logicznych i, i+MAX_OVRLP, i+2*MAX_OVRLP, ... 
     * RECORD_SIZE okrela rozmiar rekordu logicznego. */

  	CHAR rawRec[RECORD_SIZE];
	CHAR cciRec[RECORD_SIZE];
	LARGE_INTEGER CurPosIn, CurPosOut;
	DWORD i, nRead = 1, nWrite, iTh;
	HANDLE hIn, hOut;
	TH_ARG * pThArg;
	OVERLAPPED OvRead = {0, 0, 0, 0, NULL}, OvWrite = {0, 0, 0, 0, NULL};

	iTh = InterlockedIncrement (&WorkerId) - 1;
	pThArg = &ThArg[iTh];

	hIn = pThArg->hIn; hOut = pThArg->hOut;

	CurPosIn.QuadPart = (LONGLONG) RECORD_SIZE * iTh;
	CurPosOut.QuadPart = (LONGLONG) RECORD_SIZE * iTh;
	while (CurPosIn.QuadPart < pThArg->FileSize.QuadPart) {
		OvRead.Offset      = CurPosIn.LowPart;
		OvRead.OffsetHigh  = CurPosIn.HighPart;
		OvWrite.Offset     = CurPosOut.LowPart;
		OvWrite.OffsetHigh = CurPosOut.HighPart;
		
		if (!ReadFile (hIn, rawRec, RECORD_SIZE, &nRead, &OvRead) || nRead > RECORD_SIZE) 
            ReportError (_T("Blad odczytu pliku wejsciowego."), 8, TRUE);

		for (i = 0; i < nRead; i++)
			cciRec [i] = (rawRec[i] + shift) % 256;
		
		if (!WriteFile (hOut, cciRec, nRead, &nWrite, &OvWrite) || nWrite != nRead)
			ReportError (_T("Blad zapisu pliku wejsciowego."), 9, TRUE);
        
        CurPosIn.QuadPart += (LONGLONG) RECORD_SIZE * MAX_OVRLP;
		CurPosOut.QuadPart += (LONGLONG) RECORD_SIZE * MAX_OVRLP;
	}

	return;
}
