/* Rozdzia 14. cciMTMM.
	Przeksztacanie plikw za pomoc uproszczonego szyfru Cezara z wykorzystaniem wielu wtkw.
	Stosowanie wtkw i puli wtkw zamiast operacji nakadanego wejcia-wyjcia. 
	Zastosowano te odwzorowywanie w pamici zamiast zwykych operacji wejcia-wyjcia.
	Ten program czy cechy programw cciMM (rozdzia 5.) i cciMT (rozdzia 14.). */
/* 28 lutego 2010 - W TYM PROGRAMIE ZNAJDUJE SI BD - STARAM SI GO ZNALE W WOLNYM CZASIE - JH */
/* cciMT przesuniecie plik1 plik2 */
#include "Everything.h"

#define MAX_OVRLP 4  /* Liczba wtkw roboczych
                         - wiczenie: dodaj opcj wiersza polece. */
#define RECORD_SIZE 16384  /* Blok ma rozmiar 16K - rozmiar pliku wejciowego to
                            * wielokrotno wartoci MAX_OVRLP * RECORD_SIZE.
                            * Naley zwikszy t warto, aby poprawi wydajno (65K to dobra warto).
                            * Mona doda opcj wiersza polece. Zobacz komentarze w pliku cciMT. */
DWORD WINAPI ReadWrite (LPVOID);

#define CACHE_LINE_SIZE 64

__declspec(align(CACHE_LINE_SIZE))
typedef struct TH_ARG_T {
	volatile PBYTE pInFile;
	volatile PBYTE pOutFile;
	volatile LARGE_INTEGER fileSize;
	volatile DWORD threadNum;
} TH_ARG;
DWORD shift;

int _tmain (int argc, LPTSTR argv[])
{
	HANDLE hThr[MAX_OVRLP], hInput, hOutput, hInMap, hOutMap;
	DWORD i;
	TH_ARG thArg[MAX_OVRLP];
    LARGE_INTEGER inputFileSize, outputFileSize;
	LPTSTR pInFile, pOutFile;
	
	if (argc != 4)
		ReportError (_T ("Stosowanie: cciMT przesuniecie plik1 plik2"), 1, FALSE);

	shift = _ttoi(argv[1]);
    /* Okrelanie rozmiaru pliku wejciowego. */
    hInput = CreateFile (argv[2], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
			        FILE_ATTRIBUTE_NORMAL, NULL);
 	if (hInput == INVALID_HANDLE_VALUE) 
		ReportError (_T("Blad krytyczny przy otwieraniu pliku wejsciowego w celu okreslenia jego rozmiaru."), 2, TRUE);
    if (!GetFileSizeEx (hInput, &inputFileSize))
        ReportError (_T("Blad krytyczny przy okreslaniu rozmiaru pliku wejsciowego."), 3, TRUE);
	hInMap = CreateFileMapping (hInput, NULL, PAGE_READONLY, 0, 0, NULL);
	if (hInMap == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane tworzenie odwzorowania pliku wejsciowego."), 4, TRUE);
	/* Odwzorowywanie pliku wejciowego. */
		/* Komentarz: ten kod moe zawie dla duych plikw - zwaszcza w systemach 32-bitowych,
		 * gdzie dostpne s najwyej 3 GB pamici (oczywicie w praktyce duo mniej, a trzeba
		 * odwzorowa dwa pliki). 
		 * Ten program odwzorowuje pliki wejciowy i wyjciowy w caoci.
		 * Mona rozwin program przed odwzorowywanie po jednym bloku, podobnie jak bloki
		 * s uywane w implementacjach opartych na funkcjach ReadFile/WriteFile. Umoliwia
		 * to obsug bardzo duych plikw w systemach 32-bitowych. Pozostawiam to jako
		 * wiczenie. 
		 */
	pInFile = MapViewOfFile (hInMap, FILE_MAP_READ, 0, 0, 0);
	if (pInFile == NULL)
		ReportError(_T ("Nieudane odwzorowywanie pliku wejciowego."), 5, TRUE);

    /* Tworzenie pliku wyjciowego o odpowiednim rozmiarze.  */
    outputFileSize.QuadPart = inputFileSize.QuadPart;
    hOutput = CreateFile (argv[3], GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, 
                            NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
 	if (hOutput == INVALID_HANDLE_VALUE) 
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego w celu okreslenia jego rozmiaru."), 6, TRUE);

	/* Ustawianie rozmiaru pliku wyjciowego nie jest niezbdne, ale wygodne na przykad wtedy,
     * kiedy wolny obszar na dysku jest niewystarczajcy. Wtedy jedna z funkcji wtku moe
     * zawie. */
    if (!SetFilePointerEx (hOutput, outputFileSize, NULL, FILE_BEGIN))
		ReportError (_T ("Blad krytyczny przy ustawianiu wskaznika pliku wyjsciowego."), 9, TRUE);  
    if (!SetEndOfFile (hOutput)) ReportError (_T ("Blad krytyczny przy okreslaniu rozmiaru pliku wyjsciowego."), 10, TRUE);

	/* Tworzenie obiektu odwzorowania dla pliku wejciowego. Naley uy rozmiaru pliku. */
	hOutMap = CreateFileMapping (hOutput, NULL, PAGE_READWRITE, 0, 0, NULL);
	if (hOutMap == INVALID_HANDLE_VALUE)
		ReportError (_T ("Nieudane tworzenie odwzorowania pliku wyjsciowego."), 7, TRUE);
	/* Odwzorowywanie pliku wyjciowego. */
	pOutFile = MapViewOfFile (hOutMap, FILE_MAP_WRITE, 0, 0, (SIZE_T)outputFileSize.QuadPart);
	if (pOutFile == NULL)
		ReportError (_T ("Niepowodzenie przy odwzorowywaniu pliku wyjsciowego."), 8, TRUE);
	CloseHandle (hInMap); CloseHandle (hOutMap); 

    /* Tworzenie wstrzymanych wtkw do przeksztacania (wstrzymanie moe nie by 
	   konieczne, ale warto zachowa ostrono). */
	for (i = 0; i < MAX_OVRLP; i++) {
		thArg[i].threadNum = i;
		thArg[i].pInFile = pInFile;
		thArg[i].pInFile = pInFile;
		thArg[i].pOutFile = pOutFile;
		thArg[i].fileSize.QuadPart = inputFileSize.QuadPart;

		hThr[i] = (HANDLE)_beginthreadex (NULL, 0, ReadWrite, (LPVOID)&thArg[i], CREATE_SUSPENDED, NULL);
		if (hThr[i] == NULL)
			ReportError (_T ("Blad przy tworzeniu watku."), 11, TRUE);
	}
	/* Uruchamianie wszystkich wtkw. */
	for (i = 0; i < MAX_OVRLP; i++) {
		ResumeThread(hThr[i]);
	}
	for (i = 0; i < MAX_OVRLP; i++) {
        WaitForSingleObject (hThr[i], INFINITE);
        CloseHandle (hThr[i]);
	}

	UnmapViewOfFile (pInFile); UnmapViewOfFile (pOutFile);
	CloseHandle (hInput); CloseHandle (hOutput);
	return 0;
}

DWORD WINAPI ReadWrite (LPVOID pArg)
{
    /* Funkcja zwrotna dla puli wtkw do przeksztacania jednego "paska" w pliku.
     * pThArg->ThreadNum to "numer paska" (0, 1, ..., MAX_OVRLP)
     * "Pasek" i suy do przetwarzania rekordw logicznych i, i+MAX_OVRLP, i+2*MAX_OVRLP, ... 
     * RECORD_SIZE okrela rozmiar rekordu logicznego. */

	PBYTE pIn, pOut;
	LARGE_INTEGER curPos, fileSize;
	DWORD iTh;
	size_t nBytes;
	TH_ARG * pThArg;

	pThArg = (TH_ARG *)pArg;

	fileSize.QuadPart = pThArg->fileSize.QuadPart;
	iTh = pThArg->threadNum;

	curPos.QuadPart = (LONGLONG)RECORD_SIZE * iTh;

	while (curPos.QuadPart < fileSize.QuadPart) {
		size_t count = 0;
		/* W pocztkowej wersji znajdowa si gupi bd. 
		   Powd: dwie nastpne instrukcje znajdoway si przed instrukcj while!  */
		pIn  = pThArg->pInFile  + curPos.QuadPart;
		pOut = pThArg->pOutFile + curPos.QuadPart;
		nBytes = (size_t)min(RECORD_SIZE, (fileSize.QuadPart - curPos.QuadPart));

		__try {
			while (count < nBytes) {
				*pOut = (BYTE)((*pIn + shift) % 256);
				pIn++; pOut++; count++;
			}
		}
		__except(GetExceptionCode() == EXCEPTION_IN_PAGE_ERROR ? EXCEPTION_EXECUTE_HANDLER : EXCEPTION_CONTINUE_SEARCH)
		{
			ReportError(_T("Blad krytyczny przy dostepie do odwzorowanego pliku."), 12, TRUE);
		}

		curPos.QuadPart += (LONGLONG)RECORD_SIZE * MAX_OVRLP;
	}
	return 0;
}
