/* Chapter 14. cciMT.
	Przeksztacanie plikw za pomoc uproszczonego szyfru Cezara z wykorzystaniem wielu wtkw.
	Stosowanie wtkw i puli wtkw zamiast operacji nakadanego wejcia-wyjcia. 
	Uzyskany kod jest moim zdaniem prostszy. */

/* cciMT przesuniecie plik1 plik2 */
#include "Everything.h"

#define MAX_OVRLP 4  /* Liczba wtkw roboczych (zwykle najlepiej jest uy liczby procesorw)
                         - wiczenie: dodaj opcj wiersza polece. */
#define RECORD_SIZE 16384  /* Blok ma rozmiar 16K - rozmiar pliku wejciowego to
                            * wielokrotno wartoci MAX_OVRLP * RECORD_SIZE.
                            * 16K to optymalna warto wedug prostych testw.
                            * Mona doda opcj wiersza polece. Zobacz komentarze w pliku cciMT.                            
                            * You may want to add a command line option. */
DWORD WINAPI ReadWrite (LPVOID);
typedef struct TH_ARG_T {
	volatile HANDLE hIn;
	volatile HANDLE hOut;
	volatile DWORD threadNum;
	volatile LARGE_INTEGER fileSize;
} TH_ARG;
DWORD shift;

/**** ZADANIE: usprawnij zamykanie uchwytu pliku, jeli operacja w wtku zawiedzie.
      Pomocne moe by uycie funkcji ReportException zamiast ReportError.   ****/

int _tmain (int argc, LPTSTR argv[])
{
	HANDLE hThr[MAX_OVRLP], hSize;
	DWORD i, thId;
	TH_ARG thArg[MAX_OVRLP];
    LARGE_INTEGER inputFileSize, outputFileSize;

	if (argc != 4)
		ReportError (_T ("Stosowanie: cciMT przesuniecie plik1 plik2"), 1, FALSE);

	shift = _ttoi(argv[1]);
    /* Okrelanie rozmiaru pliku wejciowego. */
    hSize = CreateFile (argv[2], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING,
			        FILE_ATTRIBUTE_NORMAL, NULL);
 	if (hSize == INVALID_HANDLE_VALUE) 
		ReportError (_T("Blad krytyczny przy otwieraniu pliku wejsciowego w celu okreslenia jego rozmiaru."), 2, TRUE);
	if (!GetFileSizeEx (hSize, &inputFileSize)) {
		CloseHandle(hSize);
        ReportError (_T("Blad krytyczny przy okreslaniu rozmiaru pliku wejsciowego."), 2, TRUE);
	}
    CloseHandle (hSize);

    /* Tworzenie pliku wyjciowego o odpowiednim rozmiarze.
     * UWAGA: najatwiej jest tworzy plik wyjciowy przed uruchomieniem funkcji wtkw.
     * Jeli nie tworzysz pliku w tym miejscu, koniecznie uyj opcji OPEN_ALWAYS w funkcjach wtkw. */
    outputFileSize.QuadPart = inputFileSize.QuadPart;
    hSize = CreateFile (argv[3], GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, 
                            NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hSize == INVALID_HANDLE_VALUE)
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego w celu okreslenia jego rozmiaru."), 2, TRUE);
    /* Ustawianie rozmiaru pliku wyjciowego nie jest niezbdne, ale wygodne na przykad wtedy,
     * kiedy wolny obszar na dysku jest niewystarczajcy. Wtedy jedna z funkcji wtku moe
     * zawie. */
    if (!SetFilePointerEx (hSize, outputFileSize, NULL, FILE_BEGIN) ||
		!SetEndOfFile (hSize)) {
			CloseHandle(hSize);
			ReportError (_T ("Blad krytyczny przy okreslaniu rozmiaru pliku wyjsciowego."), 2, TRUE);
	}
    CloseHandle (hSize);

    /* Tworzenie wszystkich wtkw do przeksztacania plikw. */
	for (i = 0; i < MAX_OVRLP; i++) {
		thArg[i].threadNum = i;
		thArg[i].hIn = CreateFile (argv[2], GENERIC_READ,
			FILE_SHARE_READ, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL, NULL);
 		if (thArg[i].hIn == INVALID_HANDLE_VALUE) 
			ReportError (_T ("Blad krytyczny przy otwieraniu pliku wejsciowego."), 2, TRUE);
    	thArg[i].fileSize.LowPart = inputFileSize.LowPart;
		thArg[i].fileSize.HighPart = inputFileSize.HighPart;
		thArg[i].hOut = CreateFile (argv[3], GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL /*| FILE_FLAG_NO_BUFFERING | FILE_FLAG_WRITE_THROUGH*/, NULL);
		/* Uwaga: NIE NALEY UYWA FLAG Z KOMENTARZA, PONIEWA WYMAGAJ ONE, ABY DUGO BUFORA 
			BYA WIELOKROTNOCI ROZMIARU SEKTORA. */
		if (thArg[i].hOut == INVALID_HANDLE_VALUE) {
			CloseHandle(thArg[i].hIn); /**** ZADANIE: usprawnij zarzdzanie uchwytami, aby 
			                                 unikn wyciekania zasobw. ****/
			ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego."), 3, TRUE);
		}

		hThr[i] = (HANDLE) _beginthreadex (NULL, 0, ReadWrite, (LPVOID)&thArg[i], 0, &thId);
		if (hThr[i] == NULL) {
			CloseHandle(thArg[i].hIn); CloseHandle(thArg[i].hOut);
			ReportError (_T ("Blad tworzenia watku."), 6, TRUE);
		}
	}

	for (i = 0; i < MAX_OVRLP; i++) {
        WaitForSingleObject (hThr[i], INFINITE);
        CloseHandle (hThr[i]);
        FlushFileBuffers (thArg[i].hOut); 
		CloseHandle (thArg[i].hOut); 
		CloseHandle (thArg[i].hIn);
	}
	return 0;
}

DWORD WINAPI ReadWrite (LPVOID pArg)
{
    /* Funkcja zwrotna dla puli wtkw do przeksztacania jednego "paska" w pliku.
     * pThArg->ThreadNum to "numer paska" (0, 1, ..., MAX_OVRLP)
     * "Pasek" i suy do przetwarzania rekordw logicznych i, i+MAX_OVRLP, i+2*MAX_OVRLP, ... 
     * RECORD_SIZE okrela rozmiar rekordu logicznego. */

  	CHAR buffer[RECORD_SIZE];
	LARGE_INTEGER curPosIn, curPosOut;
	DWORD i, nRead = 1, nWrite, iTh;
	HANDLE hIn, hOut;
	TH_ARG * pThArg;
	OVERLAPPED ovRead = {0, 0, 0, 0, NULL}, ovWrite = {0, 0, 0, 0, NULL};

	pThArg = (TH_ARG *)pArg;

	iTh = pThArg->threadNum;
	hIn = pThArg->hIn; hOut = pThArg->hOut;

	curPosIn.QuadPart = curPosOut.QuadPart = (LONGLONG) RECORD_SIZE * iTh;
	while (curPosIn.QuadPart < pThArg->fileSize.QuadPart) {
		ovRead.Offset      = curPosIn.LowPart;
		ovRead.OffsetHigh  = curPosIn.HighPart;
		ovWrite.Offset     = curPosOut.LowPart;
		ovWrite.OffsetHigh = curPosOut.HighPart;
		
		if (!ReadFile (hIn, buffer, RECORD_SIZE, &nRead, &ovRead)) 
            ReportError (_T("Blad odczytu pliku wejsciowego."), 8, TRUE);
		for (i = 0; i < nRead; i++)
			buffer[i] = (buffer[i] + shift) % 256;
		
		if (!WriteFile (hOut, buffer, nRead, &nWrite, &ovWrite) || nWrite != nRead)
			ReportError (_T("Blad zapisu pliku wejsciowego."), 9, TRUE);
        
        curPosIn.QuadPart += (LONGLONG) RECORD_SIZE * MAX_OVRLP;
		curPosOut.QuadPart += (LONGLONG) RECORD_SIZE * MAX_OVRLP;
	}

	return 0;
}
