/* Rozdzia 14. cciEX.   
		WZBOGACONE przeksztacanie za pomoc uproszczonego szyfru Cezara. */
/*	cciEX plik1 plik2  */
/* Ten program ilustruje wzbogacone (czyli asynchroniczne z obsug alertw
   lub procedurami zakoczenia) operacje wejcia-wyjcia.
   Opracowano go przez zmian struktury programu cciOV. */
/* Typ DWORD_PTR suy do tworzenia liczb cakowitych 
 * przeksztacanych na uchwyty
 * (w polu hEvent struktury OVERLAPPED).
 * Eliminuje to ostrzeenia w systemach Win64 dotyczce konwersji midzy
 * danymi 32- i 64-bitowymi, poniewa typ HANDLE w systemach Win64 ma 64 bity.
 * Technika ta jest stosowana tylko przy zdefiniowanej nazwie _Wp64.
 */
#include "Everything.h"

#define MAX_OVRLP 4		/* Daje najlepsze wyniki w systemach czteroprocesorowych, cho wartoci 2 i 8 
                           dziaaj prawie tak samo dobrze. Sugeruj stosowanie liczby procesorw. */
#define REC_SIZE 16384 /* Najlepsza warto wedug kilku testw, jednak rozmiar bloku nie jest tu tak
                          wany jak w programie cciOV (zobacz komentarze z pliku cciOV.c). */

static VOID WINAPI ReadDone (DWORD, DWORD, LPOVERLAPPED);
static VOID WINAPI WriteDone (DWORD, DWORD, LPOVERLAPPED);

/* Pierwsza struktura OVERLAPPED suy do odczytu,
   a druga  do zapisu. Dla kadej zalegej operacji 
   udostpniane s struktury i bufory. */

OVERLAPPED overLapIn[MAX_OVRLP], overLapOut[MAX_OVRLP];
CHAR rawRec[MAX_OVRLP][REC_SIZE], cciRec[MAX_OVRLP][REC_SIZE];
HANDLE hInputFile, hOutputFile;
LONGLONG nRecords, nDone;
LARGE_INTEGER fileSize;
DWORD shift;

int _tmain (int argc, LPTSTR argv[])
{
	DWORD ic;
	LARGE_INTEGER curPosIn;

	if (argc != 4)
		ReportError (_T ("Stosowanie: cciEX przesuniecie plik1 plik2"), 1, FALSE);

	shift = _ttoi(argv[1]);
	hInputFile = CreateFile (argv[2], GENERIC_READ,
			0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (hInputFile == INVALID_HANDLE_VALUE) 
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wejsciowego."), 2, TRUE);
	
	hOutputFile = CreateFile (argv[3], GENERIC_WRITE,
			0, NULL, CREATE_ALWAYS, FILE_FLAG_OVERLAPPED, NULL);
	if (hOutputFile == INVALID_HANDLE_VALUE) {
		CloseHandle(hInputFile);
		ReportError (_T ("Blad krytyczny przy otwieraniu pliku wyjsciowego."), 3, TRUE);
	}

	/* Okrelanie cznej liczby rekordw do przetworzenia.
       Na kocu nie moe znajdowa si niepeny rekord. */
	if (!GetFileSizeEx (hInputFile, &fileSize)) {
		CloseHandle(hInputFile); CloseHandle(hOutputFile);
		ReportError (_T("Blad krytyczny przy pobieraniu rozmiaru pliku wejsciowego."), 4, TRUE);
	}
	nRecords = (fileSize.QuadPart + REC_SIZE - 1) / REC_SIZE;

	/* Inicjowanie odczytu w buforze powizanym ze struktur OVERLAPPED. */
	curPosIn.QuadPart = 0;
	for (ic = 0; ic < MAX_OVRLP; ic++) {
		overLapIn[ic].hEvent = (HANDLE)ic;	/* Zmiana przeznaczenia pola na zdarzenie - */
		overLapOut[ic].hEvent = (HANDLE)ic;	/* tu przechowuje ono numer zdarzenia. */

						/* Ustawianie pozycji w pliku. */
		overLapIn[ic].Offset = curPosIn.LowPart;
		overLapIn[ic].OffsetHigh = curPosIn.HighPart;
		if (curPosIn.QuadPart < fileSize.QuadPart)
			ReadFileEx (hInputFile, rawRec[ic], REC_SIZE,
					&overLapIn[ic], ReadDone);
		curPosIn.QuadPart += (LONGLONG) REC_SIZE;
	}

	/*  Wszystkie operacje odczytu dziaaj. Program wchodzi w stan oczekiwania z obsug
       alertw i kontynuuje dziaanie do czasu przetworzenia wszystkich rekordw. */
	nDone = 0;
	while (nDone < 2* nRecords) {
		SleepEx (0, TRUE);
	}
	
	CloseHandle (hInputFile);
	CloseHandle (hOutputFile);
	return 0;
}

static VOID WINAPI ReadDone (DWORD Code, DWORD nBytes, LPOVERLAPPED pOv)
{
	LARGE_INTEGER curPosIn, curPosOut;
	DWORD ic, i;

	nDone++;
	/* Przetwarzanie rekordu i inicjowanie zapisu. */
    /* Pobieranie identyfikatora struktury OVERLAPPED z pola zdarzenia. */
	ic = PtrToInt(pOv->hEvent);
	curPosIn.LowPart = overLapIn[ic].Offset;
	curPosIn.HighPart = overLapIn[ic].OffsetHigh;
	curPosOut.QuadPart = (curPosIn.QuadPart / REC_SIZE) * REC_SIZE;
	overLapOut[ic].Offset = curPosOut.LowPart;
	overLapOut[ic].OffsetHigh = curPosOut.HighPart;
	/* Szyfrowanie znakw i zapis rekordu. */
	for (i = 0; i < nBytes; i++)
		cciRec[ic][i] = (BYTE)((rawRec[ic][i] + shift) % 256);
	WriteFileEx (hOutputFile, cciRec[ic], nBytes,
		&overLapOut[ic], WriteDone);

	/* Przygotowanie wejciowej struktury OVERLAPPED do
       nastpnego odczytu. Jest on inicjowany po 
       zakoczeniu rozpocztego wczeniej zapisu. */
	curPosIn.QuadPart += REC_SIZE * (LONGLONG) (MAX_OVRLP);
	overLapIn[ic].Offset = curPosIn.LowPart;
	overLapIn[ic].OffsetHigh = curPosIn.HighPart;

	return;
}

static VOID WINAPI WriteDone (DWORD Code, DWORD nBytes, LPOVERLAPPED pOv)
{
	LARGE_INTEGER curPosIn;
	DWORD ic;

	nDone++;
	/* Pobieranie identyfikatora struktury OVERLAPPED z pola zdarzenia. */
	ic = PtrToInt(pOv->hEvent);

	/* Rozpoczynanie odczytu. Pozycja w pliku zostaa ju ustawiona w wejciowej 
       strukturze OVERLAPPED. Najpierw trzeba jednak przeprowadzi test,
       aby unikn odczytu spoza koca pliku. */

	curPosIn.LowPart = overLapIn[ic].Offset;
	curPosIn.HighPart = overLapIn[ic].OffsetHigh;
	if (curPosIn.QuadPart < fileSize.QuadPart) {
		/* Rozpoczynanie nowego odczytu. */
		ReadFileEx (hInputFile, rawRec[ic], REC_SIZE,
				&overLapIn[ic], ReadDone);
	}
	return;
}
