/* Rozdzia 14. TimeBeep_TPT.c. Okresowy alarm. */
/* Stosowanie: TimeBeep_TPT odstp (w milisekundach). */
/* W tej implementacji wykorzystano "zegary z pul wtkw" wprowadzone
   w systemach NT 6.0. 
   W programie procedura sterujca konsoli przechwytuje 
   sterujce zgoszenia z jzyka C (zobacz kocow cz rozdziau 7.).  */

#include "Everything.h"

static BOOL WINAPI Handler (DWORD CntrlEvent);
static VOID CALLBACK Beeper (PTP_CALLBACK_INSTANCE, PVOID, PTP_TIMER);
volatile static BOOL exitFlag = FALSE;
volatile static int count = 0;
volatile static PTP_TIMER pTimerPool;

HANDLE hTimer;

int _tmain (int argc, LPTSTR argv [])
{
    DWORD period;
    FILETIME dueTime;
    LARGE_INTEGER lDueTime;
    TP_CALLBACK_ENVIRON cbe;  // rodowisko funkcji zwrotnej.

    if (!WindowsVersionOK (6, 0)) 
        ReportError (_T("Ten program wymaga systemu Windows NT 6.0 lub nowszego."), 1, FALSE);

    if (argc >= 2)
        period = _ttoi (argv [1]) * 1000;
    else ReportError (_T ("Stosowanie: TimeBeep_TPT odstep (w milisekundach)"), 1, FALSE);

    if (!SetConsoleCtrlHandler (Handler, TRUE))
        ReportError (_T ("Blad ustawiania procedury obslugi zdarzenia."), 2, TRUE);

    InitializeThreadpoolEnvironment (&cbe);
    pTimerPool = CreateThreadpoolTimer (Beeper, "Zegar z pula watkow.", &cbe);
    if (NULL == pTimerPool)
        ReportError (_T("Blad funkcji CreateThreadpoolWork."), 2, TRUE);

    /* Czas pierwszego zgoszenia wzgldem obecnego czasu jest podawany 
          jako liczba ujemna. Odstp jest podawany w milisekundach (10-3 sekundy), 
          natomiast czas pierwszego zgoszenia  w jednostkach 100 nanosekundowych (10-7 sekundy), 
          aby zachowa spjno z typem FILETIME. */
    lDueTime.QuadPart = -(LONGLONG)period * 10000;
    dueTime.dwLowDateTime = lDueTime.LowPart;
    dueTime.dwHighDateTime = lDueTime.HighPart;
    SetThreadpoolTimer (pTimerPool, &dueTime, period, 0);

    /*    Wejcie do gwnej ptli - sprawdzanie flagi exitFlag co 5 sekund i wywietlanie
          aktualnej wartoci zmiennej count. */
    while (!exitFlag) {
        _tprintf (_T("count = %d\n"), count); 
        /* Warto zmiennej count jest zwikszana przy kadym wywoaniu procedury zegara. */
        Sleep (5000);
    }

    _tprintf (_T("Zamykanie. count = %d"), count);
    return 0;
}    

static VOID CALLBACK Beeper (PTP_CALLBACK_INSTANCE Instance, PVOID Context, PTP_TIMER Timer)
{
    int currentCount = InterlockedIncrement(&count);

    _tprintf (_T("Przed wydaniem sygnalu numer: %d\n"), currentCount);
    Beep (1000 /* Czstotliwo. */, 250 /* Czas trwania w milisekundach. */);
    return;
}

BOOL WINAPI Handler (DWORD CntrlEvent)
{
    exitFlag = TRUE;
    CloseThreadpoolTimer(pTimerPool);
    _tprintf (_T("Zamykanie.\n"));

    return TRUE;
}
