/* Rozdzia 14. TimeBeep.c. Okresowy alarm. */
/* Stosowanie: TimeBeep odstp (w milisekundach). */
/* W tej implementacji uyto obiektw jdra - zegarw oczekujcych.
   W programie procedura sterujca konsoli przechwytuje 
   sterujce zgoszenia z jzyka C (zobacz kocow cz rozdziau 7.).  */

#include "Everything.h"

static BOOL WINAPI Handler (DWORD CntrlEvent);
static VOID APIENTRY Beeper (LPVOID, DWORD, DWORD);
volatile static int exitFlag = 0;

HANDLE hTimer;

int _tmain (int argc, LPTSTR argv [])
{
	DWORD count = 0, period;
	LARGE_INTEGER dueTime;

	if (!WindowsVersionOK (5, 0)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 5.0 lub nowszego."), 1, FALSE);

	if (argc >= 2) period = _ttoi (argv [1]) * 1000;
	else ReportError (_T ("Stosowanie: TimeBeep odstep (w milisekundach)"), 1, FALSE);

	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T ("Blad ustawiania procedury obslugi zdarzenia."), 2, TRUE);

	dueTime.QuadPart = -(LONGLONG)period * 10000;
			/*  Czas pierwszego zgoszenia wzgldem obecnego czasu jest podawany 
          jako liczba ujemna. Odstp jest podawany w milisekundach (10-3 sekundy), 
          natomiast czas pierwszego zgoszenia  w jednostkach 100 nanosekundowych (10-7 sekundy), 
          aby zachowa spjno z typem FILETIME. */

	hTimer = CreateWaitableTimer (NULL /* Atrybuty zabezpiecze.  */,
		FALSE /*TRUE*/,	/*  Zegar synchronizacji, a nie zegar
                         z rcznym zerowaniem (zegar powiadomie). */
		NULL		/*  Nie naley nazywa tego zegara - przestrze nazw jest wsplna ze
						zdarzeniami, muteksami, semaforami i obiektami odwzorowanymi w pamici. */);
	
	if (hTimer == NULL) 
		ReportError (_T ("Nieudane tworzenie zegara oczekujacego."), 3, TRUE);
	if (!SetWaitableTimer (hTimer, 
			&dueTime /* Wzgldny czas pierwszego zgoszenia. Warto dodatnia
                       oznacza czas bezwzgldny. */,
			period  /* Odstp w milisekundach. */,
			Beeper  /* Funkcja zegara. */,
			&count  /* Parametr przekazywany do funkcji zegara. */,
			FALSE    /* Nie ma zastosowania w tym miejscu - nie naley go uywa. */))
		ReportError (_T ("Nieudane ustawianie zegara oczekujacego."), 4, TRUE);

	/*	Wejcie do gwnej ptli. */
	while (!exitFlag) {
		_tprintf (_T("count = %d\n"), count); 
		/* Zmienna count jest zwikszana w procedurze zegara. */
        /* Wchodzenie w stan oczekiwania z obsug alertw, co umoliwia uruchomienie
           procedury zegara. Uchwyt zegar to obiekt synchronizacji, dlatego 
           mona te na niego oczekiwa. */
		SleepEx (INFINITE, TRUE);
		/* lub WaitForSingleObjectEx (hTimer, INFINITE); Beeper(...);  */
	}

	_tprintf (_T("Zamykanie. count = %d"), count);
	CancelWaitableTimer (hTimer);
	CloseHandle (hTimer);
	return 0;
}	

/*	Funkcja zwrotna zegara oczekujcego. */
static VOID APIENTRY Beeper (LPVOID lpCount,
   DWORD dwTimerLowValue, DWORD dwTimerHighValue)
{

	*(LPDWORD)lpCount = *(LPDWORD)lpCount + 1;

	_tprintf (_T("Przed wydaniem sygnalu numer: %d\n"), *(LPDWORD)lpCount);
	Beep (1000 /* Czstotliwo. */, 250 /* Czas trwania w milisekundach. */);
	return;
}

BOOL WINAPI Handler (DWORD CntrlEvent)
{
	InterlockedIncrement(&exitFlag);
	_tprintf (_T("Zamykanie.\n"));

	return TRUE;
}
