/* Rozdzia 14. serviceSK.c.
	Program serverSK (rozdzia 12.) przeksztacony na usug systemu Windows. */
/* Wielowtkowa aplikacja konsolowa. */
/*	Stosowanie: simpleService [-c]								*/
/*			-c powoduje uruchomienie programu jako aplikacji konsolowej, 
               a nie jako usugi.	*/						 
/*  Gwna procedura uruchamia program rozdzielajcy do sterowania usug. */
/*	Cay kod na pocztku to "nakadka na usug" 
	(taka sama, jak w programie SimpleService.c). */
#include "Everything.h"
#include "ClientServer.h"
#define UPDATE_TIME 1000	/* Sekunda midzy aktualizacjami. */

VOID FileLogEvent (LPCTSTR, DWORD, BOOL); 
void WINAPI ServiceMain (DWORD argc, LPTSTR argv[]);
VOID WINAPI ServerCtrlHandler(DWORD);
void UpdateStatus (int, int);
int  ServiceSpecific (int, LPTSTR *);

static FILE *hLogFile; /* Tekstowy plik dziennika. */
static SERVICE_STATUS hServStatus;
static SERVICE_STATUS_HANDLE hSStat; /* Uchwyt do ustawiania stanu usugi. */
volatile static ShutFlag = FALSE;
									 
static LPTSTR ServiceName = _T("serviceSK");
static LPTSTR LogFileName = "serviceSKLog.txt";
static BOOL consoleApp = FALSE, isService;

VOID _tmain (int argc, LPTSTR argv [])
{
	SERVICE_TABLE_ENTRY DispatchTable[] =
	{
		{ ServiceName,				ServiceMain	},
		{ NULL,						NULL }
	};

	Options (argc, argv, _T ("c"), &consoleApp, NULL);
	isService = !consoleApp;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	if (isService) {
	if (!StartServiceCtrlDispatcher (DispatchTable))
        ReportError (_T("Nieudane wywolanie funkcji StartServiceCtrlDispatcher."), 1, FALSE);
	} else {
		ServiceSpecific (argc, argv);
	}
	return;
}


/*	Punkt wejcia w postaci funkcji ServiceMain wywoywanej, kiedy usuga jest
	tworzona przez program gwny.  */
void WINAPI ServiceMain (DWORD argc, LPTSTR argv[])
{
	DWORD i;

	/*  Ustawia biecy katalog i otwiera plik dziennika (dane
        s dodawane do istniejcego pliku).	*/
	if (argc > 2) SetCurrentDirectory (argv[2]);
	hLogFile = fopen (LogFileName, _T("w+"));
	if (hLogFile == NULL) return ;

	FileLogEvent (_T("Uruchamianie uslugi. Pierwszy wpis."), 0, FALSE);
	_ftprintf (hLogFile, _T("\nargc = %d"), argc);
	for (i = 0; i < argc; i++) 
		_ftprintf (hLogFile, _T("\nargv[%d] = %s"), i, argv[i]);
	FileLogEvent (_T("Wejscie do procedury ServiceMain."), 0, FALSE);

	hServStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	hServStatus.dwCurrentState = SERVICE_START_PENDING;
	hServStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP | 
		SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_PAUSE_CONTINUE;
	hServStatus.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
	hServStatus.dwServiceSpecificExitCode = 0;
	hServStatus.dwCheckPoint = 0;
	hServStatus.dwWaitHint = 2*UPDATE_TIME;

	hSStat = RegisterServiceCtrlHandler( ServiceName, ServerCtrlHandler);
	if (hSStat == 0) 
		FileLogEvent (_T("Nie mozna zarejestrowac procedury sterujacej."), 100, TRUE);

	FileLogEvent (_T("Udane zarejestrowanie procedury sterujacej."), 0, FALSE);
	SetServiceStatus (hSStat, &hServStatus);
	FileLogEvent (_T("Stan uslugi ustawiono na SERVICE_START_PENDING."), 0, FALSE);

	/*  Po ukoczeniu oglnych zada mona rozpocz operacje 
	    specyficzne dla usugi. */
	if (ServiceSpecific (argc, argv) != 0) {
		hServStatus.dwCurrentState = SERVICE_STOPPED;
		hServStatus.dwServiceSpecificExitCode = 1;  /* Nieudane inicjowanie serwera. */
		SetServiceStatus (hSStat, &hServStatus);
		return;
	}
	FileLogEvent (_T("Zamykanie watkow uslugi. Ustawianie stanu na SERVICE_STOPPED."), 0, FALSE);
	/*  Sterowanie jest zwracane do tego miejsca dopiero po zakoczeniu 
       dziaania funkcji ServiceSpecific, co oznacza zamknicie systemu. */
	UpdateStatus (SERVICE_STOPPED, 0);
	FileLogEvent (_T("Ustawianie stanu na SERVICE_STOPPED."), 0, FALSE);
	fclose (hLogFile);  /*  Operacja porzdkujca. */
	return;

}


/*	Procedura sterujca. */
VOID WINAPI ServerCtrlHandler( DWORD Control)
 // Wymaga kodu sterujcego.
{
	switch (Control) {
	case SERVICE_CONTROL_SHUTDOWN:
	case SERVICE_CONTROL_STOP:
		ShutFlag = TRUE;	/* Ustawianie flagi globalnej shutDown. */
		UpdateStatus (SERVICE_STOP_PENDING, -1);
		break;
	case SERVICE_CONTROL_PAUSE:
		break;
	case SERVICE_CONTROL_CONTINUE:
		break;
	case SERVICE_CONTROL_INTERROGATE:
		break;
	default:
		if (Control > 127 && Control < 256) /* Zdefiniowane przez uytkownika. */
		break;
	}
	UpdateStatus (-1, -1);
	return;
}

void UpdateStatus (int NewStatus, int Check)
/*  Ustawianie stanu usugi i punktu kontrolnego (na okrelon warto lub przez zwikszenie). */
{
	if (Check < 0 ) hServStatus.dwCheckPoint++;
	else			hServStatus.dwCheckPoint = Check;
	if (NewStatus >= 0) hServStatus.dwCurrentState = NewStatus;
	if (!SetServiceStatus (hSStat, &hServStatus))
		FileLogEvent (_T("Nie mozna ustawic stanu."), 101, TRUE);
	return;
}

/*	Funkcja FileLogEvent jest podobna do uywanej w innych miejscach funkcji ReportError.
	Jednak w przypadku bdy s zgaszane, a nie zapisywane do standardowego urzdzenia
	bdw. Ostatecznie funkcj t naley umieci w bibliotece funkcji 
	narzdziowych.  */

VOID FileLogEvent (LPCTSTR UserMessage, DWORD EventCode, BOOL PrintErrorMsg)

/*  Funkcja oglnego uytku do zgaszania bdw systemowych.
	Naley pobra numer bdu i przeksztaci go na komunikat o bdzie systemowym.
	Naley zapisa t informacj i okrelony przez uytkownika komunikat w otwartym pliku dziennika.
	UserMessage:		komunikat wywietlany w standardowym urzdzeniu bdw.
	EventCode:			
	PrintErrorMessage:	jeli ta flaga jest ustawiona, naley wywietli komunikat o 
                        ostatnim bdzie systemowym. */
{
	DWORD eMsgLen, ErrNum = GetLastError ();
	LPTSTR lpvSysMsg;
	TCHAR MessageBuffer[512];
	/*  Jeli si to nie powiedzie, nie mona zbyt wiele zrobi 
	    oprcz ponawiania prb. */

	if (PrintErrorMsg) {
		eMsgLen = FormatMessage (FORMAT_MESSAGE_ALLOCATE_BUFFER |
			FORMAT_MESSAGE_FROM_SYSTEM, NULL,
			ErrNum, MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT),
			(LPTSTR)&lpvSysMsg, 0, NULL);

		_stprintf (MessageBuffer, _T("\n%s %s ErrNum = %d. EventCode = %d."),
			UserMessage, lpvSysMsg, ErrNum, EventCode);
		if (lpvSysMsg != NULL) LocalFree (lpvSysMsg);
				/* Wyjanione w rozdziale 5. */
	} else {
		_stprintf (MessageBuffer, _T("\n%s EventCode = %d."),
			UserMessage, EventCode);
	}

	fputs (MessageBuffer, hLogFile);
	return;
}


/*	Jest to specyficzna dla usugi funkcja gwna wywoywana
	w oglniejszej funkcji ServiceMain.
	Wywouje zmodyfikawan wersj serwera serverSK z
	rozdziau 12.
	Oglnie mona uy odrbnego pliku rdowego, a nawet
	umieci ten kod w bibliotece DLL.  */

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* Rozdzia 12. System klient-serwer. SERWER  WERSJA OPARTA NA GNIAZDACH. */
/* PRZEKSZTACONY W USUG. */
/* Wykonuje polecenie z dania i zwraca odpowied. */
/* Polecenia s wykonywane w ramach procesu, jeli mona zlokalizowa punkt wejcia */
/* wsplnej biblioteki; w przeciwnym razie s uruchamiane poza procesem. */
/* DODATKOWY MECHANIZM: parametr argv [1] moe by nazw biblioteki DLL do */
/* obsugi serwerw wewntrzprocesowych. */

struct sockaddr_in SrvSAddr;		/* Server's Socket address structure */
struct sockaddr_in ConnectSAddr;	/* Connected socket with client details   */
WSADATA WSStartData;				/* Socket library data structure   */

typedef struct SERVER_ARG_TAG { /* Argumenty wtku serwera. */
	volatile DWORD	number;
	volatile SOCKET	sock;
	volatile DWORD	status; /* 0: nie istnieje, 1: zatrzymana, 2: dziaa, 
				3: naley zatrzyma cay system */
	volatile HANDLE srv_thd;
	HINSTANCE	 dlhandle; /* Uchwyt wsplnej biblioteki. */
} SERVER_ARG;

static BOOL ReceiveRequestMessage (REQUEST *pRequest, SOCKET);
static BOOL SendResponseMessage (RESPONSE *pResponse, SOCKET);
static DWORD WINAPI Server (SERVER_ARG *);
static DWORD WINAPI AcceptTh (SERVER_ARG *);
static DWORD WINAPI CheckpointTh (SERVER_ARG *);

static HANDLE srv_thd[MAX_CLIENTS];
static SOCKET SrvSock = INVALID_SOCKET, ConnectSock = INVALID_SOCKET;

int ServiceSpecific (int argc, LPTSTR argv[])
/* int _tmain (int argc, LPCTSTR argv []) */
{
	/* Tu naley umieci kod rdowy serwera serverSK. */
   return 0;
}