/* Rozdzia 13. SimpleService.c.
   Najprostszy przykad usugi systemu Windows.
   Jej jedyne moliwoci to aktualizowanie punktw kontrolnych 
   i akceptowanie podstawowych polece sterujcych.
   Program mona te uruchomi jako niezalen aplikacj. */

#include "Everything.h"
#include <time.h>
#define UPDATE_TIME 1000	/* Sekunda odstpu midzy aktualizacjami. */

VOID LogEvent (LPCTSTR, WORD), LogClose();
BOOL LogInit(LPTSTR);
void WINAPI ServiceMain (DWORD argc, LPTSTR argv[]);
VOID WINAPI ServerCtrlHandler(DWORD);
void UpdateStatus (int, int);
int  ServiceSpecific (int, LPTSTR *);

static BOOL shutDown = FALSE, pauseFlag = FALSE;
static SERVICE_STATUS hServStatus;
static SERVICE_STATUS_HANDLE hSStat; /* Uchwyt do ustawiania stanu. */
									 
static LPTSTR serviceName = _T("SimpleService");
static LPTSTR logFileName = _T(".\\LogFiles\\SimpleServiceLog.txt");
static BOOL consoleApp = FALSE, isService;
									 
/*  Gwna procedura uruchamiajca program rozdzielajcy do sterowania usug. */
/* Program mona te uruchomi jako niezalen aplikacj konsolow. */
/* Stosowanie: simpleService [-c] */
/*          Opcja -c powoduje uruchomienie aplikacji konsolowej zamiast usugi.	*/

VOID _tmain (int argc, LPTSTR argv[])
{
	SERVICE_TABLE_ENTRY DispatchTable[] =
	{
		{ serviceName,				ServiceMain	},
		{ NULL,						NULL }
	};
	
	Options (argc, argv, _T ("c"), &consoleApp, NULL);
	isService = !consoleApp;
	/* Inicjowanie pliku dziennika. */
	if (!LogInit (logFileName)) return;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	if (isService) {
		LogEvent(_T("Uruchamianie programu rozdzielajacego."), EVENTLOG_SUCCESS);
		StartServiceCtrlDispatcher (DispatchTable);
	} else {
		LogEvent(_T("Uruchamianie aplikacji."), EVENTLOG_SUCCESS);
		ServiceSpecific (argc, argv);
	}

	LogClose();
	return;
}

/*	Punkt wejcia w postaci funkcji ServiceMain wywoywanej przez program gwny.  */
void WINAPI ServiceMain (DWORD argc, LPTSTR argv[])
{
	LogEvent (_T("Wchodzenie do funkcji ServiceMain."), EVENTLOG_SUCCESS);

	hServStatus.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	hServStatus.dwCurrentState = SERVICE_START_PENDING;
	hServStatus.dwControlsAccepted = SERVICE_ACCEPT_STOP | 
		SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_PAUSE_CONTINUE;
	hServStatus.dwWin32ExitCode = NO_ERROR;
	hServStatus.dwServiceSpecificExitCode = 0;
	hServStatus.dwCheckPoint = 0;
	hServStatus.dwWaitHint = 2 * UPDATE_TIME;

	hSStat = RegisterServiceCtrlHandler( serviceName, ServerCtrlHandler);

	if (hSStat == 0) {
		LogEvent (_T("Nie mozna zarejestrowac procedury obslugi."), EVENTLOG_ERROR_TYPE);
		hServStatus.dwCurrentState = SERVICE_STOPPED;
		hServStatus.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
		hServStatus.dwServiceSpecificExitCode = 1;
		UpdateStatus (SERVICE_STOPPED, -1);
		return;
	}

	LogEvent (_T("Zarejestrowano procedure sterujaca."), EVENTLOG_SUCCESS);
	SetServiceStatus (hSStat, &hServStatus);
	LogEvent (_T("Stan SERVICE_START_PENDING."), EVENTLOG_SUCCESS);

	/*  Uruchamianie zada specyficznych dla usugi. Oglne operacje zostay wykonane. */
	if (ServiceSpecific (argc, argv) != 0) {
		/* Lepiej: ustawi dwCurrentState na SERVICE_STOP_PENDING; zamkn serwer,
		 * nastpnie ustawi dwCurrentState = SERVICE_STOPPED i zwrci sterowanie. */
		hServStatus.dwCurrentState = SERVICE_STOPPED;
		hServStatus.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
		hServStatus.dwServiceSpecificExitCode = 1;  /* Nieudane inicjowanie serwera. */
		SetServiceStatus (hSStat, &hServStatus);
		return;
	}
	LogEvent (_T("Watki uslugi zakonczyly prace."), EVENTLOG_SUCCESS);
	LogEvent (_T("Ustawianie stanu na SERVICE_STOPPED."), EVENTLOG_SUCCESS);
	/*  Sterowanie jest zwracane do tego miejsca dopiero po zakoczeniu 
       dziaania funkcji ServiceSpecific, co oznacza zamknicie systemu. */
	UpdateStatus (SERVICE_STOPPED, 0);
	LogEvent (_T("Stan ustawiono na SERVICE_STOPPED."), EVENTLOG_SUCCESS);
	return;
}

/*	Jest to funkcja specyficzna dla usugi (gwna) wywoywana
	w oglniejszej funkcji ServiceMain.
	Oglnie mona zacz od serwera, na przykad serwera ServerSK.c
	z rozdziau 12., zmieni nazw "_tmain" na "ServiceSpecific" i
	umieci kod w tym miejscu. */

int ServiceSpecific (int argc, LPTSTR argv[])
{	
	UpdateStatus (-1, -1); /* Zmiana stanu i ustawienie nastpnego punktu kontrolnego. */
	/* Serwer mona uruchomi jako wtek lub proces. */
    /* Zamy, e usuga rozpoczyna prac w dwie sekundy. */
	UpdateStatus (SERVICE_RUNNING, -1);
	LogEvent (_T("Aktualizacja stanu. Usluga dziala."), EVENTLOG_SUCCESS);
	
	/* Okresowe aktualizowanie stanu. */
    /*** Ptl do obsugi aktualizacji mona uruchomi w odrbnym wtku. ***/
    /* Naley te sprawdzi flag pauseFlag  zobacz wiczenie 13-1. */
	LogEvent (_T("Uruchamianie glownej petli uslugi."), EVENTLOG_SUCCESS);
	while (!shutDown) { /* Flaga shutDown jest ustawiana przy poleceniu zamknicia. */
		Sleep (UPDATE_TIME);
		UpdateStatus (-1, -1);  /* Zamy, e zmiany nie wystpiy. */
		LogEvent (_T("Aktualizacja stanu. Brak zmian."), EVENTLOG_SUCCESS);
	}

	LogEvent (_T ("Proces serwera zakonczyl prace."), EVENTLOG_SUCCESS);

	return 0;
}


/*	Procedura sterujca. */

VOID WINAPI ServerCtrlHandler( DWORD dwControl)
 
{
	switch (dwControl) {
	case SERVICE_CONTROL_SHUTDOWN:
	case SERVICE_CONTROL_STOP:
		shutDown = TRUE;
		UpdateStatus (SERVICE_STOP_PENDING, -1);
		break;
	case SERVICE_CONTROL_PAUSE:
		pauseFlag = TRUE;
		/* Implementacja wstrzymania to temat wiczenia. */
		break;
	case SERVICE_CONTROL_CONTINUE:
		pauseFlag = FALSE;
		/* Implementacja kontynuacji to te wiczenie. */
		break;
	case SERVICE_CONTROL_INTERROGATE:
		break;
	default:
		if (dwControl > 127 && dwControl < 256) /* Zdefiniowane przez uytkownika. */
		break;
	}
	UpdateStatus (-1, -1);
	return;
}

void UpdateStatus (int NewStatus, int Check)
/*  Ustawianie stanu usugi i punktu kontrolnego (na okrelon warto lub przez zwikszenie). */
{
	if (Check < 0 ) hServStatus.dwCheckPoint++;
	else			hServStatus.dwCheckPoint = Check;
	if (NewStatus >= 0) hServStatus.dwCurrentState = NewStatus;
	if (isService) {
		if (!SetServiceStatus (hSStat, &hServStatus)) {
			LogEvent (_T("Nie mozna ustawic stanu."), EVENTLOG_ERROR_TYPE);
			hServStatus.dwCurrentState = SERVICE_STOPPED;
			hServStatus.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
			hServStatus.dwServiceSpecificExitCode = 2;
			UpdateStatus (SERVICE_STOPPED, -1);
			return;
		} else {
			LogEvent (_T("Zaktualizowano stan uslugi."), EVENTLOG_SUCCESS);
		}
	} else {
		LogEvent (_T("Zaktualizowano stan niezaleznego programu."), EVENTLOG_SUCCESS);
	}

	return;
}

static FILE * logFp = NULL;
/* Proste rejestrowanie zdarze w pliku. */
VOID LogEvent (LPCTSTR UserMessage, WORD type)
{
	TCHAR cTimeString[30] = _T("");
	time_t currentTime = time(NULL);
	_tcsncat (cTimeString, _tctime(&currentTime), 30);
	/* Usuwanie znaku nowego wiersza na kocu acucha z czasem. */
	cTimeString[_tcslen(cTimeString)-2] = _T('\0');
	_ftprintf(logFp, _T("%s. "), cTimeString);
	if (type == EVENTLOG_SUCCESS || type == EVENTLOG_INFORMATION_TYPE) 
		_ftprintf(logFp, _T("%s"), _T("Informacja.  "));
	else if (type == EVENTLOG_ERROR_TYPE)
		_ftprintf(logFp, _T("%s"), _T("Blad.        "));
	else if (type == EVENTLOG_WARNING_TYPE)
		_ftprintf(logFp, _T("%s"), _T("Ostrzezenie. "));
	else
		_ftprintf(logFp, _T("%s"), _T("Nieznane.    "));

	_ftprintf(logFp, _T("%s\n"), UserMessage);
	fflush(logFp);
	return;
}

BOOL LogInit(LPTSTR name)
{
	logFp = _tfopen (name, _T("a+"));
	if (logFp != NULL) LogEvent (_T("Zainicjowano rejestrowanie."), EVENTLOG_SUCCESS);
	return (logFp != NULL);
}

VOID LogClose()
{
	LogEvent (_T("Zamykanie dziennika."), EVENTLOG_SUCCESS);
	return;
}
