/*	Rozdzia 13. */
/*	ServiceShell.c.  powoka do zarzdzania usugami systemu Windows.
   Jest to zmodyfikowana wersja programu do zarzdzania zadaniami z rozdziau 6.
   Tu program zarzdza usugami, a nie zadaniami. */
/*  Ilustruje sterowanie usug z poziomu programu.
   Zwykle naley korzysta z polecenia sc.exe lub narzdzia
   administracyjnego Usugi. */
/*	Oto lista obsugiwanych polece:
      create     Tworzy usug
      delete     Usuwa usug
      start      Uruchamia usug
      control    Kontroluje usug  */
#include "Everything.h"

static int Create   (int, LPTSTR *, LPTSTR);
static int Delete   (int, LPTSTR *, LPTSTR);
static int Start    (int, LPTSTR *, LPTSTR);
static int Control  (int, LPTSTR *, LPTSTR);

static SC_HANDLE hScm;
static BOOL debug;

int _tmain (int argc, LPTSTR argv [])
{
	BOOL exitFlag = FALSE;
	TCHAR command [MAX_COMMAND_LINE+10], *pc;
	DWORD i, locArgc; /* Lokalny argument argc. */
	TCHAR argstr [MAX_ARG] [MAX_COMMAND_LINE];
	LPTSTR pArgs [MAX_ARG];

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	debug = (argc > 1); /* Prosta flaga diagnostyczna. */
	/*  Przygotowywanie lokalnej tablicy argv ze wskanikami do acuchw znakw */
	for (i = 0; i < MAX_ARG; i++) pArgs[i] = argstr[i];

	/*  Otwieranie na lokalnym komputerze menedera SCM 
       z domyln baz danych i penym dostpem. */
	hScm = OpenSCManager (NULL, SERVICES_ACTIVE_DATABASE, SC_MANAGER_ALL_ACCESS);
	if (hScm == NULL) ReportError (_T("Nie mozna otworzyc menedzera SC."), 1, TRUE);

	/*  Gwna ptla do przetwarzania polecenia.  */
	_tprintf (_T("\nZarzadzanie uslugami systemu Windows."));
	while (!exitFlag) {
		_tprintf (_T("\nSM$"));
		_fgetts (command, MAX_COMMAND_LINE, stdin);
		/*  Zastpowanie znaku nowego wiersza sekwencj koca acucha znakw. */
		pc = _tcschr (command, _T('\n')); *pc = _T('\0');

		if (debug) _tprintf (_T("%s\n"), command); 
		/*  Przeksztacanie polecenia na posta argc, argv. */
		GetArgs (command, &locArgc, pArgs);
		CharLower (argstr [0]);  /* Wielko znakw w poleceniu nie ma znaczenia. */

		if (debug) _tprintf (_T("\n%s %s %s %s"), argstr[0], argstr[1],
			argstr[2], argstr[3]);

		if (_tcscmp (argstr[0], _T("create")) == 0) {
			Create (locArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("delete")) == 0) {
			Delete (locArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("start")) == 0) {
			Start (locArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("control")) == 0) {
			Control (locArgc, pArgs, command);
		}
		else if (_tcscmp (argstr[0], _T("quit")) == 0) {
			exitFlag = TRUE;
		}
		else _tprintf (_T("\nNieznane polecenie."));
	}

	CloseServiceHandle (hScm);
	return 0;
}


int Create (int argc, LPTSTR argv [], LPTSTR command)
{
	/*  Tworzenie nowej usugi z ustawieniem SERVICE_DEMAND_START:
       argv[1]: nazwa usugi
       argv[2]: wywietlana nazwa
       argv[3]: binarny plik wykonywalny 
 */
	SC_HANDLE hSc;
	TCHAR executable[MAX_PATH+1], quotedExecutable[MAX_PATH+3] = _T("\"");

	if (argc < 4) {
		_tprintf (_T("\nStosowanie: create nazwaUslugi, wyswietlanaNazwa itd."));
		return 1;
	}

	/* Potrzebna jest pena cieka i  jeli wystpuj odstpy  cudzysowy. */
	GetFullPathName (argv[3], MAX_PATH+1, executable, NULL);
	_tcscat(quotedExecutable, executable);
	_tcscat(quotedExecutable, _T("\""));

	if (debug) _tprintf (_T("\nPelna sciezka do uslugi: %s"), executable);

	hSc = CreateService (hScm, argv[1], argv[2],
		SERVICE_ALL_ACCESS, SERVICE_WIN32_OWN_PROCESS, 
		SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,
		quotedExecutable, NULL, NULL, NULL, NULL, NULL);
	if (hSc == NULL) ReportError (_T("Nie mozna utworzyc uslugi."), 0, TRUE);
	else CloseServiceHandle (hSc); /* Nie trzeba zachowywa uchwytu, poniewa
                        funkcja OpenService pobiera informacje z bazy danych usugi. */
	return 0;

}

/*  Usuwanie usugi
      argv[1]: nazwa usuwanej usugi  */
int Delete (int argc, LPTSTR argv [], LPTSTR command)
{
	SC_HANDLE hSc;

	if (debug) _tprintf (_T("\nPrzed usunieciem uslugi: %s"), argv[1]);

	hSc = OpenService(hScm,  argv[1], DELETE);
	if (hSc == NULL) {
		_tprintf (_T("\nBlad zarzadzania uslugami."));
		ReportError (_T("\nNie mozna otworzyc uslugi w celu jej usuniecia."), 0, TRUE);
	}
	else {
		if (!DeleteService (hSc)) 
			ReportError (_T("\nNie mozna usunac uslugi."), 0, TRUE);
		CloseServiceHandle (hSc);
		if (debug) _tprintf (_T("\nJesli brak komunikatow o bledach, usluga %s zostala usunieta."), argv[1]);
	}

	return 0;
}

/*  Uruchamianie nazwanej usugi
      argv[1]: nazwa uruchamianej usugi */
int Start (int argc, LPTSTR argv [], LPTSTR command)
{
	SC_HANDLE hSc;
	TCHAR workingDir [MAX_PATH+1];
	LPTSTR argvStart[] = {argv[1], workingDir};

	GetCurrentDirectory (MAX_PATH+1, workingDir);
	if (debug) _tprintf (_T("\nPrzed uruchomieniem uslugi %s w katalogu %s."),
		argv[1], workingDir);
	
	/* Pobieranie uchwytu usugi podanej w wierszu polece (argv[1]). */
	hSc = OpenService(hScm,  argv[1], SERVICE_ALL_ACCESS);
	if (hSc == NULL) {
		_tprintf (_T("\nBlad zarzadzania usluga."));
		ReportError (_T("\nNie mozna uruchomic nazwanej uslugi."), 0, TRUE);
	}
	else {
		/*  Uruchamia usug z jednym argumentem  katalogiem roboczym.  */
        /*  Nazwa usugi pochodzi z wiersza polece programu (argv[1]).  */
		/*	Warto zauway, e nazwa jest okrelana take przy otwieraniu uchwytu usugi. */
		/*	Sugerowany eksperyment: co si stanie, jeli te nazwy s rne od siebie? */

		if (!StartService (hSc, 2, argvStart)) {
			ReportError (_T("\nNie mozna uruchomic uslugi."), 0, TRUE);
		}
		CloseServiceHandle (hSc);
		if (debug) _tprintf (_T("\nJesli brak komunikatow o bledach, usluga %s zostala uruchomiona."), argv[1]);
	}

	return 0;
}

/*  Sterowanie nazwan usug.
      argv[1]: nazwa kontrolowanej usugi
      argv[2]: polecenie sterujce (wielko znakw nie ma znaczenia):
            stop
            pause
            resume
            interrogate
            user - zdefiniowane przez uytkownika
	  argv[3]:    liczba midzy 128 i 255, jeli polecenie to "user"
					*/
static LPCTSTR commandList [] = 
	{_T("stop"), _T("pause"), _T("resume"), _T("interrogate"), _T("user") };
static DWORD controlsAccepted [] = {
	SERVICE_CONTROL_STOP, SERVICE_CONTROL_PAUSE,
	SERVICE_CONTROL_CONTINUE, SERVICE_CONTROL_INTERROGATE, 128 };

int Control (int argc, LPTSTR argv [], LPTSTR command)
{

	SC_HANDLE hSc;
	SERVICE_STATUS serviceStatus;
	DWORD dwControl, i;
	BOOL found = FALSE;

	if (debug) _tprintf (_T("\nSterowanie usluga: %s"), argv[1]);

	for (i= 0; i < sizeof(controlsAccepted)/sizeof(DWORD) && !found; i++)
		found = (_tcscmp (commandList[i], argv[2]) == 0);
	if (!found) {
		_tprintf (_T("\nNiedozwolone polecenie sterujace %s"), argv[1]);
		return 1;
	}
	dwControl = controlsAccepted[i-1];
	if (dwControl == 128) dwControl = _ttoi (argv[3]);
	if (debug) _tprintf (_T("\ndwControl = %d"), dwControl);

	hSc = OpenService(hScm,  argv[1],
		SERVICE_INTERROGATE | SERVICE_PAUSE_CONTINUE | 
		SERVICE_STOP | SERVICE_USER_DEFINED_CONTROL | 
		SERVICE_QUERY_STATUS );
	if (hSc == NULL) {
		_tprintf (_T("\nBlad zarzadzania usluga."));
		ReportError (_T("\nNie mozna otworzyc uslugi nazwanej na potrzeby sterowania."), 0, TRUE);
	}
	else {
		if (!ControlService (hSc, dwControl, &serviceStatus))
			ReportError (_T("\nNie mozna sterowac usluga."), 0, TRUE);
		if (debug) _tprintf (_T("\nJesli brak komunikatow o bledach, usluga %s jest kontrolowana."), argv[1]);
	}

	if (dwControl == SERVICE_CONTROL_INTERROGATE) {
		if (!QueryServiceStatus (hSc, &serviceStatus))
			ReportError (_T("\nNie mozna sprawdzic stanu uslugi."), 0, TRUE);
		_tprintf (_T("\nStan z funkcji QueryServiceStatus."));
		_tprintf (_T("\nStan uslugi:"));
		_tprintf (_T("\ndwServiceType: %d"),             serviceStatus.dwServiceType);
		_tprintf (_T("\ndwCurrentState: %d"),            serviceStatus.dwCurrentState);
		_tprintf (_T("\ndwControlsAccepted: %d"),        serviceStatus.dwControlsAccepted);
		_tprintf (_T("\ndwWin32ExitCode: %d"),           serviceStatus.dwWin32ExitCode);
		_tprintf (_T("\ndwServiceSpecificExitCode: %d"), serviceStatus.dwServiceSpecificExitCode);
		_tprintf (_T("\ndwCheckPoint: %d"),              serviceStatus.dwCheckPoint);
		_tprintf (_T("\ndwWaitHint: %d"),                serviceStatus.dwWaitHint);

	}
	if (hSc != NULL) CloseServiceHandle (hSc);
	return 0;
}
 
 







