/* Rozdzia 12. serverSKHA.c													*/
/* Klient-serwer. SERWER. GNIAZDA, WERSJA ZE STRUMIENIOWYM PRZESYANIEM DANYCH	*/
/*		WYKORZYSTANO TU "UCHWYT GNIAZDA" DO ZACHOWANIA STANU.				*/
/*		JEST TO NIECO ZMODYFIKOWANY PROGRAM serverSKST.c					*/
/* Wykonuje polecenie z dania i zwraca odpowied.							*/
/* Polecenia s wykonywane w procesie, jeli mona znale punkty wejcia	*/
/* do biblioteki wsplnej. W przeciwnym razie polecenia s wykonywane poza procesem.*/
/* DODATKOWY MECHANIZM: argv[1] moe by nazw biblioteki DLL obsugujcej	*/
/* usugi wewntrzprocesowe.												*/
/* Ta implementacja rni si od programu serverSK, poniewa uyto biblioteki	*/
/* DLL do obsugi operacji wejcia-wyjcia gniazd. Biblioteka ta uywa strumieni, */
/* a koniec komunikatu okrela koniec wiersza, a nie na nagwek z dugoci.		*/
/* Rnice le w funkcjach ReceiveCSMessage i					*/
/* SendCSMessage (nazwy inne ni w serverSK), dlatego gwny program si nie zmienia.  */
/* Usunito implementacje funkcji i zaimportowano dwie funkcje */
/* do obsugi komunikatw. */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicje rekordw da i odpowiedzi. */

struct sockaddr_in srvSAddr;		/* Struktura adresu gniazda serwera. */
struct sockaddr_in connectSAddr;	/* Poczone gniazdo.   */
WSADATA WSStartData;				/* Struktura danych z biblioteki do obsugi gniazd.   */

typedef struct SERVER_ARG_TAG { /* Argumenty wtku serwera. */
	volatile DWORD	number;
	volatile SOCKET sock;
	volatile DWORD	status; /* 0: nie istnieje, 1: zatrzymany, 2: dziaa, 
				3: zatrzymuje cay system. */
	volatile HANDLE hSrvThread;
	HINSTANCE hDll; /* Uchwyt wsplnej biblioteki. */
} SERVER_ARG;

__declspec (dllimport) PVOID CreateCSSocketHandle (SOCKET);
__declspec (dllimport) BOOL CloseCSSocketHandle (PVOID);
__declspec (dllimport) BOOL ReceiveCSMessage (REQUEST *pRequest, PVOID);
__declspec (dllimport) BOOL SendCSMessage (RESPONSE *pResponse, PVOID);
static DWORD WINAPI Server (SERVER_ARG *);
static DWORD WINAPI AcceptThread (SERVER_ARG *);
static BOOL  WINAPI Handler (DWORD);

static HANDLE hSrvThread[MAX_CLIENTS];
volatile static shutFlag = FALSE;
static SOCKET serverSocket = INVALID_SOCKET, ConnectSock = INVALID_SOCKET;

int _tmain (int argc, LPCTSTR argv [])
{
	/* Gniazda serwera - nasuchujce i poczone. */
	BOOL done = FALSE;
	DWORD iThread, tStatus;
	SERVER_ARG serverArg[MAX_CLIENTS];
	HANDLE hAcceptTh = NULL;
	HINSTANCE hDll = NULL;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);


	/* Procedura sterujca konsoli umoliwiajca zamknicie serwera. */
	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T("Nie mozna utworzyc procedury sterujacej."), 1, TRUE);

	/*	Inicjowanie biblioteki gniazd w wersji 1.1. */
	if (WSAStartup (MAKEWORD (1, 1), &WSStartData) != 0)
		ReportError (_T("Brak obslugi gniazd."), 1, TRUE);
	
	/* Otwieranie biblioteki DLL do obsugi da, jeli podano j w wierszu polece. */
	if (argc > 1) {
		hDll = LoadLibrary (argv[1]);
		if (hDll == NULL) ReportError (argv[1], 0, TRUE);
	}

	/* Inicjowanie tablicy argumentw wtku. */
	for (iThread = 0; iThread < MAX_CLIENTS; iThread++) {
		serverArg[iThread].number = iThread;
		serverArg[iThread].status = 0;
		serverArg[iThread].sock = 0;
		serverArg[iThread].hDll = hDll;
		serverArg[iThread].hSrvThread = NULL;
	}
	/*	Naley przestrzega standardowej dla serwera sekwencji  socket-bind-listen-accept. */
	serverSocket = socket(PF_INET, SOCK_STREAM, 0);
	if (serverSocket == INVALID_SOCKET) 
		ReportError (_T("Nieudane wywolanie funkcji socket() na serwerze."), 1, TRUE);
    
	/*	Przygotowanie struktury na adres gniazda w celu powizania
       gniazda serwera z numerem portu zarezerwowanym dla tej usugi.
       Serwer akceptuje dania z dowolnej maszyny klienckiej.  */

    srvSAddr.sin_family = AF_INET;	
    srvSAddr.sin_addr.s_addr = htonl( INADDR_ANY );    
    srvSAddr.sin_port = htons( SERVER_PORT );	
	if (bind (serverSocket, (struct sockaddr *)&srvSAddr, sizeof(srvSAddr)) == SOCKET_ERROR)
		ReportError (_T("Nieudane wywolanie funkcji bind() na serwerze."), 2, TRUE);
	if (listen (serverSocket, MAX_CLIENTS) != 0) 
		ReportError (_T("Nieudane wywolanie funkcji listen() na serwerze."), 3, TRUE);

	/* Wtek gwny staje si wtkiem do nasuchu, czenia lub obserwowania. */
	/* Trzeba znale puste miejsce w tablicy argumentw wtku serwera. */
	/* Stany:	0 - slot jest wolny;	1 - wtek jest zatrzymany; 
						2 - wtek dziaa; 3 - zatrzymywanie caego systemu. */
	while (!shutFlag) {
		for (iThread = 0; iThread < MAX_CLIENTS && !shutFlag; ) {
			if (serverArg[iThread].status == 1 || serverArg[iThread].status == 3) {
				/* Zatrzymany (w zwyky sposb lub w odpowiedzi na danie zamknicia). */
				tStatus = WaitForSingleObject (serverArg[iThread].hSrvThread, INFINITE);
				if (tStatus != WAIT_OBJECT_0) 
					ReportError (_T("Blad oczekiwania na watek serwera."), 4, TRUE);
				CloseHandle (serverArg[iThread].hSrvThread);
				if (serverArg[iThread].status == 3) shutFlag = TRUE;
				else serverArg[iThread].status = 0; /* Wolne miejsce na wtek. */
			}				
			if (serverArg[iThread].status == 0 || shutFlag) break;
			iThread = (iThread+1) % MAX_CLIENTS;
			if (iThread == 0) Sleep(1000); /* Wstrzymanie ptli sprawdzajcej. */
			/* Inna moliwo  uycie zdarzenia do zgoszenia wolnego miejsca. */
		}

		/* Oczekiwanie na poczenie dla danego gniazda. */
        /* Aby mc sprawdzi flag shutFlag, naley uy odrbnego wtku akceptujcego poczenia. */
		hAcceptTh = (HANDLE)_beginthreadex (NULL, 0, AcceptThread, &serverArg[iThread], 0, NULL);
		while (!shutFlag) {
			tStatus = WaitForSingleObject (hAcceptTh, CS_TIMEOUT);
			if (tStatus == WAIT_OBJECT_0) break; /* Nawizano poczenie. */
		}
		CloseHandle (hAcceptTh);
		hAcceptTh = NULL; /* Przygotowywanie na nastpne poczenie. */
	}
	
	_tprintf (_T("Trwa zamykanie. Oczekiwanie na watki serwera.\n"));
	/* Zamykanie wtku akceptujcego, jeli wci dziaa. */
	if (hAcceptTh != NULL) TerminateThread (hAcceptTh, 0);
	/* Oczekiwanie na zakoczenie pracy przez aktywne wtki serwera. */
	shutdown (serverSocket, 2);
	closesocket (serverSocket);
	WSACleanup();
	for (iThread = 0; iThread < MAX_CLIENTS; iThread++) {
		if (serverArg[iThread].status != 0) WaitForSingleObject (serverArg[iThread].hSrvThread, INFINITE);
		CloseHandle (serverArg[iThread].hSrvThread);
	}
	if (hDll != NULL) FreeLibrary (hDll);	
	_tprintf (_T("Zakonczono dealokacje wszystkich zasobow serwera. ExitProcess(0).\n"));
	ExitProcess(0);
	return 0;
}

static DWORD WINAPI AcceptThread (SERVER_ARG * pThArg)
{
	LONG AddrLen, ThId;
	
	AddrLen = sizeof(connectSAddr);
	pThArg->sock = 
		 accept (serverSocket, (struct sockaddr *)&connectSAddr, &AddrLen);
	if (pThArg->sock == INVALID_SOCKET) ReportError (_T("Blad funkcji accept."), 1, TRUE);
	/* Nowe poczenie. Tworzenie wtku serwera. */
	pThArg->status = 2; 
	pThArg->hSrvThread = (HANDLE)_beginthreadex (NULL, 0, Server, pThArg, 0, &ThId);
	if (pThArg->hSrvThread == NULL) 
		ReportError (_T("Nieudane tworzenie watku serwera."), 0, TRUE);
	return 0; /* Wtek serwera nadal dziaa. */
}


static DWORD WINAPI Server (SERVER_ARG * pThArg)

/* Funkcja wtku serwera. Dla kadego potencjalnego klienta dziaa jeden wtek. */
{
	/* Kady wtek przechowuje na stosie swoje struktury na danie, odpowied i
       operacje pomocnicze. */
	/* Wszystkie komunikaty obejmuj znaki 8-bitowe, ale sam serwer uywa znakw uniwersalnych. */
	BOOL done = FALSE;
	STARTUPINFO startInfoCh;
	SECURITY_ATTRIBUTES tempSA = {sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
	PROCESS_INFORMATION procInfo;
	SOCKET connectSocket;
	PVOID sh; /* Wskanik do uchwytu gniazda. */
	int disconnect = 0, iTokenLen;
	REQUEST request;	/* Zdefiniowana w pliku ClientServer.h */
	RESPONSE response;	/* Zdefiniowana w pliku ClientServer.h.*/
	char sysCommand[MAX_RQRS_LEN];
	TCHAR tempFile[100];
	HANDLE hTmpFile;
	FILE *fp = NULL;
	int (*dl_addr)(char *, char *);
	char *ws = " \0\t\n"; /* Odstp. */

	GetStartupInfo (&startInfoCh);
	
	connectSocket = pThArg->sock;
	/* Tworzenie uchwytu gniazda. */
	sh = CreateCSSocketHandle (connectSocket);
	/* Tworzenie nazwy pliku tymczasowego. */
	_stprintf (tempFile, _T("%s%d%s"), _T("ServerTemp"), pThArg->number, _T(".tmp"));

	while (!done && !shutFlag) { 	/* Gwna ptla serwera suca do przetwarzania polece. */

		disconnect = ReceiveCSMessage (&request, sh);
		done = disconnect || (strcmp (request.record, "$Koniec") == 0);
		if (done) continue;	
		/* Zatrzymywanie wtku przy poleceniu "$Koniec" lub "$ShutDownServer". */

		/* Otwieranie pliku tymczasowego na wyniki. */
		hTmpFile = CreateFile (tempFile, GENERIC_READ | GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE, &tempSA,
				CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hTmpFile == INVALID_HANDLE_VALUE)
			ReportError (_T("Nie mozna utworzyc pliku tymczasowego."), 1, TRUE);

		/* Sprawdzanie polecenia z biblioteki wsplnej. Dla uproszczenia polecenia z */
        /* biblioteki wsplnej maj pierwszestwa nad poleceniami z procesu. 	*/
		/* Najpierw trzeba wyodrbni nazw polecenia. */

		iTokenLen = (int)strcspn (request.record, ws); /* Dugo elementu. */
		memcpy (sysCommand, request.record, iTokenLen);
		sysCommand[iTokenLen] = '\0';

		dl_addr = NULL; /* Zostanie ustawiona po udanym wykonaniu funkcji GetProcAddress. */
		if (pThArg->hDll != NULL) { /* Prba uruchomienia serwera wewntrzprocesowego. */
			dl_addr = (int (*)(char *, char *))GetProcAddress (pThArg->hDll, sysCommand);
			if (dl_addr != NULL) __try { /* Zabezpieczanie procesu serwera przed wyjtkami
                                            w bibliotece DLL. */
				(*dl_addr)(request.record, tempFile);
			}
			__except (EXCEPTION_EXECUTE_HANDLER) { /* Wyjtek w bibliotece DLL. */
				ReportError (_T("Wyjatek w bibliotece DLL."), 0, FALSE);
			}
		}
			
		if (dl_addr == NULL) { /* Brak obsugi serwera wewntrzprocesowego. */
			/* Tworzenie procesu w celu wykonania polecenia. */
			startInfoCh.hStdOutput = hTmpFile;
			startInfoCh.hStdError = hTmpFile;
			startInfoCh.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
			startInfoCh.dwFlags = STARTF_USESTDHANDLES;

			if (!CreateProcess (NULL, request.record, NULL,
					NULL, TRUE, /* Dziedziczenie uchwytw. */
					0, NULL, NULL, &startInfoCh, &procInfo)) {
				PrintMsg (hTmpFile, _T("Blad: nie mozna utworzyc procesu."));
				procInfo.hProcess = NULL;
			}
			CloseHandle (hTmpFile);
			if (procInfo.hProcess != NULL ) {
				CloseHandle (procInfo.hThread);
				WaitForSingleObject (procInfo.hProcess, INFINITE);
				CloseHandle (procInfo.hProcess);
			}
		}
			
		/* Odpowiadanie po jednym wierszu. Wygodnie jest zastosowa w tym
               miejscu dziaajce na wierszach procedury z biblioteki jzyka C. */

		/* Wysyanie do klienta pliku tymczasowego (z nagwkiem) po jednym wierszu. */

		fp = fopen (tempFile, "r");
		
		if (fp != NULL) {
			response.rsLen = MAX_RQRS_LEN;
			while ((fgets (response.record, MAX_RQRS_LEN, fp) != NULL)) {
				SendCSMessage (&response, sh);
			}
		}
		/* Wysyanie kocowego komunikatu zdefiniowanego */
		/* arbitralnie jako "$$$$$$$". */
		strcpy (response.record, "$$$$$$$");
		SendCSMessage (&response, sh);
		fclose (fp); fp = NULL;
		DeleteFile (tempFile); 

	}   /* Koniec gwnej ptli do obsugi polecenia. Pobieranie nastpnej instrukcji. */

	/* Koniec ptli do przetwarzania polece. Zwalnianie zasobw i wychodzenie z wtku. */

	_tprintf (_T("Zamykanie watku serwera numer %d\n"), pThArg->number);
	CloseCSSocketHandle (sh);
	closesocket (ConnectSock);
	shutdown (ConnectSock, 2);
	pThArg->status = 1;
	if (strcmp (request.record, "$ShutDownServer") == 0)	{
		pThArg->status = 3;
		shutFlag = TRUE;
	}

	return pThArg->status;	
}


BOOL WINAPI Handler (DWORD ctrlEvent)
{
	/* Zamykanie systemu. */
	shutFlag = TRUE;
	return TRUE;
}
