/* Rozdzia 12. System klient-serwer. SERWER  WERSJA OPARTA NA GNIAZDACH. */
/* Wykonuje polecenie z dania i zwraca odpowied. */
/* Polecenia s wykonywane w ramach procesu, jeli mona zlokalizowa punkt wejcia */
/* wsplnej biblioteki; w przeciwnym razie s uruchamiane poza procesem. */
/* DODATKOWY MECHANIZM: parametr argv [1] moe by nazw biblioteki DLL do */
/* obsugi serwerw wewntrzprocesowych. */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicje rekordw da i odpowiedzi. */

struct sockaddr_in srvSAddr;		/* Struktura adresu gniazda serwera. */
struct sockaddr_in connectSAddr;	/* Poczone gniazdo. */
WSADATA WSStartData;				/* Struktura danych z biblioteki do obsugi gniazd. */

enum SERVER_THREAD_STATE {	SERVER_SLOT_FREE, SERVER_THREAD_STOPPED, 
							SERVER_THREAD_RUNNING, SERVER_SLOT_INVALID};
typedef struct SERVER_ARG_TAG { /* Argumenty wtku serwera. */
	CRITICAL_SECTION threadCs;
	DWORD	number;
	SOCKET	sock;
	enum SERVER_THREAD_STATE thState; 	
	HANDLE	hSrvThread;
	HINSTANCE	 hDll; /* Uchwyt wsplnej biblioteki. */
} SERVER_ARG;

static BOOL ReceiveRequestMessage (REQUEST *pRequest, SOCKET);
static BOOL SendResponseMessage (RESPONSE *pResponse, SOCKET);
static DWORD WINAPI Server (PVOID);
static DWORD WINAPI AcceptThread (PVOID);
static BOOL  WINAPI Handler (DWORD);

volatile static int shutFlag = 0;
static SOCKET SrvSock = INVALID_SOCKET, connectSock = INVALID_SOCKET;

int _tmain (int argc, LPCTSTR argv [])
{
	/* Gniazda serwera - nasuchujce i poczone. */
	DWORD iThread, tStatus;
	SERVER_ARG sArgs[MAX_CLIENTS];
	HANDLE hAcceptThread = NULL;
	HINSTANCE hDll = NULL;

	if (!WindowsVersionOK (3, 1)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 3.1 lub nowszego."), 1, FALSE);

	/* Procedura sterujca konsoli umoliwiajca zamknicie serwera. */
	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T("Nie mozna utworzyc procedury sterujacej."), 1, TRUE);

	/* Inicjowanie biblioteki WS w wersji 2.0. */
	if (WSAStartup (MAKEWORD (2, 0), &WSStartData) != 0)
		ReportError (_T("Brak obslugi gniazd."), 1, TRUE);
	
	/* Otwieranie biblioteki DLL do obsugi da, jeli podano j w wierszu polece. */
	if (argc > 1) {
		hDll = LoadLibrary (argv[1]);
		if (hDll == NULL) ReportError (argv[1], 0, TRUE);
	}

	/* Inicjowanie tablicy argumentw wtku. */
	for (iThread = 0; iThread < MAX_CLIENTS; iThread++) {
		InitializeCriticalSection (&sArgs[iThread].threadCs);
		sArgs[iThread].number = iThread;
		sArgs[iThread].thState = SERVER_SLOT_FREE;
		sArgs[iThread].sock = 0;
		sArgs[iThread].hDll = hDll;
		sArgs[iThread].hSrvThread = NULL;
	}
	/*	Naley przestrzega standardowej dla serwera sekwencji  socket-bind-listen-accept. */
	SrvSock = socket(PF_INET, SOCK_STREAM, 0);
	if (SrvSock == INVALID_SOCKET) 
		ReportError (_T("Nieudane wywolanie funkcji socket() na serwerze."), 1, TRUE);
    
	/*	Przygotowanie struktury na adres gniazda w celu powizania
       gniazda serwera z numerem portu zarezerwowanym dla tej usugi.
       Serwer akceptuje dania z dowolnej maszyny klienckiej.  */

	srvSAddr.sin_family = AF_INET;	
	srvSAddr.sin_addr.s_addr = htonl( INADDR_ANY );    
	srvSAddr.sin_port = htons( SERVER_PORT );	
	if (bind (SrvSock, (struct sockaddr *)&srvSAddr, sizeof(srvSAddr)) == SOCKET_ERROR)
		ReportError (_T("Nieudane wywolanie funkcji bind() na serwerze."), 2, TRUE);
	if (listen (SrvSock, MAX_CLIENTS) != 0) 
		ReportError (_T("Blad funkcji listen() na serwerze."), 3, TRUE);

	/* Wtek gwny staje si wtkiem do nasuchu, czenia lub obserwowania. */
    /* Trzeba znale puste miejsce w tablicy argumentw wtku serwera. */
	while (!shutFlag) {
		iThread = 0;
		while (!shutFlag) {
			/* Cige sprawdzanie stanu wtku we wszystkich pozycjach tablicy sArgs. */
			EnterCriticalSection(&sArgs[iThread].threadCs);
			__try {
				if (sArgs[iThread].thState == SERVER_THREAD_STOPPED) {
					/* Zatrzymany (w zwyky sposb lub w odpowiedzi na danie zamknicia). */
                    /* Oczekiwanie na zatrzymanie pracy i zwalnianie miejsca dla nastpnego wtku. */
					tStatus = WaitForSingleObject (sArgs[iThread].hSrvThread, INFINITE);
					if (tStatus != WAIT_OBJECT_0)
						ReportError (_T("Blad oczekiwania na watek serwera."), 4, TRUE);
					CloseHandle (sArgs[iThread].hSrvThread);
					sArgs[iThread].hSrvThread = NULL;
					sArgs[iThread].thState = SERVER_SLOT_FREE;
				}				
				/* Zwolnienie miejsca lub zamknicie. Miejsce zostanie uyte dla nowego poczenia. */
				if (sArgs[iThread].thState == SERVER_SLOT_FREE || shutFlag) break;
			}
			__finally { LeaveCriticalSection (&sArgs[iThread].threadCs); }

			iThread = (iThread++) % MAX_CLIENTS;
			if (iThread == 0) Sleep(50); /* Wstrzymanie ptli sprawdzajcej. */
			/* Inna moliwo  uycie zdarzenia do zgoszenia wolnego miejsca. */
		}
		if (shutFlag) break;
		/* sArgs[iThread] == SERVER_SLOT_FREE */
		/* Oczekiwanie na poczenie dla danego gniazda. */
        /* Aby mc sprawdzi flag shutFlag, naley uy odrbnego wtku akceptujcego poczenia. */
		hAcceptThread = (HANDLE)_beginthreadex (NULL, 0, AcceptThread, &sArgs[iThread], 0, NULL);
		if (hAcceptThread == NULL)
			ReportError (_T("Blad tworzenia watku akceptujacego."), 1, TRUE);
		while (!shutFlag) {
			tStatus = WaitForSingleObject (hAcceptThread, CS_TIMEOUT);
			if (tStatus == WAIT_OBJECT_0) {
				/* Poczenie zostao nawizane. sArgs[iThread] == SERVER_THREAD_RUNNING */
				if (!shutFlag) {
					CloseHandle (hAcceptThread);
					hAcceptThread = NULL;
				}
				break;
			}
		}
	}  /* ZEWNTRZNA ptla while (!shutFlag) */
	
	/* shutFlag == TRUE */
	_tprintf (_T("Trwa zamykanie. Oczekiwanie na watki serwera.\n"));
	/* Oczekiwanie na zakoczenie pracy przez aktywne wtki serwera. */
    /* Naley ponawia prby, poniewa niektre wtki mog dziaa przez dugi czas. */

	while (TRUE) {
		int nRunningThreads = 0;
		for (iThread = 0; iThread < MAX_CLIENTS; iThread++) {
			EnterCriticalSection(&sArgs[iThread].threadCs);
			__try {
				if (sArgs[iThread].thState == SERVER_THREAD_RUNNING || sArgs[iThread].thState == SERVER_THREAD_STOPPED) {
					if (WaitForSingleObject (sArgs[iThread].hSrvThread, 10000) == WAIT_OBJECT_0) {
						_tprintf (_T("Watek serwera na pozycji %d zostal zatrzymany.\n"), iThread);
						CloseHandle (sArgs[iThread].hSrvThread);
						sArgs[iThread].hSrvThread = NULL;
						sArgs[iThread].thState = SERVER_SLOT_INVALID;
					} else
						if (WaitForSingleObject (sArgs[iThread].hSrvThread, 10000) == WAIT_TIMEOUT) {
						_tprintf (_T("Watek serwera na pozycji %d nadal dziala.\n"), iThread);
						nRunningThreads++;
					} else {
						_tprintf (_T("Blad oczekiwania: pozycja %d.\n"), iThread);
						ReportError (_T("Nieudane oczekiwanie na watek."), 0, TRUE);
					}

				}
			}
			__finally { LeaveCriticalSection(&sArgs[iThread].threadCs); }
		}
		if (nRunningThreads == 0) break;
	}

	if (hDll != NULL) FreeLibrary (hDll);	

	/* Rezerwowe zamykanie. */
	shutdown (SrvSock, SD_BOTH);
	closesocket (SrvSock);
	WSACleanup();
	if (hAcceptThread != NULL && WaitForSingleObject(hAcceptThread, INFINITE) != WAIT_OBJECT_0)
		ReportError (_T("Nieudane oczekiwanie na zakonczenie pracy przez watek akceptujacy."), 7, FALSE);
	return 0;
}

static DWORD WINAPI AcceptThread (PVOID pArg)
{
	LONG addrLen;
	SERVER_ARG * pThArg = (SERVER_ARG *)pArg;
	
	addrLen = sizeof(connectSAddr);
	pThArg->sock = 
		 accept (SrvSock, (struct sockaddr *)&connectSAddr, &addrLen);
	if (pThArg->sock == INVALID_SOCKET) {
		ReportError (_T("accept: blad nieprawidlowego gniazda."), 1, TRUE);
		return 1;
	}
	/* Nowe poczenie. Tworzenie wtku serwera. */
	EnterCriticalSection(&(pThArg->threadCs));
	__try {
		pThArg->hSrvThread = (HANDLE)_beginthreadex (NULL, 0, Server, pThArg, 0, NULL);
		if (pThArg->hSrvThread == NULL) 
			ReportError (_T("Nieudane tworzenie watku serwera."), 1, TRUE);
		pThArg->thState = SERVER_THREAD_RUNNING; 
		_tprintf (_T("Zaakceptowano klienta na pozycji: %d przy uzyciu watka serwera %d.\n"), pThArg->number, GetThreadId (pThArg->hSrvThread));
		/* wiczenie: dodaj wywietlanie informacji o maszynie i procesie klienta. */
	}
	__finally { LeaveCriticalSection(&(pThArg->threadCs)); }
	return 0;
}

BOOL WINAPI Handler (DWORD CtrlEvent)
{
	/* Odebrano kombinacj ^C. Zaymkanie systemu. */
	_tprintf (_T("W procesurze sterujacej konsoli.\n"));
	InterlockedIncrement (&shutFlag);
	return TRUE;
}

static DWORD WINAPI Server (PVOID pArg)

/* Funkcja wtku serwera. Dla kadego potencjalnego klienta dziaa jeden wtek. */
{
	/* Kady wtek przechowuje na stosie swoje struktury na danie, odpowied i
       operacje pomocnicze. */
	/* UWAGA: wszystkie komunikaty obejmuj znaki 8-bitowe. */

	BOOL done = FALSE;
	STARTUPINFO startInfoCh;
	SECURITY_ATTRIBUTES tempSA = {sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
	PROCESS_INFORMATION procInfo;
	SOCKET connectSock;
	int commandLen;
	REQUEST request;	/* Zdefiniowana w pliku ClientServer.h. */
	RESPONSE response;	/* Zdefiniowana w pliku ClientServer.h.*/
	char sysCommand[MAX_RQRS_LEN];
	TCHAR tempFile[100];
	HANDLE hTmpFile;
	FILE *fp = NULL;
	int (__cdecl *dl_addr)(char *, char *);
	SERVER_ARG * pThArg = (SERVER_ARG *)pArg;
	enum SERVER_THREAD_STATE threadState;

	GetStartupInfo (&startInfoCh);
	
	connectSock = pThArg->sock;
	/* Tworzenie nazwy pliku tymczasowego. */
	tempFile[sizeof(tempFile)/sizeof(TCHAR) - 1] = _T('\0');
	_stprintf_s (tempFile, sizeof(tempFile)/sizeof(TCHAR) - 1, _T("ServerTemp%d.tmp"), pThArg->number);

	while (!done && !shutFlag) { 	/* Gwna ptla serwera suca do przetwarzania polece. */
		done = ReceiveRequestMessage (&request, connectSock);

		request.record[sizeof(request.record)-1] = '\0';
		commandLen = (int)(strcspn (request.record, "\n\t"));
		memcpy (sysCommand, request.record, commandLen);
		sysCommand[commandLen] = '\0';
		_tprintf (_T("Otrzymano polecenie w %d slocie serwera: %s\n"), pThArg->number, sysCommand);

		/* Ponowne sprawdzanie flagi shutFlag. Mona j ustawi w procedurze sterujcej konsoli. */
		done = done || (strcmp (request.record, "$Koniec") == 0) || shutFlag;
		if (done) continue;	

		/* Otwieranie pliku tymczasowego na wyniki. */
		hTmpFile = CreateFile (tempFile, GENERIC_READ | GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE, &tempSA,
				CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hTmpFile == INVALID_HANDLE_VALUE)
			ReportError (_T("Nie mozna utworzyc pliku tymczasowego."), 1, TRUE);

		/* Sprawdzanie polecenia z biblioteki wsplnej. Dla uproszczenia polecenia z */
        /* biblioteki wsplnej maj pierwszestwa nad poleceniami z procesu. 	*/
		/* Najpierw trzeba wyodrbni nazw polecenia (ograniczon odstpami). */
		dl_addr = NULL; /* Zostanie ustawiona po udanym wykonaniu funkcji GetProcAddress. */
		if (pThArg->hDll != NULL) { /* Prba uruchomienia serwera wewntrzprocesowego. */
			char commandName[256] = "";
			int commandNameLength = (int)(strcspn (sysCommand, " "));
			strncpy_s (commandName, sizeof(commandName), sysCommand, min(commandNameLength, sizeof(commandName)-1));
			dl_addr = (int (*)(char *, char *))GetProcAddress (pThArg->hDll, commandName);
			/* Biblioteka DLL musi by sprawdzona, aby nie uszkodzia serwera. */
			/* Zakadamy, e biblioteka DLL nie moe generowa znanych wyjtkw. */
			if (dl_addr != NULL) __try { 
				(*dl_addr)(request.record, tempFile);
			}
			__except (EXCEPTION_EXECUTE_HANDLER) { /* Wyjtek w pliku DLL. */
				_tprintf (_T("Nieobsluzony wyjatek w pliku DLL. Zamykanie serwera. Moga wystapic osierocone procesy."));
				return 1;
			}
		}

		if (dl_addr == NULL) { /* Brak obsugi serwera wewntrzprocesowego. */
			/* Tworzenie procesu w celu wykonania polecenia. */
			startInfoCh.hStdOutput = hTmpFile;
			startInfoCh.hStdError = hTmpFile;
			startInfoCh.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
			startInfoCh.dwFlags = STARTF_USESTDHANDLES;
			if (!CreateProcess (NULL, request.record, NULL,
					NULL, TRUE, /* Dziedziczenie uchwytw. */
					0, NULL, NULL, &startInfoCh, &procInfo)) {
				PrintMsg (hTmpFile, _T("Blad: nie mozna utworzyc procesu."));
				procInfo.hProcess = NULL;
			}
			CloseHandle (hTmpFile);
			if (procInfo.hProcess != NULL ) {
				CloseHandle (procInfo.hThread);
				WaitForSingleObject (procInfo.hProcess, INFINITE);
				CloseHandle (procInfo.hProcess);
			}
		}

		/* Odpowiadanie po jednym wierszu. Wygodnie jest zastosowa w tym
               miejscu dziaajce na wierszach procedury z biblioteki jzyka C. */

		/* Wysyanie do klienta pliku tymczasowego (z nagwkiem) po jednym wierszu. */		
		if (_tfopen_s (&fp, tempFile, _T("r")) == 0) {
			{	
				response.rsLen = MAX_RQRS_LEN;
				while ((fgets (response.record, MAX_RQRS_LEN, fp) != NULL)) 
					SendResponseMessage (&response, connectSock);
			}
			/* Wysyanie komunikatu o zerowej dugoci. W komunikatach uywane s znaki 8-bitowe, a nie UNICODE. */
			response.record[0] = '\0';
			SendResponseMessage (&response, connectSock);
			fclose (fp); fp = NULL;
			DeleteFile (tempFile); 
		}
		else {
			ReportError(_T("Nieudane otwieranie pliku tymczasowego z wynikami."), 0, TRUE);
		}

	}   /* Koniec gwnej ptli do obsugi polecenia. Pobieranie nastpnej instrukcji. */
	
	/* done || shutFlag */
	/* Koniec ptli do przetwarzania polece. Zwalnianie zasobw i wychodzenie z wtku. */
	_tprintf (_T("Zamykanie watku serwera numer %d\n"), pThArg->number);
	/* Rezerwowe zamykanie. Nie ma dalszych prb wysyania lub pobierania komunikatw. */
	shutdown (connectSock, SD_BOTH); 
	closesocket (connectSock);

	EnterCriticalSection(&(pThArg->threadCs));
	__try {
		threadState = pThArg->thState = SERVER_THREAD_STOPPED;
	}
	__finally { LeaveCriticalSection(&(pThArg->threadCs)); }

	return threadState;	
}

BOOL ReceiveRequestMessage (REQUEST *pRequest, SOCKET sd)
{
	BOOL disconnect = FALSE;
	LONG32 nRemainRecv = 0, nXfer;
	LPBYTE pBuffer;

	/*	Wczytywanie dania. Najpierw nagwek, nastpnie tekst dania. */
	nRemainRecv = RQ_HEADER_LEN; 
	pBuffer = (LPBYTE)pRequest;

	while (nRemainRecv > 0 && !disconnect) {
		nXfer = recv (sd, pBuffer, nRemainRecv, 0);
		if (nXfer == SOCKET_ERROR) 
			ReportError (_T("Nieudane wywolanie funkcji recv()."), 11, TRUE);
		disconnect = (nXfer == 0);
		nRemainRecv -=nXfer; pBuffer += nXfer;
	}
	
	/* Wczytywanie rekordu z daniem. */
	nRemainRecv = pRequest->rqLen;
	/* Wykluczanie przepenienia bufora. */
	nRemainRecv = min(nRemainRecv, MAX_RQRS_LEN);

	pBuffer = (LPSTR)pRequest->record;
	while (nRemainRecv > 0 && !disconnect) {
		nXfer = recv (sd, pBuffer, nRemainRecv, 0);
		if (nXfer == SOCKET_ERROR) 
			ReportError (_T("Nieudane wywolanie funkcji recv()."), 12, TRUE);
		disconnect = (nXfer == 0);
		nRemainRecv -=nXfer; pBuffer += nXfer;
	}

	return disconnect;
}

BOOL SendResponseMessage (RESPONSE *pResponse, SOCKET sd)
{
	BOOL disconnect = FALSE;
	LONG32 nRemainRecv = 0, nXfer, nRemainSend;
	LPBYTE pBuffer;

	/*	Wysyanie odpowiedzi (do koca acucha). Wysyanie w dwch 
		czciach - najpierw nagwek, nastpnie acuch z odpowiedzi. */
	nRemainSend = RS_HEADER_LEN; 
	pResponse->rsLen = (long)(strlen (pResponse->record)+1);
	pBuffer = (LPBYTE)pResponse;
	while (nRemainSend > 0 && !disconnect) {
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wywolanie funkcji send() na serwerze."), 13, TRUE);
		disconnect = (nXfer == 0);
		nRemainSend -=nXfer; pBuffer += nXfer;
	}

	nRemainSend = pResponse->rsLen;
	pBuffer = (LPSTR)pResponse->record;
	while (nRemainSend > 0 && !disconnect) {
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wywolanie funkcji send() na serwerze."), 14, TRUE);
		disconnect = (nXfer == 0);
		nRemainSend -=nXfer; pBuffer += nXfer;
	}
	return disconnect;
}
