/* Rozdzia 12. commands.c									*/
/* OSTRZEENIE: POLECENIA NIE OBSUGUJ KODOWANIA UNICODE			*/
/*															*/
/* Polecenia "serwera wewntrzprocesowego" uywane w programie serverSK itd.*/
/*                                     */
/* Istnieje kilka polece zaimplementowanych jako biblioteki DLL. */
/* Funkcja do obsugi kadego polecenia musi by bezpieczna ze wzgldu na wtki */
/* i przyjmowa dwa parametry. Pierwszy z nich to acuch znakw: */
/* polecenie arg1 arg2 ... argn (jest to OGRANICZONY wiersz polece */
/* bez odstpw i cudzysoww w poleceniu lub argumentach). */
/* Drugi parametr to nazwa pliku na dane wyjciowe. */
/* Kod jest napisany w jzyku C bez nazw z dekoracjami. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

static void ExtractToken (int, char *, char *);

__declspec (dllexport)
int __cdecl wcip (char * command, char * output_file)
/* Zliczanie sw w procesie (TYLKO DLA JEDNEGO PLIKU). */
/* Zliczanie znakw, sw i wierszy w pliku */
/* podanym jako drugi element w poleceniu. */
/* UWAGA: jest to prosta wersja; moe zwraca wyniki inne ni program wc. */
/* Ta wersja NIE umoliwia wspuytkowania plikw wejciowych i wyjciowych 
   z uwagi na korzystanie z funkcji fopen_s. */ 
{
	FILE * fIn, *fOut;
	int ch, c, nl, nw, nc;
	char inputFile[256];
	
	ExtractToken (1, command, inputFile);
			
	if (fopen_s (&fIn, inputFile, "r") != 0) return 1;
	
	ch = nw = nc = nl = 0;
	while ((c = fgetc (fIn)) != EOF) {
		if (c == '\0') break;
		if (isspace(c) && isalpha(ch))
			nw++;
		ch = c;
		nc++;
		if (c == '\n')
			nl++;
	}
	fclose (fIn);

	/* Zapisywanie wynikw. */
	if (fopen_s (&fOut, output_file, "w") != 0) return 2;
	fprintf (fOut, " %9d %9d %9d %s\n", nl, nw, nc, inputFile);	
	fclose (fOut);
	return 0;
}

__declspec (dllexport)
int __cdecl toupperip (char * command, char * output_file)
/* Przeksztacanie liter w danych wyjciowych na due (w procesie). */
/* Plik wejciowy to drugi element polecenia (pierwszy to toupperip). */
{
	FILE * fIn, *fOut;
	int c;
	char inputFile[256];
	
	ExtractToken (1, command, inputFile);
			
	if (fopen_s (&fIn, inputFile, "r") != 0) return 1;
	if (fopen_s (&fOut, output_file, "w") != 0) return 2;
	
	while ((c = fgetc (fIn)) != EOF) {
		if (c == '\0') break;
		if (isalpha(c)) c = toupper(c);
		fputc  (c, fOut);	
	}
	fclose (fIn);
	fclose (fOut);	
	return 0;
}

static void ExtractToken (int it, char * command, char * token)
{
    /* Wyodrbnianie elementu o numerze it (pierwszy element ma numer 0) */
    /* z parametru command. Wyniki trafiaj do parametru token. */
    /* Elementy s rozdzielone odstpami. */

	int i;
	size_t tlen;
	char *pc, *pe, *ws = " \t\n"; /* Odstp. */
	
	/* Pominicie pierwszych "it" elementw.	*/
	
	pc = command;
	tlen = strlen(command);
	pe = pc + tlen;
	for (i = 0; i < it && pc < pe; i++) {
		pc += strcspn (pc, ws); /* Dodawanie dugoci nastpnego elementu. */
			/* pc wskazuje pocztek pola z odstpem. */
		pc += strspn (pc, ws); /* Dodawanie dugoci pola z odstpem. */
	}
	/* pc wskazuje teraz pocztek elementu. */
	tlen = strcspn (pc, ws);
	memcpy (token, pc, (int)tlen);
	token[tlen] = '\0';

	return;
}