/* Rozdzia 12. clientSKST.c										       */
/* Jednowtkowy klient uruchamiany w wierszu polece.                      */
/* WERSJA OPARTA NA GNIAZDACH SYSTEMU WINDOWS.                             */
/* Rni si od clientSK.c tylko tym, e funkcje do wysyania i odbierania */
/* komunikatw znajduj si w bibliotece DLL oraz maj inne nazwy.         */
/* Wczytuje sekwencj polece wysyanych do procesu serwera przez          */
/* poczenie oparte na gniedzie. Oczekuje na odpowied i wywietla j.   */

/* Ten program ilustruje:
	1. Gniazda systemu Windows po stronie klienta.
	2. Krtkotrwae poczenia z jednym daniem, ale wieloma odpowiedziami.
	3. Wczytywanie odpowiedzi z komunikatw serwera do czasu zerwania poczenia przez serwer. */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicje rekordw da i odpowiedzi. */

static BOOL ReceiveResponseMessage (RESPONSE *, SOCKET);

__declspec (dllimport) BOOL SendCSMessage (REQUEST *, SOCKET);
__declspec (dllimport) BOOL ReceiveCSMessage (RESPONSE *, SOCKET);

struct sockaddr_in clientSAddr;		/* Struktura adresu gniazda klienta. */

int _tmain (int argc, LPTSTR argv [])
{
	SOCKET clientSock = INVALID_SOCKET;
	REQUEST request;	/* Zobacz clntcrvr.h */
	RESPONSE response;	/* Zobacz clntcrvr.h */
	WSADATA WSStartData;				/* Struktura danych z biblioteki do obsugi gniazd.   */

	BOOL quit = FALSE;
	DWORD conVal, j;
	TCHAR promptMsg [] = _T("\nWpisz polecenie> "), Req[MAX_RQRS_LEN];
	TCHAR quitMsg [] = _T("$koniec"); /* danie zamknicia klienta. */
	TCHAR shutMsg [] = _T("$ShutDownServer"); /* Zatrzymuje wszystkie wtki. */
	CHAR defaultIPAddr[] = "127.0.0.1";

	/*	Inicjowanie biblioteki WS, wersja 2.0. */
	if (WSAStartup (MAKEWORD (2, 0), &WSStartData) != 0)
		ReportError (_T("Brak obslugi gniazd."), 1, TRUE);
		
	/* Nawizywanie poczenia z serwerem. */
    /* Naley przestrzega standardowej dla klienta kolejnoci wywoa - socket-connect. */
	clientSock = socket(AF_INET, SOCK_STREAM, 0);
	if (clientSock == INVALID_SOCKET)
		ReportError (_T("Nieudane wywolanie funkcji socket() w kliencie."), 2, TRUE);

	memset (&clientSAddr, 0, sizeof(clientSAddr));    
	clientSAddr.sin_family = AF_INET;	
	if (argc >= 2) 
		clientSAddr.sin_addr.s_addr = inet_addr (argv[1]); 
	else
		clientSAddr.sin_addr.s_addr = inet_addr (defaultIPAddr);

	clientSAddr.sin_port = htons(SERVER_PORT);

	conVal = connect (clientSock, (struct sockaddr *)&clientSAddr, sizeof(clientSAddr));
	if (conVal == SOCKET_ERROR) ReportError (_T("Nieudane wywolanie funkcji connect() w kliencie."), 3, TRUE);

	/*  Gwna ptla wywietla instrukcj dla uytkownika, wysya danie i odbiera odpowied. */
	while (!quit) {
		_tprintf (_T("%s"), promptMsg); 
		/* Uniwersalne wejcie, ale polecenie do serwera musi by zapisane w ASCII. */
		_fgetts (Req, MAX_RQRS_LEN-1, stdin);
		for (j = 0; j <= _tcslen(Req); j++) request.record[j] = Req[j];
		/* Usuwanie znaku nowego wiersza na kocu. */
		request.record[strlen(request.record)-1] = '\0';
		if (strcmp (request.record, quitMsg) == 0 ||
			strcmp (request.record, shutMsg) == 0) quit = TRUE;
		SendCSMessage (&request, clientSock);
		ReceiveResponseMessage (&response, clientSock);
	}

	shutdown (clientSock, 2); /* Uniemoliwianie wysyania i odbierania. */
	closesocket (clientSock);
	WSACleanup();
	_tprintf (_T("\n****Zamykanie klienta\n"));
	return 0;
}

BOOL ReceiveResponseMessage (RESPONSE *pResponse, SOCKET sd)
{	
	BOOL disconnect = FALSE, lastRecord = FALSE;

	/*  Odczyt rekordw odpowiedzi - moe by ich kilka.
		Kady z nich jest wywietlany w standardowym wyjciu. */
	/*  Komunikaty obejmuj znaki 8-bitowe. */
		
	while (!lastRecord) {
		disconnect = ReceiveCSMessage (pResponse, sd);
		/* Wykrywanie ostatniego komunikatu. */
		/* Arbitralnie zdefiniowany jako "$$$$$$$". */
		lastRecord = (strcmp (pResponse->record, "$$$$$$$") == 0);
		if (!disconnect && !lastRecord) 
			printf ("%s", pResponse->record);
	}
	return disconnect;	
}
