/* Rozdzia 12. clientSK.c										*/
/* Jednowtkowy klient uruchamiany w wierszu polece. */
/* WERSJA OPARTA NA GNIAZDACH SYSTEMU WINDOWS. */
/* Wczytuje sekwencj polece wysyanych do procesu serwera przez */
/* poczenie oparte na gniedzie. Oczekuje na odpowied i wywietla j. */

/* Ten program ilustruje:
	1. Gniazda systemu Windows po stronie klienta.
	2. Krtkotrwae poczenia z jednym daniem, ale wieloma odpowiedziami.
	3. Wczytywanie odpowiedzi z komunikatw serwera do czasu zerwania poczenia przez serwer. */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicje rekordw da i odpowiedzi. */

static BOOL SendRequestMessage (REQUEST *, SOCKET);
static BOOL ReceiveResponseMessage (RESPONSE *, SOCKET);

struct sockaddr_in clientSAddr;		/* Struktura adresu gniazda klienta. */

int _tmain (int argc, LPSTR argv[])
{
	SOCKET clientSock = INVALID_SOCKET;
	REQUEST request;	/* Zobacz clntcrvr.h */
	RESPONSE response;	/* Zobacz clntcrvr.h */
#ifdef WIN32					/* wiczenie: czy potrafisz przenie ten kod na UNIX-a?
								 * Czy wystpuj inne zalenoci systemowe? */
	WSADATA WSStartData;				/* Struktura danych z biblioteki do obsugi gniazd.   */
#endif
	BOOL quit = FALSE;
	DWORD conVal;
	/*	Inicjowanie biblioteki WS, wersja 2.0. */
#ifdef WIN32
	if (WSAStartup (MAKEWORD (2, 0), &WSStartData) != 0)
		ReportError (_T("Brak obslugi gniazd."), 1, TRUE);
#endif		
	/* Nawizywanie poczenia z serwerem. */
    /* Naley przestrzega standardowej dla klienta kolejnoci wywoa - socket-connect. */
	clientSock = socket(AF_INET, SOCK_STREAM, 0);
	if (clientSock == INVALID_SOCKET)
		ReportError (_T("Nieudane wywolanie funkcji socket() w kliencie."), 2, TRUE);

	memset (&clientSAddr, 0, sizeof(clientSAddr));    
	clientSAddr.sin_family = AF_INET;	
	if (argc >= 2) 
		clientSAddr.sin_addr.s_addr = inet_addr (argv[1]); 
	else
		clientSAddr.sin_addr.s_addr = inet_addr ("127.0.0.1");

	clientSAddr.sin_port = htons(SERVER_PORT);

	conVal = connect (clientSock, (struct sockaddr *)&clientSAddr, sizeof(clientSAddr));
	if (conVal == SOCKET_ERROR) ReportError (_T("Nieudane wywoanie funkcji connect() w kliencie."), 3, TRUE);

	/*  Gwna ptla wywietla instrukcj dla uytkownika, wysya danie i odbiera odpowied. */
	while (!quit) {
		_tprintf (_T("%s"), _T("\nWpisz polecenie: ")); 
		_fgetts (request.record, MAX_RQRS_LEN-1, stdin); 
		/* Usuwanie znaku nowego wiersza na kocu. */
		/* Komunikaty skadaj si ze znakw 8-bitowych. */
		request.record[strlen(request.record)-1] = '\0';
		if (strcmp (request.record, "$Koniec") == 0) quit = TRUE;
		SendRequestMessage (&request, clientSock);
		if (!quit) ReceiveResponseMessage (&response, clientSock);
	}

	shutdown (clientSock, SD_BOTH); /* Uniemoliwianie wysyania i odbierania. */
#ifdef WIN32
	closesocket (clientSock);
	WSACleanup();
#else
	close (clientSock);
#endif
	_tprintf (_T("\n****Zamykanie klienta\n"));
	return 0;
}


BOOL SendRequestMessage (REQUEST *pRequest, SOCKET sd)
{
	/* Wysyanie dania do serwera do gniazda sd. */
	BOOL disconnect = FALSE;
	LONG32 nRemainSend, nXfer;
	LPBYTE pBuffer;

	/* danie skada si z dwh czci - nagwka i acucha z poleceniem. */
	
	nRemainSend = RQ_HEADER_LEN; 
	pRequest->rqLen = (DWORD)(strlen (pRequest->record) + 1);
	pBuffer = (LPBYTE)pRequest;
	while (nRemainSend > 0 && !disconnect)  {
		/* Funkcja send nie gwarantuje, e cay komunikat zostanie przesany. */
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wywoanie funkcji send() u klienta."), 4, TRUE);
		disconnect = (nXfer == 0);
		nRemainSend -=nXfer; pBuffer += nXfer;
	}

	nRemainSend = pRequest->rqLen; 
	pBuffer = (LPBYTE)pRequest->record;
	while (nRemainSend > 0 && !disconnect)  {
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wywoanie funkcji send() u klienta."), 5, TRUE);
		disconnect = (nXfer == 0);
		nRemainSend -=nXfer; pBuffer += nXfer;
	}
	return disconnect;
}


BOOL ReceiveResponseMessage (RESPONSE *pResponse, SOCKET sd)
{
	BOOL disconnect = FALSE, LastRecord = FALSE;
	LONG32 nRemainRecv, nXfer;
	LPBYTE pBuffer;

	/*  Odczyt rekordw odpowiedzi - moe by ich kilka.
		Kady z nich jest wywietlany w standardowym wyjciu. */

	/*	Odczyt kadej odpowiedzi i wysyanie jej do standardowego wyjcia. 
		Najpierw nagwek rekordu, a nastpnie pozostaa cz. */
		
	while (!LastRecord) {
		/*  Odczyt nagwka. */
		nRemainRecv = RS_HEADER_LEN; pBuffer = (LPBYTE)pResponse;
		while (nRemainRecv > 0 && !disconnect) {
			nXfer = recv (sd, pBuffer, nRemainRecv, 0);
			if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wczytywanie naglowka u klienta."), 6, TRUE);
			disconnect = (nXfer == 0);
			nRemainRecv -=nXfer; pBuffer += nXfer;
		}
		/*	Odczyt rekordu z odpowiedzi. */
		nRemainRecv = pResponse->rsLen;
		/* Wykluczanie bdu przepenienia bufora. */
		nRemainRecv = min(nRemainRecv, MAX_RQRS_LEN);
		LastRecord = (nRemainRecv <= 1);  /* Uwzgldniany jest kocowy znak pusty. */
		pBuffer = (LPBYTE)pResponse->record;
		while (nRemainRecv > 0 && !disconnect) {
			nXfer = recv (sd, pBuffer, nRemainRecv, 0);
			if (nXfer == SOCKET_ERROR) ReportError (_T("Nieudane wczytywanie odpowiedzi u klienta."), 7, TRUE);
			disconnect = (nXfer == 0);
			nRemainRecv -=nXfer; pBuffer += nXfer;
		}
	
		if (!disconnect) 
			_tprintf (_T("%s"), pResponse->record);
	}
	return disconnect;	
}
