/* SendReceiveSKST.c  rozdzia 12. Wielowtkowa biblioteka DLL do strumieniowego przesyania danych do gniazd. */
/* Komunikaty s ograniczone znakami pustymi ('\0'), */
/* dlatego dugo wiadomoci nie jest z gry znana. Przychodzce dane */
/* s zapisywane w buforze i zachowywane midzy wywoaniami */
/* funkcji. Dlatego naley uy pamici TLS, aby */
/* kady wtek mia wasn prywatn pami statyczn. */
/*  OSTRZEENIE: komunikaty obejmuj tylko znaki 8-bitowe. Nie wolno uywa znakw 16-bitowych.	*/
/*	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicj rekordw MESSAGE. */

typedef struct STATIC_BUF_T {
/* Skadowa staticBuf obejmuje staticBufLen znakw fragmentarycznych danych. */
/* Wrd nich mog (cho nie musz) znajdowa si znaki puste oznaczajce koniec acucha. */
	char staticBuf[MAX_RQRS_LEN];
	LONG32 staticBufLen;
} STATIC_BUF;

static DWORD tlsIndex = TLS_OUT_OF_INDEXES; /* Inicjowanie indeksu pamici TLS. */
/*	W bibliotece jednowtkowej naley uy nastpujcych zmiennych:
static char staticBuf[MAX_RQRS_LEN];
static LONG32 staticBufLen;
*/

/* Liczba doczonych i odczonych wtkw oraz procesw. */
static volatile long nPA = 0, nTA = 0, nPD = 0, nTD = 0;

/* Funkcja gwna biblioteki DLL. */
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	STATIC_BUF * pBuf; 

	switch (fdwReason) {
		case DLL_PROCESS_ATTACH:
			tlsIndex = TlsAlloc();
			InterlockedIncrement (&nPA); /* Przesada, poniewa wywoania funkcji DllMain s serializowane. */
			/*	Nie ma wywoa doczenia dla innych wtkw utworzonych 
               PRZED wczytaniem tej biblioteki DLL. Operacje doczania wtkw
               naley przeprowadzi w czasie doczania procesu. T bibliotek DLL
               trzeba wczyta przed utworzeniem wtkw, ktre z niej korzystaj. */

		case DLL_THREAD_ATTACH:
			/* Informuje, e nie zaalokowano pamici. */
			InterlockedIncrement (&nTA); /* Wczeniej istniejce wtki nie s uwzgldniane. */
			/* TlsSetValue (tlsIndex, NULL); - niekonieczne; sloty s inicjowane wartoci 0. */
			return TRUE; /* Ta warto jest ignorowana. */

		case DLL_PROCESS_DETACH:
		/* Zwalnianie pozostaych zasobw uywanych przez t bibliotek DLL. 
               Niektre biblioteki DLL dla wtkw mogy nie zosta wywoane. */
			InterlockedIncrement (&nPD);
			/* Odcza take wtek gwny. */

			InterlockedIncrement (&nTD);
			pBuf = TlsGetValue (tlsIndex);
			if (pBuf != NULL) {
				free (pBuf);
				pBuf = NULL;
			}

			_tprintf (_T("Odczanie procesu. Liczniki: %d %d %d %d\n"), nPA, nPD, nTA, nTD);
			TlsFree(tlsIndex);
			return TRUE;

		case DLL_THREAD_DETACH:
			/* Moe nie zosta wywoana dla kadego wtku korzystajcego z tej biblioteki DLL. */
			InterlockedIncrement (&nTD);
			pBuf = TlsGetValue (tlsIndex);
			if (pBuf != NULL) {
				free (pBuf);
				pBuf = NULL;
			}
			return TRUE;

		default: return TRUE;
	}
}


__declspec(dllexport)
BOOL ReceiveCSMessage (MESSAGE *pMsg, SOCKET sd)
{
	/* Zwrcona warto FALSE oznacza bd lub zerwanie poczenia. */
	BOOL disconnect = FALSE;
	LONG32 nRemainRecv, nXfer, k; /* Trzeba uy liczb cakowitych ze znakiem. */
	LPBYTE pBuffer, message;
	CHAR tempBuff[MAX_MESSAGE_LEN+1];
	STATIC_BUF *pBuff;

	if (pMsg == NULL) return FALSE;
	pBuff = (STATIC_BUF *) TlsGetValue (tlsIndex);
	if (pBuff == NULL) { /* Pierwsze inicjowanie. */
		/* Pami t alokuj tylko te wtki, ktre jej potrzebuj. */
		pBuff = malloc (sizeof (STATIC_BUF));
		if (pBuff == NULL) return FALSE; /* Bd. */
		TlsSetValue (tlsIndex, pBuff); 
		pBuff->staticBufLen = 0; /* Inicjowanie stanu. */
	}

	message = pMsg->record; /* dania i odpowiedzi s oparte na tej samej strukturze. */
	/*	Wczytywanie do czasu natrafienia na znak pusty i pozostawienie 
     * fragmentarycznych danych w statycznym buforze. */

	for (k = 0; k < pBuff->staticBufLen && pBuff->staticBuf[k] != '\0'; k++) {
		message[k] = pBuff->staticBuf[k];
	}  /* k to liczba przesanych znakw. */
	if (k < pBuff->staticBufLen) { /* W buforze znaleziono znak pusty. */
		message[k] = '\0'; 
		pBuff->staticBufLen -= (k+1); /* Dostosowanie stanu bufora. */
		memcpy (pBuff->staticBuf, &(pBuff->staticBuf[k+1]), pBuff->staticBufLen);
		return TRUE; /* Nie trzeba przesya danych wejciowych do gniazda. */
	} 
	
	/* Przesano ca zawarto statycznego bufora. Nie znaleziono znaku pustego. */
	nRemainRecv = sizeof(tempBuff) - sizeof(CHAR) - pBuff->staticBufLen; 
	pBuffer = message + pBuff->staticBufLen;
	pBuff->staticBufLen = 0;

	while (nRemainRecv > 0 && !disconnect) {
		nXfer = recv (sd, tempBuff, nRemainRecv, 0);
		if (nXfer <= 0) {
			disconnect = TRUE;
			continue;
		}

		/* Dodawanie danych do docelowego komunikatu do miejsca wystpienia znaku pustego (jeli go znaleziono). */
		for (k = 0; k < nXfer && tempBuff[k] != '\0'; k++) {
			*pBuffer = tempBuff[k];
			nRemainRecv -= nXfer; pBuffer++;
		}
		if (k < nXfer) { /* Znaleziono znak pusty. */
			*pBuffer = '\0';
			nRemainRecv = 0;
			/* Dostosowanie stanu statycznego bufora pod ktem
             * nastpnego wywoania funkcji ReceiveCSMessage. */
			memcpy (pBuff->staticBuf, &tempBuff[k+1], nXfer - k - 1);
			pBuff->staticBufLen = nXfer -k - 1;
		}
	}
	return !disconnect;	
}


__declspec(dllexport)
BOOL SendCSMessage (MESSAGE *pMsg, SOCKET sd)
{
	/* Wysyanie dania do gniazda sd na serwerze. */
	BOOL disconnect = FALSE;
	LONG32 nRemainSend, nXfer;
	LPBYTE pBuffer;

	if (pMsg == NULL) return FALSE;
	pBuffer = pMsg->record;
	if (pBuffer == NULL) return FALSE;
	nRemainSend = min(strlen (pBuffer) + 1, MAX_MESSAGE_LEN);

	while (nRemainSend > 0 && !disconnect)  {
		/* Funkcja send nie gwarantuje, e cay komunikat zostanie przesany. */
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer <= 0) {
			disconnect = TRUE;
		}
		nRemainSend -=nXfer; pBuffer += nXfer;
	}

	return !disconnect;
}
