/*	SendReceiveSKHA.c - rozdzia 12. Wielowtkowe gniazdo do strumieniowego przesyania danych.		*/
/* Jest to zmodyfikowana wersja programu SendReceiveSKST.c. Ilustruje ona */
/* inn technik tworzenia bibliotek bezpiecznych ze wzgldu na wtki. */
/* Stan jest tu przechowywany w podobnej do uchwytu strukturze, a nie za pomoc */
/* pamici TLS. Umoliwia to wtkom jednoczesne korzystanie z kilku gniazd. */
/* Komunikaty s ograniczone znakami pustymi ('\0'). */
/*	Dugo komunikatu nie jest z gry znana, dlatego dane s umieszczane	*/
/*	w buforze i trzeba je zapisywa midzy kolejnymi wywoaniami funkcji.	*/
/*	Dlatego trzeba uy struktury dla kadego gniazda. 	*/
/*	Gniazda maj wasn prywatn "pami statyczn".	*/
/*  OSTRZEENIE: komunikaty zawieraj tylko 8-bitowe znaki. Bez znakw 16-bitowych.	*/
/*	* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "Everything.h"
#include "ClientServer.h"	/* Zawiera definicj struktury MESSAGE. */

typedef struct SOCKET_HANDLE_T {
/* Okrela obecny stan gniazda. */
/* Obejmuje staticBuffLen znakw fragmentarycznych danych. */
/* Mog one (cho nie musz) zawiera puste znaki koca acucha. */
	SOCKET sk;
	char staticBuff[MAX_RQRS_LEN];
	LONG32 staticBuffLen;
} SOCKET_HANDLE, * PSOCKET_HANDLE;

/*	Funkcje do tworzenia i zamykania uchwytw gniazd do strumieniowego przesyania danych. */
__declspec (dllexport)
PVOID CreateCSSocketHandle (SOCKET s)
{
	PVOID p;
	PSOCKET_HANDLE ps;

	p = malloc (sizeof(SOCKET_HANDLE));
	if (p == NULL) return NULL;
	ps = (PSOCKET_HANDLE)p;
	ps->sk = s;
	ps->staticBuffLen = 0; /* Inicjowanie stanu bufora. */
	return p;
}

__declspec (dllexport)
BOOL CloseCSSocketHandle (PSOCKET_HANDLE psh)
{
	if (psh == NULL) return FALSE;
	free (psh);
	return TRUE;
}


__declspec(dllexport)
BOOL ReceiveCSMessage (MESSAGE *pMsg, PSOCKET_HANDLE psh)
/*  Mona uy wskanika PVOID, aby do programu wywoujcego nie trzeba byo */
/* docza definicji uchwytw SOCKET_HANDLE. */
{
	/* Zwrcona warto TRUE oznacza bd lub zerwanie poczenia. */
	BOOL disconnect = FALSE;
	LONG32 nRemainRecv = 0, nXfer, k; /* Trzeba uy liczb cakowitych ze znakiem. */
	LPSTR pBuffer, message;
	CHAR tempBuff[MAX_RQRS_LEN+1];
	SOCKET sd;

	if (psh == NULL) return FALSE; 
	sd = psh->sk;

	/* To wszystkie zmiany w porwnaniu z programem SendReceiveSKST! */

	message = pMsg->record; /* dania i odpowiedzi s oparte na tej samej strukturze. */
	/*	Wczytywanie do czasu napotkania znaku pustego i pozostawianie
     * fragmentarycznych danych w statycznym buforze. */

	for (k = 0; k < psh->staticBuffLen && psh->staticBuff[k] != '\0'; k++) {
		message[k] = psh->staticBuff[k];
	}  /* k to liczba przesanych znakw. */
	if (k < psh->staticBuffLen) { /* W buforze znaleziono znak pusty. */
		message[k] = '\0'; 
		psh->staticBuffLen -= (k+1); /* Dostosowanie stanu bufora. */
		memcpy (psh->staticBuff, &(psh->staticBuff[k+1]), psh->staticBuffLen);
		return TRUE; /* Nie jest potrzebne przekazywanie danych wejciowych do gniazda. */
	} 
	
	/* Przekazano ca zawarto statycznego bufora. Nie znaleziono znaku koca wiersza. */
	nRemainRecv = sizeof(tempBuff) - 1 - psh->staticBuffLen; 
	pBuffer = message + psh->staticBuffLen;
	psh->staticBuffLen = 0;

	while (nRemainRecv > 0 && !disconnect) {
		nXfer = recv (sd, tempBuff, nRemainRecv, 0);
		if (nXfer <= 0) {
			disconnect = TRUE;
			continue;
		}

		nRemainRecv -=nXfer;
		/* Przekazywanie do docelowego komunikat do miejsca wystpienia znaku pustego (jeli go znaleziono). */
		for (k = 0; k < nXfer && tempBuff[k] != '\0'; k++) {
			*pBuffer = tempBuff[k];
			pBuffer++;
		}
		if (k >= nXfer) { /* Nie znaleziono znaku pustego  kontynuowanie odczytu. */
			nRemainRecv -= nXfer;
		} else { /* Znaleziono znak pusty. */
			*pBuffer = '\0';
			nRemainRecv = 0;
			memcpy (psh->staticBuff, &tempBuff[k+1], nXfer - k - 1);
			psh->staticBuffLen = nXfer -k - 1;
		}
	}
	return !disconnect;	
}


__declspec(dllexport)
BOOL SendCSMessage (MESSAGE *pMsg, PSOCKET_HANDLE psh)
{
	/* Wysyanie dania do gniazda sd na serwerze. */
	BOOL disconnect = FALSE;
	LONG32 nRemainSend, nXfer;
	LPSTR pBuffer;
	SOCKET sd;

	if (psh == NULL || pMsg == NULL) return FALSE;
	sd = psh->sk;

	pBuffer = pMsg->record;
	nRemainSend = (LONG32)(min(strlen (pBuffer) + 1, MAX_MESSAGE_LEN));

	while (nRemainSend > 0 && !disconnect)  {
		/* Funkcja send nie gwarantuje przesania caego komunikatu. */
		nXfer = send (sd, pBuffer, nRemainSend, 0);
		if (nXfer <= 0) {
			disconnect = TRUE;
		}
		nRemainSend -=nXfer; pBuffer += nXfer;
	}

	return !disconnect;
}
