/*  Rozdzia 11. ServerNP.
 *	Wielowtkowy serwer do przetwarzania wiersza polece. Wersja z potokami nazwanymi.
 *	Stosowanie:	Server [nazwaUzytkownika nazwaGrupy]
 *	JEDEN WTEK I EGZEMPLARZ POTOKU DLA KADEGO KLIENTA. */

#include "Everything.h"
#include "ClientServer.h" /* Definicje komunikatw z daniem i odpowiedzi. */

typedef struct {				/* Argument wtku serwera. */
	HANDLE hNamedPipe;			/* Egzemplarz potoku nazwanego. */
	DWORD threadNumber;
	TCHAR tempFileName[MAX_PATH]; /* Nazwa pliku tymczasowego. */
} THREAD_ARG;
typedef THREAD_ARG *LPTHREAD_ARG;

volatile static int shutDown = 0;
static DWORD WINAPI Server (LPTHREAD_ARG);
static DWORD WINAPI Connect (LPTHREAD_ARG);
static DWORD WINAPI ServerBroadcast (LPLONG);
static BOOL  WINAPI Handler (DWORD);
static TCHAR shutRequest[] = _T("$ShutDownServer");
static THREAD_ARG threadArgs[MAX_CLIENTS];

_tmain (int argc, LPTSTR argv[])
{
	/* Warto MAX_CLIENTS jest zdefiniowana w pliku ClientServer.h. */
    /* W wtku gwnym do oczekiwania na wtki serwera uyto funkcji */
    /* WaitForMultipleObjects z ograniczeniem do MAXIMUM_WAIT_OBJECTS obiektw. */


	HANDLE hNp, hMonitor, hSrvrThread[MAX_CLIENTS];
	DWORD iNp, monitorId, threadId;
	DWORD AceMasks[] =	/* Uprawnienia dostpu do potoku nazwanego (opisane w rozdziale 15.). */
		{STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0X1FF, 0, 0 };
	LPSECURITY_ATTRIBUTES pNPSA = NULL;

	if (!WindowsVersionOK (6, 0)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 6.0 lub nowszego."), 1, FALSE);

	/* Procedura sterujca konsoli umoliwiajca zamknicie serwera. */
	if (!SetConsoleCtrlHandler (Handler, TRUE))
		ReportError (_T("Nie mozna utworzyc procedury sterujacej."), 1, TRUE);

	/* Zabezpieczenia potoku dla uproszczenia umieszczono w komentarzach. */
//	if (argc == 4)		
//		pNPSA = InitializeAccessOnlySA (0440, argv[1], argv[2], AceMasks, &hSecHeap);
			
	/* Tworzenie wtku do okresowego rozpowszechniania nazwy potoku. */
	hMonitor = (HANDLE) _beginthreadex (NULL, 0, ServerBroadcast, NULL, 0, &monitorId);

	/*	Tworzenie egzemplarza potoku dla kadego wtku serwera.
     * Tworzenie nazwy pliku tymczasowego dla kadego wtku.
     * Tworzenie wtku do obsugi danego potoku. */

	for (iNp = 0; iNp < MAX_CLIENTS; iNp++) {
		hNp = CreateNamedPipe ( SERVER_PIPE, PIPE_ACCESS_DUPLEX,
				PIPE_READMODE_MESSAGE | PIPE_TYPE_MESSAGE | PIPE_WAIT,
				MAX_CLIENTS, 0, 0, INFINITE, pNPSA);

		if (hNp == INVALID_HANDLE_VALUE)
			ReportError (_T ("Nieudane otwieranie potoku nazwanego."), 1, TRUE);
		threadArgs[iNp].hNamedPipe = hNp;
		threadArgs[iNp].threadNumber = iNp;
		GetTempFileName (_T ("."), _T ("CLP"), 0, threadArgs[iNp].tempFileName);
		hSrvrThread[iNp] = (HANDLE)_beginthreadex (NULL, 0, Server,
				&threadArgs[iNp], 0, &threadId);
		if (hSrvrThread[iNp] == NULL)
			ReportError (_T ("Nieudane tworzenie watku serwera."), 2, TRUE);
	}
	
	/* Oczekiwanie na zakoczenie dziaania przez wszystkie wtki. */

	WaitForMultipleObjects (MAX_CLIENTS, hSrvrThread, TRUE, INFINITE);
	_tprintf (_T ("Wszystkie watki serwera zakonczyly prace.\n"));

	WaitForSingleObject (hMonitor, INFINITE);
	_tprintf (_T ("Watek monitorujacy zakonczyl prace.\n"));

	CloseHandle (hMonitor);
	for (iNp = 0; iNp < MAX_CLIENTS; iNp++) { 
		/* Zamykanie uchwytw potoku i usuwanie plikw tymczasowych. */
        /* Zamykanie plikw tymczasowych jest zbdne  robi to wtki robocze. */
		CloseHandle (hSrvrThread[iNp]);
		DeleteFile (threadArgs[iNp].tempFileName);
	}

	_tprintf (_T ("Proces serwera konczy prace.\n"));
	return 0;
}


static DWORD WINAPI Server (LPTHREAD_ARG pThArg)

/* Funkcja wtku serwera. Dla kadego potencjalnego klienta powstaje jeden wtek. */
{
	/* Kady wtek przechowuje na stosie struktury danych 
     * na danie, odpowied i operacje pomocnicze.
     * Ponadto kady wtek tworzy dodatkowy wtek poczenia,
     * aby gwny wtek roboczy mg okresowo sprawdza flag zamknicia
     * w czasie oczekiwania na poczenie z klientem. */


	HANDLE hNamedPipe, hTmpFile = INVALID_HANDLE_VALUE, hConTh = NULL, hClient;
	DWORD nXfer, conThStatus, clientProcessId;
	STARTUPINFO startInfoCh;
	SECURITY_ATTRIBUTES tempSA = {sizeof(SECURITY_ATTRIBUTES), NULL, TRUE};
	PROCESS_INFORMATION procInfo;
	FILE *fp;
	REQUEST request;
	RESPONSE response;
	TCHAR clientName[256];

	GetStartupInfo (&startInfoCh);
	hNamedPipe = pThArg->hNamedPipe;

	while (!shutDown) { 	/* Ptla poczenia. */

		/* Tworzenie wtku poczenia i oczekiwanie na zakoczenie jego dziaania. */
		/* Naley uy limitu czasu, aby mona byo przetestowa flag zamykania. */
		hConTh = (HANDLE)_beginthreadex (NULL, 0, Connect, pThArg, 0, NULL);
		if (hConTh == NULL) {
			ReportError (_T("Nie mozna utworzyc watku polaczenia."), 0, TRUE);
			_endthreadex(2);
		}

		/* Oczekiwanie na poczenie z klientem. */	
		while (!shutDown && WaitForSingleObject (hConTh, CS_TIMEOUT) == WAIT_TIMEOUT) 
			{ /* Puste ciao ptli. */};
		if (shutDown) _tprintf (_T("Watek %d otrzymal polecenie zamkniecia.\n"), pThArg->threadNumber);
		if (shutDown) continue;	/* Flag mona ustawi take w innych wtkach. */

		CloseHandle (hConTh); hConTh = NULL;
		/* Poczenie jest ju nawizane. */
        
		if (!GetNamedPipeClientComputerName(pThArg->hNamedPipe, clientName, sizeof(clientName))) {
			_tcscpy_s(clientName, sizeof(clientName)/sizeof(TCHAR)-1, _T("localhost"));
		}
        GetNamedPipeClientProcessId(pThArg->hNamedPipe, &clientProcessId);
		_tprintf(_T("Polaczenie z procesem klienta o identyfikatorze: %d na komputerze: %s\n"), clientProcessId, clientName);
        
		while (!shutDown && ReadFile (hNamedPipe, &request, RQ_SIZE, &nXfer, NULL)) {
			/* Odbieranie nowych polece do czasu zerwania poczenia przez klienta. */
			_tprintf(_T("Polecenie od watku klienta: %d. %s\n"), clientProcessId, request.record);
			shutDown = shutDown || (_tcscmp (request.record, shutRequest) == 0);
			if (shutDown)  continue;

			/* Otwieranie tymczasowego pliku na wyniki uywanego 
			   przez wszystkie poczenia z danym egzemplarzem. */
			hTmpFile = CreateFile (pThArg->tempFileName, GENERIC_READ | GENERIC_WRITE,
				FILE_SHARE_READ | FILE_SHARE_WRITE, &tempSA,
				CREATE_ALWAYS, FILE_ATTRIBUTE_TEMPORARY, NULL);
			if (hTmpFile == INVALID_HANDLE_VALUE) { /* W zasadzie mona tylko zamkn wtek. */
				ReportError (_T("Nie mozna utworzyc pliku tymczasowego."), 0, TRUE);
				_endthreadex(1);
			}

			/* Gwna ptla polecenia. */
			/* Tworzenie procesu do wykonania polecenia. */
			startInfoCh.hStdOutput = hTmpFile;
			startInfoCh.hStdError = hTmpFile;
			startInfoCh.hStdInput = GetStdHandle (STD_INPUT_HANDLE);
			startInfoCh.dwFlags = STARTF_USESTDHANDLES;

			if (!CreateProcess (NULL, request.record, NULL,
				NULL, TRUE, /* Dziedziczenie uchwytw. */
				0, NULL, NULL, &startInfoCh, &procInfo)) {
					PrintMsg (hTmpFile, _T("Blad - nie mozna utworzyc procesu."));
					procInfo.hProcess = NULL;
			}

			CloseHandle(hTmpFile);  /* Proces podrzdny uywa pliku tymczasowego, ale uchwyt procesu nadrzdnego nie jest potrzebny. */
			if (procInfo.hProcess != NULL ) { /* Proces serwera dziaa. */
				CloseHandle (procInfo.hThread);
				WaitForSingleObject (procInfo.hProcess, INFINITE);
				CloseHandle (procInfo.hProcess);
			}
			
			/* Odpowiadanie po jednym wierszu. Wygodnie jest zastosowa w tym
               miejscu dziaajce na wierszach procedury z biblioteki jzyka C. */

			if (_tfopen_s (&fp, pThArg->tempFileName, _T("r")) != 0) {	
				_tprintf (_T("Tymczasowy plik wyjsciowy: %s.\n"), pThArg->tempFileName);
				_tperror (_T("Nieudane otwieranie pliku wyjsciowego."));
				break;  /* Nastpne polecenie. */
			}

			/* Unikanie bdu "ujawniania informacji". */
			/* ZeroMemory(&response, sizeof(response));  */
			while (_fgetts (response.record, MAX_RQRS_LEN, fp) != NULL) {
				response.rsLen = (LONG32)(strlen(response.record) + 1);
				WriteFile (hNamedPipe, &response, response.rsLen + sizeof(response.rsLen), &nXfer, NULL);
			}
			/* Zapisywanie kocowego rekordu. W komunikatach uywane s znaki 8-bitowe, a nie UNICODE. */
			response.record[0] = '\0';
			response.rsLen = 0;
			WriteFile (hNamedPipe, &response, sizeof(response.rsLen), &nXfer, NULL); 

			FlushFileBuffers (hNamedPipe);
			fclose (fp);

		}   /* Koniec gwnej ptli do obsugi polecenia. Pobieranie nastpnej instrukcji. */

		/* Klient zerwa poczenie lub wystpio danie zamknicia. */
        /* Zamknicie poczenia z danym klientem i oczekiwanie na nastpnego. */
		FlushFileBuffers (hNamedPipe);
		DisconnectNamedPipe (hNamedPipe);
	}

	/*  Wymuszanie zamknicia wtku poczenia, jeli wci jest aktywny. */
    if (hConTh != NULL) {
        GetExitCodeThread (hConTh, &conThStatus);
	    if (conThStatus == STILL_ACTIVE) {
		    hClient = CreateFile (SERVER_PIPE, GENERIC_READ | GENERIC_WRITE, 0, NULL,
			    OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		    if (hClient != INVALID_HANDLE_VALUE) CloseHandle (hClient);
		    WaitForSingleObject (hConTh, INFINITE);
        }
	}


/*	Komentarze na temat zamykania wtku poczenia:
	wystpuje problem zwizany z tym, e wtek poczenia moe wci dziaa
	Warto go zamkn, ale nie ma wtedy uporzdkowanego zamykania wtku 
	i nie s wywoywane na przykad punkty wejcia do biblioteki DLL, co moe 
	prowadzi do wyciekania zasobw.
	W tej wersji wtek poczenia zajmuje minimalne zasoby, dlatego nie stanowi problemu
	jednak mona te uy innego podejcia:

	Wtek poczenia mona wznawia przez wykorzystanie serwera jak klienta
	i wywoywanie funkcji CreateFile do nawizywania (bardzo) krtkiego
	poczenia, co umoliwia zamknicie wtku poczenia.

    Niestety, zwizany jest z tym pewien problem. Uyty moe zosta nieodpowiedni
	wtek poczenia. Tu zignorowano ten problem, poniewa wystpuje tylko jeden
	taki wtek.

	Istnieje te jednak kilka innych rozwiza, jednak maj one usterki.
	
	POMYS 1. Zamykanie uchwytu potoku nazwanego. Moe to spowodowa niepowodzenie wywoania ConnectNamedPipe,
	a wtek poczenia moe zakoczy prac. Niestety, funkcja CloseHandle 
	blokuje program, jeli istnieje aktywne wywoanie ConnectNamedPipe.
		CloseHandle (hNamedPipe);  // Nie naley tego robi! Moe to zablokowa program.
	
	POMYS 2. Zamykanie wtku. Problem polega na tym, e punkty wejcia bibliotek DLL
	nie zostan wywoane, co moe prowadzi do wspomnianego wyciakania zasobw.

	UWAGA: punkty wejcia DLL opisano w rozdziale 5., ale na razie ich nie zilustrowano.
	Odpowiedni przykad znajduje si w rozdziale 12.

	POMYS 3. mona anulowa wtki za pomoc wywoa APC (rozdzia 10.).
	Niestety, klient moe nie znajdowa si w stanie oczekiwania z obsug alertw.

*/
	_tprintf (_T("Watek %d konczy prace.\n"), pThArg->threadNumber);
	/* Koniec ptli do przetwarzania polece. Zwalnianie zasobw i wychodzenie z wtku. */
	CloseHandle (hTmpFile); hTmpFile = INVALID_HANDLE_VALUE;
	if (!DeleteFile (pThArg->tempFileName)) {
		ReportError (_T("Nieudane usuwanie pliku tymczasowego."), 0, TRUE);
	}
	_tprintf (_T ("Wychodzenie z watku serwera numer %d.\n"), pThArg->threadNumber);
	return 0;
}


static DWORD WINAPI Connect (LPTHREAD_ARG pThArg)
{
	BOOL fConnect;
	/*	Wtek poczenia umoliwiajcy serwerowi sprawdzanie flagi zamknicia. */
	fConnect = ConnectNamedPipe (pThArg->hNamedPipe, NULL);
	_endthreadex (0);
	return 0;	/* Blokowanie ostrzee kompilatora. */ 
}


static DWORD WINAPI ServerBroadcast (LPLONG pNull)
{
	MS_MESSAGE MsNotify;
	DWORD nXfer, iNp;
	HANDLE hMsFile;

	/* Otwieranie szczeliny pocztowej dla jej klienta. */
	while (!shutDown) { /* Dziaa dopty, dopki istniej wtki serwera. */
		/* Oczekiwanie na otwarcie szczeliny przez nastpnego klienta. */
		Sleep (CS_TIMEOUT);
		/* UWAGA (12 padziernika 2001). Funkcja CreateFile dla szczeliny ustawia uprawnienia GENERIC_WRITE,
		   ale nie GENERIC_READ. GENERIC_READ zadziaa dla Windows NT/2000/XP,
		   ale nie dla Windows 9x/Me. Ten konkretny program nie jest przeznaczony dla
		   systemw 9x/Me, poniewa jest to serwer potoku nazwanego, ale czsto
		   klient szczeliny dziaa w systemie 9x/Me, dlatego nie naley uywa
		   GENERIC_READ przy tworzeniu klienta. */
		hMsFile = CreateFile (MS_CLTNAME, GENERIC_WRITE,
				FILE_SHARE_READ,
				NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if (hMsFile == INVALID_HANDLE_VALUE) continue;

		/* Wysyanie komunikatu do szczeliny. */

		MsNotify.msStatus = 0;
		MsNotify.msUtilization = 0;
		_tcsncpy_s (MsNotify.msName, sizeof(MsNotify.msName)/sizeof(TCHAR), SERVER_PIPE, _TRUNCATE);
		if (!WriteFile (hMsFile, &MsNotify, MSM_SIZE, &nXfer, NULL))
			ReportError (_T ("Blad zapisu serwera szczeliny."), 13, TRUE);
		CloseHandle (hMsFile);
	}

	/* Anulowanie zalegych polece wejica-wyjcia dla potoku. Funkcj CancelIoEx opisano w rozdziale 14. */
	_tprintf (_T("Ustawiona flaga zamkniecia. Anulowanie zaleglych operacji wejscia-wyjscia.\n"));
	
	for (iNp = 0; iNp < MAX_CLIENTS; iNp++) {
		CancelIoEx (threadArgs[iNp].hNamedPipe, NULL);
	}
	_tprintf (_T ("Zamykanie watku monitorujacego.\n"));

	_endthreadex (0);
	return 0;
}


BOOL WINAPI Handler (DWORD CtrlEvent)
{
	/* Zamykanie systemu. */
	_tprintf (_T("W procedurze sterujacej konsoli.\n"));
	InterlockedIncrement(&shutDown);
	return TRUE;
}
