/* Rozdzia 11. System klient-serwer. KLIENT.
	ClientNP - klient oparty na poczeniu. Wersja z potokiem nazwanym. */
/* Wykonywanie wiersza polece (na serwerze) i wywietlanie odpowiedzi. */

/*  Klient nawizuje dugotrwae poczenie z serwerem (zajmujc
    egzemplarz potoku) i wywietla prob o wpisanie
	polecenia do wykonania. */

/* Ten program ilustruje:
	1. Potoki nazwane po stronie klienta. 
	2. Dugotrwae poczenia z pojedynczym daniem, ale wieloma odpowiedziami.
	3. Odczyt odpowiedzi z komunikatw serwera do czasu otrzymania koca odpowiedzi.
*/

/* Specjalne polecenia rozpoznawane przez serwer:
	1. $Statistics - zwraca statystyki na temat wydajnoci.
	2. $ShutDownThread - zamyka wtek serwera.
	3. $koniec - koczy prac klienta. */

#include "Everything.h"
#include "ClientServer.h" /* Obejmuje definicje rekordw dania i odpowiedzi. */

int _tmain (int argc, LPTSTR argv [])
{
	HANDLE hNamedPipe = INVALID_HANDLE_VALUE;
	TCHAR quitMsg [] = _T ("$koniec");
	TCHAR serverPipeName [MAX_PATH+1];
	REQUEST request;		/* Zobacz ClientServer.h. */
	RESPONSE response;		/* Zobacz ClientServer.h. */
	DWORD nRead, nWrite, npMode = PIPE_READMODE_MESSAGE | PIPE_WAIT;

	LocateServer (serverPipeName, MAX_PATH);

	while (INVALID_HANDLE_VALUE == hNamedPipe) { /* Pobieranie uchwytu egzemplarza potoku nazwanego. */
		if (!WaitNamedPipe (serverPipeName, NMPWAIT_WAIT_FOREVER))
			ReportError (_T("Blad funkcji WaitNamedPipe."), 2, TRUE);
		/* Egzemplarz jest dostpny. Prba otwarcia go, zanim zrobi to 
		 * inny wtek lub serwer zamknie egzemplarz. */
		hNamedPipe = CreateFile (serverPipeName, GENERIC_READ | GENERIC_WRITE, 0, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	}

	/*  Wczytywanie uchwytu potoku nazwanego w trybie komunikatw i z oczekiwaniem. Warto zauway, 
     * e drugi argument to adres, a nie warto. Klient i serwer mog dziaa na tym samym komputerze, dlatego
     * nie naley ustawia trybu kolekcji i limitu czasu (dwa ostatnie argumenty).
	 */
	if (!SetNamedPipeHandleState (hNamedPipe, &npMode, NULL, NULL))
		ReportError (_T("Blad funkcji SetNamedPipeHandleState."), 2, TRUE);
	/* Pytanie uytkownika o polecenia. $Koniec oznacza koniec pracy. */
	request.rqLen = RQ_SIZE;
	while (ConsolePrompt (_T ("\nWpisz polecenie: "), request.record, MAX_RQRS_LEN-1, TRUE)
			&& (_tcscmp (request.record, quitMsg) != 0)) {

		if (!WriteFile (hNamedPipe, &request, RQ_SIZE, &nWrite, NULL))
			ReportError (_T ("Nieudany zapis do potoku."), 0, TRUE);

		/* Wczytywanie kadej odpowiedzi i wysyanie jej do standardowego wyjcia. */
		while (ReadFile (hNamedPipe, &response, RS_SIZE, &nRead, NULL))
		{
			if (response.rsLen <= 1) { /* Dugo 0 oznacza koniec odpowiedzi. */ break; }
			_tprintf (_T("%s"), response.record);
		}
	}

	_tprintf (_T("Otrzymano polecenie zakonczenia. Zrywanie polaczenia.\n"));

	CloseHandle (hNamedPipe);
	return 0;
}
