/* Czciowa implementacja UNIX-owego polecenia wc. */
/* Zlicza wiersze, sowa i znaki ze standardowego wejcia. */
/* To program zilustrowany na rysunku 18. w "Using Program
	Slicing in Software Maintenance" K.B. Gallaghera i
	J.R. Lyle'a, IEEE Transactions on Software Engineering,
	Vol 17, No 8, sierpie 1991. */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

int _tmain (int argc, char * argv[])
{
	FILE * fin;
	int ch, c, nl, nw, nc;

	if (argc == 1) fin = stdin;
	else fin = fopen (argv[1], "r");
	if (fin == NULL) 
		perror ("wc: plik\n");

	ch = nw = nc = nl = 0;
	while (!feof (fin) /* c != EOF */ ) {
		c = getc (fin);
		if (c == '\0') break;
		if (isspace(c) && isalpha(ch))
			nw = nw + 1;
		ch = c;
		nc = nc + 1;
		if (c == '\n')
			nl = nl + 1;
	}
	if (fin != stdin) fclose (fin);
	printf ("\n %d %d %d\n", nl, nw, nc);
	return 0;
}