#include "Everything.h"

int _tmain (int argc, LPTSTR argv [])

/* czy potokiem dwa programy, ktrych nazwy podano w wierszu polece:
		Redirect polecenie1 = polecenie2
	Oba polecenia to dowolne acuchy.
	polecenie1 korzysta ze standardowego wejcia, a polecenie2 - ze standardowego wyjcia.
	Trzeba uy znaku =, aby unikn konfliktu z potokiem systemu DOS. */
{
	DWORD i;
	HANDLE hReadPipe, hWritePipe;
	TCHAR command1 [MAX_PATH];
	SECURITY_ATTRIBUTES pipeSA = {sizeof (SECURITY_ATTRIBUTES), NULL, TRUE};
			/* Inicjowanie pod ktem uchwytw umoliwiajcych dziedziczenie */
		
	PROCESS_INFORMATION procInfo1, procInfo2;
	STARTUPINFO startInfoCh1, startInfoCh2;
	LPTSTR targv = GetCommandLine ();

	/* Informacje pocztkowe dla dwch procesw podrzdnych */

	GetStartupInfo (&startInfoCh1);
	GetStartupInfo (&startInfoCh2);

	if (targv == NULL)
		ReportError (_T ("\nNie mozna odczytac wiersza polecen."), 1, TRUE);
	targv = SkipArg (targv);
	i = 0;		/* Pobieranie obu polece. */
	while (*targv != _T('=') && *targv != _T('\0')) {
		command1 [i] = *targv;
		targv++; i++;
	}
	command1 [i] = _T('\0');
	if (*targv == _T('\0'))
		ReportError (_T("Nie znaleziono separatora polecen."), 2, FALSE);
	targv = SkipArg (targv);

	/* Tworzenie potoku anonimowego  domylny rozmiar i uchwyty umoliwiajce dziedziczenie. */

	if (!CreatePipe (&hReadPipe, &hWritePipe, &pipeSA, 0))
		ReportError (_T ("Nieudane tworzenie potoku anonimowego."), 3, TRUE);

	/* Przypisywanie do uchwytu wyjcia dziedziczonego uchwytu potoku i
       tworzenie pierwszego procesu.
 */

	startInfoCh1.hStdInput  = GetStdHandle (STD_INPUT_HANDLE);
	startInfoCh1.hStdError  = GetStdHandle (STD_ERROR_HANDLE);
	startInfoCh1.hStdOutput = hWritePipe;
	startInfoCh1.dwFlags = STARTF_USESTDHANDLES;

	if (!CreateProcess (NULL, command1, NULL, NULL,
			TRUE,			/* Dziedziczenie uchwytw. */
			0, NULL, NULL, &startInfoCh1, &procInfo1)) {
		ReportError (_T ("Nieudane tworzenie procesu 1."), 4, TRUE);
	}
	CloseHandle (procInfo1.hThread);
	CloseHandle (hWritePipe);

	/* Symetryczne powtarzanie operacji dla drugiego procesu. */

	startInfoCh2.hStdInput  = hReadPipe;
	startInfoCh2.hStdError  = GetStdHandle (STD_ERROR_HANDLE);
	startInfoCh2.hStdOutput = GetStdHandle (STD_OUTPUT_HANDLE);
	startInfoCh2.dwFlags = STARTF_USESTDHANDLES;

	if (!CreateProcess (NULL, targv, NULL, NULL,
			TRUE,			/* Dziedziczenie uchwytw. */
			0, NULL, NULL, &startInfoCh2, &procInfo2))
		ReportError (_T ("Nieudane tworzenie procesu 2."), 5, TRUE);
	CloseHandle (procInfo2.hThread); 
	CloseHandle (hReadPipe);

	/* Oczekiwanie na zakoczenie dziaania przez oba procesy.
       Najpierw prac powinien zakoczy wtek pierwszy, ale nie ma to znaczenia. */

	WaitForSingleObject (procInfo1.hProcess, INFINITE);
	WaitForSingleObject (procInfo2.hProcess, INFINITE);
	CloseHandle (procInfo1.hProcess); 
	CloseHandle (procInfo2.hProcess);
	return 0;
}
