/* Rozdzia 11. LocSrver.c */

/* Znajduje serwer przez odczyt szczeliny pocztowej uywanej do rozpowszechniania nazw serwerw. */
/* Ta funkcja ilustruje klienta szczeliny pocztowej. */

#include "Everything.h"
		/* Nazwa szczeliny jest zdefiniowana w pliku "ClientServer.h". */
#include "ClientServer.h"

BOOL LocateServer (LPTSTR pPipeName, DWORD size)
{
	/* pPipeName ma miejsce na "size" znakw. */
	HANDLE hMailSlot;
	MS_MESSAGE serverMsg;
	BOOL found = FALSE;
	DWORD cbRead;

	hMailSlot = CreateMailslot (MS_SRVNAME, 0, CS_TIMEOUT, NULL);
		if (hMailSlot == INVALID_HANDLE_VALUE)
			ReportError (_T ("Blad tworzenia szczeliny."), 11, TRUE);

	/* Komunikacja z serwerem w celu upewnienia si, e dziaa.
		Serwer potrzebuje czasu na znalezienie szczeliny i przesanie nazwy potoku. */
	
	while (!found) {
		_tprintf (_T ("Wyszukiwanie serwera.\n"));
		found = ReadFile (hMailSlot, &serverMsg, sizeof(serverMsg), &cbRead, NULL);
	}

	if (found) _tprintf (_T ("Znaleziono serwer. Nazwa potoku: %s.\n"), serverMsg.msName);
	else _tprintf (_T ("NIE znaleziono serwera.\n"));

	/* Zamykanie szczeliny. */

	CloseHandle (hMailSlot);
	if (found) {
		pPipeName[MAX_PATH] = _T('\0');
		/* Niepowodzenie, jeli nazwa potoku nie mieci si w udostpnionym buforze. */
		found = (_tcsncpy_s (pPipeName, size, serverMsg.msName, size) == 0);
	}
	return found;
}
