/* Rozdzia 10. testTHB.c	  			*/
/* Testowanie bariery z progiem.		*/

#include "Everything.h"
#include "synchobj.h"
#include <time.h>
#define DELAY_COUNT 100
#define MAX_THREADS 1024

/*  Stosowanie: test_thb liczbaWtkw prg			   					*/
/* Uruchamia do liczbaWtkw wtkw roboczych. Kady z nich oczekuje	*/
/* za pomoc bariery na dotarcie do niej wystarczajcej liczby wtkw.	*/
/* Nastpnie wszystkie wtki przystpuj do dziaania. Wtki rejestruj	*/
/* czas dojcia do bariery i przejcia poza ni.						*/

DWORD WINAPI worker (PVOID);

typedef struct _THARG {
	int tNumber;
	THRESHOLD_BARRIER *pBarrier;
	char waste [8]; 
} THARG;

int _tmain (int argc, LPTSTR argv[])
{
	int tStatus, nThread, iThread, bValue;
	HANDLE *hWorker;
	THB_OBJECT oBarrier;
	THARG * tArg;
	
	if (!WindowsVersionOK (4, 0)) 
		ReportError (_T("Ten program wymaga systemu Windows NT 4.0 lub nowszego."), 1, FALSE);

	if (argc != 3) {
		_tprintf (_T("Stosowanie: test_thb liczbaWatkow prog\n"));
		return 1;
	}
		
	srand ((DWORD)time(NULL)); /* Inicjowanie generatora liczb losowych. 	*/

	nThread = _ttoi(argv[1]);
	if (nThread > MAX_THREADS) {
		_tprintf (_T("Maksymalna liczba watkow to %d.\n"), MAX_THREADS);
		return 2;
	}
	bValue = _ttoi(argv[2]);
	hWorker = malloc (nThread * sizeof(HANDLE));
	tArg = calloc (nThread, sizeof (THARG));
	if (hWorker == NULL || tArg == NULL)
		ReportError (_T("Nie mozna zaalokowac pamieci."), 1, TRUE);
	
	tStatus = CreateThresholdBarrier (&oBarrier, bValue);
	
	for (iThread = 0; iThread < nThread; iThread++) {
		/* Zapenianie argumentu wtku. */
		tArg[iThread].tNumber = iThread;
		tArg[iThread].pBarrier = oBarrier;
		hWorker[iThread] = (HANDLE)_beginthreadex (NULL, 0, worker, 
			&tArg[iThread], 0, NULL);
		if (hWorker[iThread] == NULL) 
			ReportError (_T("Nie mozna utworzyc watku konsumenta."), 2, TRUE);
		Sleep(rand()/10);
	}
	
	/* Oczekiwanie na zakoczenie pracy przez wtki. */
	WaitForMultipleObjects (nThread, hWorker, TRUE, INFINITE);
	free (hWorker);
	_tprintf (_T("Watki robocze zakonczyly dzialanie.\n"));
	free (tArg);
	_tprintf (_T("Wynik zamkniecia bariery. %d\n"), CloseThresholdBarrier (oBarrier));
	return 0;
}

DWORD WINAPI worker (PVOID arg)
{
	THARG * tArg;
	int iThread, tStatus;
	time_t tStart, tEnd;

	tArg = (THARG *)arg;	
	iThread = tArg->tNumber;

	tStart = time(NULL);	
	_tprintf (_T("Poczatek: watek numer %d %s"), iThread, ctime (&tStart));

	tStatus = WaitThresholdBarrier (tArg->pBarrier);
	if (tStatus != 0) ReportError (_T("Blad oczekiwania na bariere z progiem."), 9, TRUE);

	tEnd = time(NULL);
	_tprintf (_T("Koniec:   watek numer %d %s"), iThread, ctime (&tEnd));
	return 0;		
}

