/* Rozdzia 10. pcstats.c									*/
/*															*/
/* Funkcje DLL do zbierania i wywietlania statystyk		*/
/* na temat wygenerowanych i skonsumowanych komunikatw.	*/

#include <time.h>
#include "Everything.h"
#include "messages.h"
#include "pcstats.h"

/************************************************************************/

LIBSPEC_STATS void accumulate_statistics ()
{
	/* Obliczanie statystyk na temat komunikatw przetworzonych przez wtek.	*/
	/* Trzeba zaj muteks bloku komunikatu.			*/
	DWORD i, tcheck = 0;
	statistics_t * ps;
	MSG_BLOCK *pmb;


	ps = TlsGetValue (ts_index);
	if (ps == NULL) ReportError (_T("Nie mozna pobrac wartosci ps."), 21, TRUE);
	pmb = ps->pmblock;
	if (ps->nmsgs == 0) {
		ps->firstmsg = pmb->timestamp;
		ps->data_sum = 0.0;
	}
	ps->lastmsg = pmb->timestamp;
	ps->nmsgs++;
	
	for (i = 0; i < DATA_SIZE; i++) {
		tcheck |= pmb->data[i];
		ps->data_sum += (double)(pmb->data[i]);
	}
	
	if (tcheck == pmb->checksum)
		ps->ngood++;
	else
		ps->nbad++;		
	return;

}

LIBSPEC_STATS void report_statistics (void)
{ 
	/* Informowanie o pracy wykonanej przez wtek. */
	DWORD tcheck = 0;
	statistics_t * ps;
	double average, rate;
	time_t elapsed_time;

	ps = TlsGetValue (ts_index);
	_tprintf (_T("\n*** Ostateczny raport wedlug numerow watkow roboczych: %d\n"),
		ps->th_number);
	_tprintf (_T("    Przetworzone komunikat = %6d. %6d dobrych i %d zlych.\n"),
		ps->nmsgs, ps->ngood, ps->nbad);
	_tprintf (_T("    Pierwszy komunikat: %s"),   ctime (&ps->firstmsg));
	_tprintf (_T("    Ostatni komunikat : %s"), ctime (&ps->lastmsg ));
	elapsed_time = ps->lastmsg - ps->firstmsg;
	if (elapsed_time > 0) {
	rate = (double)ps->nmsgs / elapsed_time;
	_tprintf (_T("Czas dziala w sekundach: %d. Szybkosc przetwarzania komunikatow = %10.2f\n"),
		elapsed_time, rate);
	}
	
	if (ps->nmsgs > 0) {
		average = (ps->data_sum) /((ps->nmsgs) * DATA_SIZE);
		_tprintf (_T("Srednia wartosc: %15g\n"), average);		
	}
}

